/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonar.core.platform.ExtensionContainer;
import org.sonar.scanner.bootstrap.ExtensionMatcher;

public abstract class AbstractExtensionDictionary {
    private final ExtensionContainer componentContainer;

    protected AbstractExtensionDictionary(ExtensionContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    public <T> Collection<T> select(Class<T> type, boolean sort, @Nullable ExtensionMatcher matcher) {
        List<T> result = this.getFilteredExtensions(type, matcher);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    private static Phase.Name evaluatePhase(Object extension) {
        Phase phaseAnnotation = AnnotationUtils.getAnnotation(extension, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    protected <T> List<T> getFilteredExtensions(Class<T> type, @Nullable ExtensionMatcher matcher) {
        ArrayList<T> result = new ArrayList<T>();
        for (T extension : this.getExtensions(type)) {
            if (!AbstractExtensionDictionary.shouldKeep(type, extension, matcher)) continue;
            result.add(extension);
        }
        return result;
    }

    private <T> List<T> getExtensions(Class<T> type) {
        ArrayList extensions = new ArrayList();
        AbstractExtensionDictionary.completeScannerExtensions(this.componentContainer, extensions, type);
        return extensions;
    }

    private static <T> void completeScannerExtensions(ExtensionContainer container, List<T> extensions, Class<T> type) {
        extensions.addAll(container.getComponentsByType(type));
        ExtensionContainer parentContainer = container.getParent();
        if (parentContainer != null) {
            AbstractExtensionDictionary.completeScannerExtensions(parentContainer, extensions, type);
        }
    }

    protected <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : this.getDependencies(extension)) {
                dag.add(extension, dependency);
            }
            for (Object generates : this.getDependents(extension)) {
                dag.add(generates, extension);
            }
            AbstractExtensionDictionary.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return sortedList.stream().filter(extensions::contains).collect(Collectors.toList());
    }

    private <T> List<Object> getDependencies(T extension) {
        return new ArrayList<Object>(this.evaluateAnnotatedClasses(extension, DependsUpon.class));
    }

    private <T> List<Object> getDependents(T extension) {
        return new ArrayList<Object>(this.evaluateAnnotatedClasses(extension, DependedUpon.class));
    }

    private static void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = AbstractExtensionDictionary.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo(name) < 0) {
                dag.add((Object)name, extension);
                continue;
            }
            if (phase.compareTo(name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    public List<Object> evaluateAnnotatedClasses(Object extension, Class<? extends Annotation> annotation) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            AbstractExtensionDictionary.evaluateClass(aClass, annotation, results);
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                AbstractExtensionDictionary.checkAnnotatedMethod(method);
                this.evaluateMethod(extension, method, results);
            }
        }
        return results;
    }

    private static void evaluateClass(Class<?> extensionClass, Class<? extends Annotation> annotationClass, List<Object> results) {
        Class<?>[] interfaces;
        Annotation annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            AbstractExtensionDictionary.evaluateClass(anInterface, annotationClass, results);
        }
    }

    private void evaluateMethod(Object extension, Method method, List<Object> results) {
        try {
            Object result = method.invoke(extension, new Object[0]);
            if (result != null) {
                if (result instanceof Class) {
                    results.addAll(this.componentContainer.getComponentsByType((Class)result));
                } else if (result instanceof Collection) {
                    results.addAll((Collection)result);
                } else if (result.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(result); ++i) {
                        results.add(Array.get(result, i));
                    }
                } else {
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not invoke method " + method, e);
        }
    }

    private static void checkAnnotatedMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("Annotated method must be public:" + method);
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Annotated method must not have parameters:" + method);
        }
    }

    private static boolean shouldKeep(Class<?> type, Object extension, @Nullable ExtensionMatcher matcher) {
        return ClassUtils.isAssignable(extension.getClass(), type) && (matcher == null || matcher.accept(extension));
    }
}

