/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class AzureDevops
implements CiVendor {
    private final System2 system;

    public AzureDevops(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return "Azure DevOps";
    }

    @Override
    public boolean isDetected() {
        return "true".equalsIgnoreCase(this.system.envVariable("TF_BUILD"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable("SYSTEM_PULLREQUEST_SOURCECOMMITID");
        if (StringUtils.isBlank(revision)) {
            revision = this.system.envVariable("BUILD_SOURCEVERSION");
        }
        return new CiConfigurationImpl(revision, this.getName());
    }
}

