/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import java.util.Optional;
import org.sonar.api.utils.System2;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class Bitrise
implements CiVendor {
    private final System2 system2;

    public Bitrise(System2 system2) {
        this.system2 = system2;
    }

    @Override
    public String getName() {
        return "Bitrise";
    }

    @Override
    public boolean isDetected() {
        return this.environmentVariableIsTrue("CI") && this.environmentVariableIsTrue("BITRISE_IO");
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system2.envVariable("BITRISE_GIT_COMMIT");
        return new CiConfigurationImpl(revision, this.getName());
    }

    private boolean environmentVariableIsTrue(String key) {
        return Optional.ofNullable(this.system2.envVariable(key)).map(Boolean::parseBoolean).orElse(false);
    }
}

