/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.scanner.protocol.output.ScannerReport;

@ThreadSafe
public class DefaultFilterableIssue
implements FilterableIssue {
    private final ScannerReport.Issue rawIssue;
    private final InputComponent component;
    private DefaultInputProject project;

    public DefaultFilterableIssue(DefaultInputProject project, ScannerReport.Issue rawIssue, InputComponent component) {
        this.project = project;
        this.rawIssue = rawIssue;
        this.component = component;
    }

    @Override
    public String componentKey() {
        return this.component.key();
    }

    @Override
    public RuleKey ruleKey() {
        return RuleKey.of(this.rawIssue.getRuleRepository(), this.rawIssue.getRuleKey());
    }

    @Override
    public String severity() {
        return this.rawIssue.getSeverity().name();
    }

    @Override
    public String message() {
        return this.rawIssue.getMsg();
    }

    @Override
    @Deprecated
    public Integer line() {
        return this.rawIssue.hasTextRange() ? Integer.valueOf(this.rawIssue.getTextRange().getStartLine()) : null;
    }

    @Override
    public TextRange textRange() {
        if (!this.rawIssue.hasTextRange()) {
            return null;
        }
        return new DefaultTextRange(new DefaultTextPointer(this.rawIssue.getTextRange().getStartLine(), this.rawIssue.getTextRange().getStartOffset()), new DefaultTextPointer(this.rawIssue.getTextRange().getEndLine(), this.rawIssue.getTextRange().getEndOffset()));
    }

    @Override
    public Double gap() {
        return Double.compare(this.rawIssue.getGap(), 0.0) != 0 ? Double.valueOf(this.rawIssue.getGap()) : null;
    }

    @Override
    public String projectKey() {
        return this.project.key();
    }

    public InputComponent getComponent() {
        return this.component;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

