/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueFlow;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;

@ThreadSafe
public class IssuePublisher {
    private final ActiveRules activeRules;
    private final IssueFilters filters;
    private final ReportPublisher reportPublisher;

    public IssuePublisher(ActiveRules activeRules, IssueFilters filters, ReportPublisher reportPublisher) {
        this.activeRules = activeRules;
        this.filters = filters;
        this.reportPublisher = reportPublisher;
    }

    public boolean initAndAddIssue(Issue issue) {
        DefaultInputComponent inputComponent = (DefaultInputComponent)issue.primaryLocation().inputComponent();
        if (IssuePublisher.noSonar(inputComponent, issue)) {
            return false;
        }
        ActiveRule activeRule = this.activeRules.find(issue.ruleKey());
        if (activeRule == null) {
            return false;
        }
        ScannerReport.Issue rawIssue = IssuePublisher.createReportIssue(issue, inputComponent.scannerId(), activeRule.severity());
        if (this.filters.accept(inputComponent, rawIssue)) {
            this.write(inputComponent.scannerId(), rawIssue);
            return true;
        }
        return false;
    }

    private static boolean noSonar(DefaultInputComponent inputComponent, Issue issue) {
        TextRange textRange = issue.primaryLocation().textRange();
        return inputComponent.isFile() && textRange != null && ((DefaultInputFile)inputComponent).hasNoSonarAt(textRange.start().line()) && !StringUtils.containsIgnoreCase(issue.ruleKey().rule(), "nosonar");
    }

    public void initAndAddExternalIssue(ExternalIssue issue) {
        DefaultInputComponent inputComponent = (DefaultInputComponent)issue.primaryLocation().inputComponent();
        ScannerReport.ExternalIssue rawExternalIssue = IssuePublisher.createReportExternalIssue(issue, inputComponent.scannerId());
        this.write(inputComponent.scannerId(), rawExternalIssue);
    }

    private static String nullToEmpty(@Nullable String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private static ScannerReport.Issue createReportIssue(Issue issue, int componentRef, String activeRuleSeverity) {
        Double gap;
        String primaryMessage = IssuePublisher.nullToEmpty(issue.primaryLocation().message());
        Severity overriddenSeverity = issue.overriddenSeverity();
        Constants.Severity severity = overriddenSeverity != null ? Constants.Severity.valueOf(overriddenSeverity.name()) : Constants.Severity.valueOf(activeRuleSeverity);
        ScannerReport.Issue.Builder builder = ScannerReport.Issue.newBuilder();
        ScannerReport.IssueLocation.Builder locationBuilder = ScannerReport.IssueLocation.newBuilder();
        ScannerReport.TextRange.Builder textRangeBuilder = ScannerReport.TextRange.newBuilder();
        builder.setSeverity(severity);
        builder.setRuleRepository(issue.ruleKey().repository());
        builder.setRuleKey(issue.ruleKey().rule());
        builder.setMsg(primaryMessage);
        builder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setMsg(primaryMessage);
        locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setComponentRef(componentRef);
        TextRange primaryTextRange = issue.primaryLocation().textRange();
        if (primaryTextRange != null) {
            builder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, primaryTextRange));
        }
        if ((gap = issue.gap()) != null) {
            builder.setGap(gap);
        }
        IssuePublisher.applyFlows(builder::addFlow, locationBuilder, textRangeBuilder, issue.flows());
        builder.setQuickFixAvailable(issue.isQuickFixAvailable());
        issue.ruleDescriptionContextKey().ifPresent(builder::setRuleDescriptionContextKey);
        return builder.build();
    }

    private static List<ScannerReport.MessageFormatting> toProtobufMessageFormattings(List<MessageFormatting> messageFormattings) {
        return messageFormattings.stream().map(m -> ScannerReport.MessageFormatting.newBuilder().setStart(m.start()).setEnd(m.end()).setType(ScannerReport.MessageFormattingType.valueOf(m.type().name())).build()).collect(Collectors.toList());
    }

    private static ScannerReport.ExternalIssue createReportExternalIssue(ExternalIssue issue, int componentRef) {
        Long effort;
        String primaryMessage = issue.primaryLocation().message();
        Constants.Severity severity = Constants.Severity.valueOf(issue.severity().name());
        ScannerReport.IssueType issueType = ScannerReport.IssueType.valueOf(issue.type().name());
        ScannerReport.ExternalIssue.Builder builder = ScannerReport.ExternalIssue.newBuilder();
        ScannerReport.IssueLocation.Builder locationBuilder = ScannerReport.IssueLocation.newBuilder();
        ScannerReport.TextRange.Builder textRangeBuilder = ScannerReport.TextRange.newBuilder();
        builder.setSeverity(severity);
        builder.setType(issueType);
        builder.setEngineId(issue.engineId());
        builder.setRuleId(issue.ruleId());
        builder.setMsg(primaryMessage);
        builder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setMsg(primaryMessage);
        locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(issue.primaryLocation().messageFormattings()));
        locationBuilder.setComponentRef(componentRef);
        TextRange primaryTextRange = issue.primaryLocation().textRange();
        if (primaryTextRange != null) {
            builder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, primaryTextRange));
        }
        if ((effort = issue.remediationEffort()) != null) {
            builder.setEffort(effort);
        }
        IssuePublisher.applyFlows(builder::addFlow, locationBuilder, textRangeBuilder, issue.flows());
        return builder.build();
    }

    private static void applyFlows(Consumer<ScannerReport.Flow> consumer, ScannerReport.IssueLocation.Builder locationBuilder, ScannerReport.TextRange.Builder textRangeBuilder, Collection<Issue.Flow> flows) {
        ScannerReport.Flow.Builder flowBuilder = ScannerReport.Flow.newBuilder();
        for (Issue.Flow f : flows) {
            DefaultIssueFlow flow = (DefaultIssueFlow)f;
            if (flow.locations().isEmpty()) {
                return;
            }
            flowBuilder.clear();
            for (IssueLocation location : flow.locations()) {
                TextRange textRange;
                int locationComponentRef = ((DefaultInputComponent)location.inputComponent()).scannerId();
                locationBuilder.clear();
                locationBuilder.setComponentRef(locationComponentRef);
                String message = location.message();
                if (message != null) {
                    locationBuilder.setMsg(message);
                    locationBuilder.addAllMsgFormatting(IssuePublisher.toProtobufMessageFormattings(location.messageFormattings()));
                }
                if ((textRange = location.textRange()) != null) {
                    locationBuilder.setTextRange(IssuePublisher.toProtobufTextRange(textRangeBuilder, textRange));
                }
                flowBuilder.addLocation(locationBuilder.build());
            }
            if (flow.description() != null) {
                flowBuilder.setDescription(flow.description());
            }
            flowBuilder.setType(IssuePublisher.toProtobufFlowType(flow.type()));
            consumer.accept(flowBuilder.build());
        }
    }

    private static ScannerReport.FlowType toProtobufFlowType(NewIssue.FlowType flowType) {
        switch (flowType) {
            case EXECUTION: {
                return ScannerReport.FlowType.EXECUTION;
            }
            case DATA: {
                return ScannerReport.FlowType.DATA;
            }
            case UNDEFINED: {
                return ScannerReport.FlowType.UNDEFINED;
            }
        }
        throw new IllegalArgumentException("Unrecognized flow type: " + flowType);
    }

    private static ScannerReport.TextRange toProtobufTextRange(ScannerReport.TextRange.Builder textRangeBuilder, TextRange primaryTextRange) {
        textRangeBuilder.clear();
        textRangeBuilder.setStartLine(primaryTextRange.start().line());
        textRangeBuilder.setStartOffset(primaryTextRange.start().lineOffset());
        textRangeBuilder.setEndLine(primaryTextRange.end().line());
        textRangeBuilder.setEndOffset(primaryTextRange.end().lineOffset());
        return textRangeBuilder.build();
    }

    public void write(int batchId, ScannerReport.Issue rawIssue) {
        this.reportPublisher.getWriter().appendComponentIssue(batchId, rawIssue);
    }

    public void write(int batchId, ScannerReport.ExternalIssue rawIssue) {
        this.reportPublisher.getWriter().appendComponentExternalIssue(batchId, rawIssue);
    }
}

