/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.System2;

public class DefaultAnalysisWarnings
implements AnalysisWarnings {
    private final System2 system2;
    private final List<Message> messages = new ArrayList<Message>();
    private final Set<String> seen = new HashSet<String>();

    public DefaultAnalysisWarnings(System2 system2) {
        this.system2 = system2;
    }

    @Override
    public void addUnique(String text) {
        if (this.seen.add(text)) {
            this.messages.add(new Message(text, this.system2.now()));
        }
    }

    public List<Message> warnings() {
        return Collections.unmodifiableList(this.messages);
    }

    @Immutable
    public static class Message {
        private final String text;
        private final long timestamp;

        Message(String text, long timestamp) {
            Preconditions.checkArgument(!text.isEmpty(), "Text can't be empty");
            this.text = text;
            this.timestamp = timestamp;
        }

        public String getText() {
            return this.text;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

