/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.postjob;

import java.util.Collection;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.PostJobExtensionDictionary;
import org.sonar.scanner.postjob.PostJobWrapper;

public class PostJobsExecutor {
    private static final Logger LOG = Loggers.get(PostJobsExecutor.class);
    private final PostJobExtensionDictionary selector;

    public PostJobsExecutor(PostJobExtensionDictionary selector) {
        this.selector = selector;
    }

    public void execute() {
        Collection<PostJobWrapper> postJobs = this.selector.selectPostJobs();
        PostJobsExecutor.execute(postJobs);
    }

    private static void execute(Collection<PostJobWrapper> postJobs) {
        PostJobsExecutor.logPostJobs(postJobs);
        for (PostJobWrapper postJob : postJobs) {
            if (!postJob.shouldExecute()) continue;
            LOG.info("Executing post-job '{}'", (Object)postJob);
            postJob.execute();
        }
    }

    private static void logPostJobs(Collection<PostJobWrapper> postJobs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(() -> "Post-jobs : " + postJobs.stream().map(Object::toString).collect(Collectors.joining(" -> ")));
        }
    }
}

