/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.language;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Language {
    private final String key;
    private final String name;
    private final boolean publishAllFiles;
    private final String[] fileSuffixes;

    public Language(String key, String name, boolean publishAllFiles, String ... fileSuffixes) {
        this.key = key;
        this.name = name;
        this.publishAllFiles = publishAllFiles;
        this.fileSuffixes = fileSuffixes;
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public Collection<String> fileSuffixes() {
        return Arrays.asList(this.fileSuffixes);
    }

    public boolean isPublishAllFiles() {
        return this.publishAllFiles;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language language = (Language)o;
        return Objects.equals(this.key, language.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

