/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DeprecatedPropertiesWarningGenerator {
    private static final Logger LOG = Loggers.get(DeprecatedPropertiesWarningGenerator.class);
    @VisibleForTesting
    public static final String PASSWORD_WARN_MESSAGE = "Property 'sonar.password' is deprecated. It will not be supported in the future. Please instead use the 'sonar.login' parameter with a token.";
    private final Configuration configuration;
    private final AnalysisWarnings analysisWarnings;

    public DeprecatedPropertiesWarningGenerator(Configuration configuration, AnalysisWarnings analysisWarnings) {
        this.configuration = configuration;
        this.analysisWarnings = analysisWarnings;
    }

    public void execute() {
        Optional<String> password = this.configuration.get("sonar.password");
        if (password.isPresent()) {
            LOG.warn(PASSWORD_WARN_MESSAGE);
            this.analysisWarnings.addUnique(PASSWORD_WARN_MESSAGE);
        }
    }
}

