/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.scan.MutableProjectSettings;
import org.sonar.scanner.scan.ProjectConfiguration;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.springframework.context.annotation.Bean;

public class ProjectConfigurationProvider {
    private final SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter;

    public ProjectConfigurationProvider(SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter) {
        this.sonarGlobalPropertiesFilter = sonarGlobalPropertiesFilter;
    }

    @Bean(value={"ProjectConfiguration"})
    public ProjectConfiguration provide(DefaultInputProject project, GlobalConfiguration globalConfig, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings, MutableProjectSettings projectSettings) {
        Map<String, String> settings = new LinkedHashMap<String, String>();
        settings.putAll(globalServerSettings.properties());
        settings.putAll(projectServerSettings.properties());
        settings.putAll(project.properties());
        settings = this.sonarGlobalPropertiesFilter.enforceOnlyServerSideSonarGlobalPropertiesAreUsed(settings, globalServerSettings.properties());
        ProjectConfiguration projectConfig = new ProjectConfiguration(globalConfig.getDefinitions(), globalConfig.getEncryption(), settings);
        projectSettings.complete(projectConfig);
        return projectConfig;
    }
}

