/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.scanner.scan.branch.BranchInfo;

@Immutable
public class ProjectBranches {
    private static final String DEFAULT_MAIN_BRANCH_NAME = "main";
    private final Map<String, BranchInfo> branches = new HashMap<String, BranchInfo>();
    private final String defaultBranchName;

    public ProjectBranches(List<BranchInfo> branchInfos) {
        String mainBranchName = null;
        for (BranchInfo branch : branchInfos) {
            String branchName = branch.name();
            this.branches.put(branchName, branch);
            if (!branch.isMain()) continue;
            mainBranchName = branchName;
        }
        this.defaultBranchName = Objects.requireNonNullElse(mainBranchName, DEFAULT_MAIN_BRANCH_NAME);
    }

    @CheckForNull
    public BranchInfo get(String name) {
        return this.branches.get(name);
    }

    public boolean isEmpty() {
        return this.branches.isEmpty();
    }

    public String defaultBranchName() {
        return this.defaultBranchName;
    }
}

