/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.ModuleConfigurationProvider;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.ModuleCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.util.ProgressReport;

public class ProjectFileIndexer {
    private static final Logger LOG = Loggers.get(ProjectFileIndexer.class);
    private final ProjectExclusionFilters projectExclusionFilters;
    private final SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter;
    private final ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions;
    private final ScmConfiguration scmConfiguration;
    private final InputComponentStore componentStore;
    private final InputModuleHierarchy inputModuleHierarchy;
    private final GlobalConfiguration globalConfig;
    private final GlobalServerSettings globalServerSettings;
    private final ProjectServerSettings projectServerSettings;
    private final FileIndexer fileIndexer;
    private final IgnoreCommand ignoreCommand;
    private final boolean useScmExclusion;
    private final AnalysisWarnings analysisWarnings;
    private ProgressReport progressReport;

    public ProjectFileIndexer(InputComponentStore componentStore, ProjectExclusionFilters exclusionFilters, SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter, InputModuleHierarchy inputModuleHierarchy, GlobalConfiguration globalConfig, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings, FileIndexer fileIndexer, ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions, ScmConfiguration scmConfiguration, AnalysisWarnings analysisWarnings) {
        this.componentStore = componentStore;
        this.sonarGlobalPropertiesFilter = sonarGlobalPropertiesFilter;
        this.inputModuleHierarchy = inputModuleHierarchy;
        this.globalConfig = globalConfig;
        this.globalServerSettings = globalServerSettings;
        this.projectServerSettings = projectServerSettings;
        this.fileIndexer = fileIndexer;
        this.projectExclusionFilters = exclusionFilters;
        this.projectCoverageAndDuplicationExclusions = projectCoverageAndDuplicationExclusions;
        this.scmConfiguration = scmConfiguration;
        this.analysisWarnings = analysisWarnings;
        this.ignoreCommand = this.loadIgnoreCommand();
        this.useScmExclusion = this.ignoreCommand != null;
    }

    public void index() {
        this.progressReport = new ProgressReport("Report about progress of file indexation", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start("Indexing files...");
        LOG.info("Project configuration:");
        this.projectExclusionFilters.log("  ");
        this.projectCoverageAndDuplicationExclusions.log("  ");
        ExclusionCounter exclusionCounter = new ExclusionCounter();
        if (this.useScmExclusion) {
            this.ignoreCommand.init(this.inputModuleHierarchy.root().getBaseDir().toAbsolutePath());
            this.indexModulesRecursively(this.inputModuleHierarchy.root(), exclusionCounter);
            this.ignoreCommand.clean();
        } else {
            this.indexModulesRecursively(this.inputModuleHierarchy.root(), exclusionCounter);
        }
        int totalIndexed = this.componentStore.inputFiles().size();
        this.progressReport.stop(totalIndexed + " " + ProjectFileIndexer.pluralizeFiles(totalIndexed) + " indexed");
        int excludedFileByPatternCount = exclusionCounter.getByPatternsCount();
        if (this.projectExclusionFilters.hasPattern() || excludedFileByPatternCount > 0) {
            LOG.info("{} {} ignored because of inclusion/exclusion patterns", (Object)excludedFileByPatternCount, (Object)ProjectFileIndexer.pluralizeFiles(excludedFileByPatternCount));
        }
        int excludedFileByScmCount = exclusionCounter.getByScmCount();
        if (this.useScmExclusion) {
            LOG.info("{} {} ignored because of scm ignore settings", (Object)excludedFileByScmCount, (Object)ProjectFileIndexer.pluralizeFiles(excludedFileByScmCount));
        }
    }

    private IgnoreCommand loadIgnoreCommand() {
        try {
            if (!this.scmConfiguration.isExclusionDisabled() && this.scmConfiguration.provider() != null) {
                return this.scmConfiguration.provider().ignoreCommand();
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("File exclusion based on SCM ignore information is not available with this plugin.");
        }
        return null;
    }

    private void indexModulesRecursively(DefaultInputModule module, ExclusionCounter exclusionCounter) {
        this.inputModuleHierarchy.children(module).stream().sorted(Comparator.comparing(AbstractProjectOrModule::key)).forEach(m -> this.indexModulesRecursively((DefaultInputModule)m, exclusionCounter));
        this.index(module, exclusionCounter);
    }

    private void index(DefaultInputModule module, ExclusionCounter exclusionCounter) {
        ModuleConfiguration moduleConfig = new ModuleConfigurationProvider(this.sonarGlobalPropertiesFilter).provide(this.globalConfig, module, this.globalServerSettings, this.projectServerSettings);
        ModuleExclusionFilters moduleExclusionFilters = new ModuleExclusionFilters(moduleConfig, this.analysisWarnings);
        ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions = new ModuleCoverageAndDuplicationExclusions(moduleConfig);
        if (this.componentStore.allModules().size() > 1) {
            LOG.info("Indexing files of module '{}'", (Object)module.getName());
            LOG.info("  Base dir: {}", (Object)module.getBaseDir().toAbsolutePath());
            module.getSourceDirsOrFiles().ifPresent(srcs -> ProjectFileIndexer.logPaths("  Source paths: ", module.getBaseDir(), srcs));
            module.getTestDirsOrFiles().ifPresent(tests -> ProjectFileIndexer.logPaths("  Test paths: ", module.getBaseDir(), tests));
            moduleExclusionFilters.log("  ");
            moduleCoverageAndDuplicationExclusions.log("  ");
        }
        boolean hasChildModules = !module.definition().getSubProjects().isEmpty();
        boolean hasTests = module.getTestDirsOrFiles().isPresent();
        List mainSourceDirsOrFiles = module.getSourceDirsOrFiles().orElseGet(() -> hasChildModules || hasTests ? Collections.emptyList() : Collections.singletonList(module.getBaseDir().toAbsolutePath()));
        this.indexFiles(module, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, mainSourceDirsOrFiles, InputFile.Type.MAIN, exclusionCounter);
        module.getTestDirsOrFiles().ifPresent(tests -> this.indexFiles(module, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, (List<Path>)tests, InputFile.Type.TEST, exclusionCounter));
    }

    private static void logPaths(String label, Path baseDir, List<Path> paths) {
        if (!paths.isEmpty()) {
            StringBuilder sb = new StringBuilder(label);
            Iterator<Path> it = paths.iterator();
            while (it.hasNext()) {
                Path file = it.next();
                Optional<String> relativePathToBaseDir = PathResolver.relativize(baseDir, file);
                if (!relativePathToBaseDir.isPresent()) {
                    sb.append(file);
                } else if (StringUtils.isBlank(relativePathToBaseDir.get())) {
                    sb.append(".");
                } else {
                    sb.append(relativePathToBaseDir.get());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(sb.toString());
            } else {
                LOG.info(StringUtils.abbreviate(sb.toString(), 80));
            }
        }
    }

    private static String pluralizeFiles(int count) {
        return count == 1 ? "file" : "files";
    }

    private void indexFiles(DefaultInputModule module, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, List<Path> sources, InputFile.Type type, ExclusionCounter exclusionCounter) {
        try {
            for (Path dirOrFile : sources) {
                if (dirOrFile.toFile().isDirectory()) {
                    this.indexDirectory(module, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, dirOrFile, type, exclusionCounter);
                    continue;
                }
                this.fileIndexer.indexFile(module, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, dirOrFile, type, this.progressReport, exclusionCounter, this.ignoreCommand);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index files", e);
        }
    }

    private void indexDirectory(DefaultInputModule module, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, Path dirToIndex, InputFile.Type type, ExclusionCounter exclusionCounter) throws IOException {
        Files.walkFileTree(dirToIndex.normalize(), Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new IndexFileVisitor(module, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, type, exclusionCounter));
    }

    private static boolean isExcludedDirectory(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectBaseDir, Path moduleBaseDir, InputFile.Type type) {
        Path projectRelativePath = projectBaseDir.relativize(realAbsoluteFile);
        Path moduleRelativePath = moduleBaseDir.relativize(realAbsoluteFile);
        return moduleExclusionFilters.isExcludedAsParentDirectoryOfExcludedChildren(realAbsoluteFile, projectRelativePath, projectBaseDir, type) || moduleExclusionFilters.isExcludedAsParentDirectoryOfExcludedChildren(realAbsoluteFile, moduleRelativePath, moduleBaseDir, type);
    }

    static class ExclusionCounter {
        private final AtomicInteger excludedByPatternsCount = new AtomicInteger(0);
        private final AtomicInteger excludedByScmCount = new AtomicInteger(0);

        ExclusionCounter() {
        }

        public void increaseByPatternsCount() {
            this.excludedByPatternsCount.incrementAndGet();
        }

        public int getByPatternsCount() {
            return this.excludedByPatternsCount.get();
        }

        public void increaseByScmCount() {
            this.excludedByScmCount.incrementAndGet();
        }

        public int getByScmCount() {
            return this.excludedByScmCount.get();
        }
    }

    private class IndexFileVisitor
    implements FileVisitor<Path> {
        private final DefaultInputModule module;
        private final ModuleExclusionFilters moduleExclusionFilters;
        private final ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions;
        private final InputFile.Type type;
        private final ExclusionCounter exclusionCounter;

        IndexFileVisitor(DefaultInputModule module, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, InputFile.Type type, ExclusionCounter exclusionCounter) {
            this.module = module;
            this.moduleExclusionFilters = moduleExclusionFilters;
            this.moduleCoverageAndDuplicationExclusions = moduleCoverageAndDuplicationExclusions;
            this.type = type;
            this.exclusionCounter = exclusionCounter;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.isHidden(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!Files.isHidden(file)) {
                ProjectFileIndexer.this.fileIndexer.indexFile(this.module, this.moduleExclusionFilters, this.moduleCoverageAndDuplicationExclusions, file, this.type, ProjectFileIndexer.this.progressReport, this.exclusionCounter, ProjectFileIndexer.this.ignoreCommand);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            if (exc instanceof FileSystemLoopException) {
                LOG.warn("Not indexing due to symlink loop: {}", (Object)file.toFile());
                return FileVisitResult.CONTINUE;
            }
            if (exc instanceof AccessDeniedException && this.isExcluded(file)) {
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }

        private boolean isExcluded(Path path) throws IOException {
            Path realAbsoluteFile = path.toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize();
            return ProjectFileIndexer.isExcludedDirectory(this.moduleExclusionFilters, realAbsoluteFile, ProjectFileIndexer.this.inputModuleHierarchy.root().getBaseDir(), this.module.getBaseDir(), this.type);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        private boolean isHidden(Path path) throws IOException {
            if (SystemUtils.IS_OS_WINDOWS) {
                try {
                    DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return dosFileAttributes.isHidden();
                }
                catch (UnsupportedOperationException e) {
                    return path.toFile().isHidden();
                }
            }
            return Files.isHidden(path);
        }
    }
}

