/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.BlameLine;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scm.git.GitBlameCommand;
import org.sonar.scm.git.GitThreadFactory;
import org.sonar.scm.git.JGitBlameCommand;
import org.sonar.scm.git.JGitUtils;

public class CompositeBlameCommand
extends BlameCommand {
    private static final Logger LOG = Loggers.get(CompositeBlameCommand.class);
    private final AnalysisWarnings analysisWarnings;
    private final PathResolver pathResolver;
    private final JGitBlameCommand jgitCmd;
    private final GitBlameCommand nativeCmd;
    private boolean nativeGitEnabled = false;

    public CompositeBlameCommand(AnalysisWarnings analysisWarnings, PathResolver pathResolver, JGitBlameCommand jgitCmd, GitBlameCommand nativeCmd) {
        this.analysisWarnings = analysisWarnings;
        this.pathResolver = pathResolver;
        this.jgitCmd = jgitCmd;
        this.nativeCmd = nativeCmd;
    }

    @Override
    public void blame(BlameCommand.BlameInput input, BlameCommand.BlameOutput output) {
        File basedir = input.fileSystem().baseDir();
        try (Repository repo = JGitUtils.buildRepository(basedir.toPath());
             Git git = Git.wrap(repo);){
            File gitBaseDir = repo.getWorkTree();
            if (this.cloneIsInvalid(gitBaseDir)) {
                return;
            }
            Profiler profiler = Profiler.create(LOG);
            profiler.startDebug("Collecting committed files");
            Set<String> committedFiles = CompositeBlameCommand.collectAllCommittedFiles(repo);
            profiler.stopDebug();
            this.nativeGitEnabled = this.nativeCmd.checkIfEnabled();
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new GitThreadFactory());
            for (InputFile inputFile : input.filesToBlame()) {
                String filename = this.pathResolver.relativePath(gitBaseDir, inputFile.file());
                if (filename == null || !committedFiles.contains(filename)) continue;
                executorService.submit(() -> this.blame(output, git, gitBaseDir, inputFile, filename));
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.info("Git blame interrupted", (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static Set<String> collectAllCommittedFiles(Repository repo) {
        try {
            HashSet<String> files = new HashSet<String>();
            Optional<ObjectId> headCommit = Optional.ofNullable(repo.resolve("HEAD"));
            if (headCommit.isEmpty()) {
                LOG.warn("Could not find HEAD commit");
                return files;
            }
            try (RevWalk revWalk = new RevWalk(repo);){
                RevCommit head = revWalk.parseCommit(headCommit.get());
                try (TreeWalk treeWalk = new TreeWalk(repo);){
                    treeWalk.addTree(head.getTree());
                    treeWalk.setRecursive(true);
                    while (treeWalk.next()) {
                        String path = treeWalk.getPathString();
                        files.add(path);
                    }
                }
            }
            return files;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to find all committed files", e);
        }
    }

    private void blame(BlameCommand.BlameOutput output, Git git, File gitBaseDir, InputFile inputFile, String filename) {
        List<BlameLine> blame = null;
        if (this.nativeGitEnabled) {
            try {
                LOG.debug("Blame file (native) {}", (Object)filename);
                blame = this.nativeCmd.blame(gitBaseDir.toPath(), filename);
            }
            catch (Exception e) {
                LOG.debug("Native git blame failed. Falling back to jgit: " + filename, (Object)e);
                this.nativeGitEnabled = false;
            }
        }
        if (blame == null) {
            LOG.debug("Blame file (JGit) {}", (Object)filename);
            blame = this.jgitCmd.blame(git, filename);
        }
        if (!blame.isEmpty()) {
            if (blame.size() == inputFile.lines() - 1) {
                blame.add(blame.get(blame.size() - 1));
            }
            output.blameResult(inputFile, blame);
        }
    }

    private boolean cloneIsInvalid(File gitBaseDir) {
        if (Files.isRegularFile(gitBaseDir.toPath().resolve(".git/objects/info/alternates"), new LinkOption[0])) {
            LOG.info("This git repository references another local repository which is not well supported. SCM information might be missing for some files. You can avoid borrow objects from another local repository by not using --reference or --shared when cloning it.");
        }
        if (Files.isRegularFile(gitBaseDir.toPath().resolve(".git/shallow"), new LinkOption[0])) {
            LOG.warn("Shallow clone detected, no blame information will be provided. You can convert to non-shallow with 'git fetch --unshallow'.");
            this.analysisWarnings.addUnique("Shallow clone detected during the analysis. Some files will miss SCM information. This will affect features like auto-assignment of issues. Please configure your build to disable shallow clone.");
            return true;
        }
        return false;
    }
}

