/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.svn;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.BlameLine;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scm.svn.AnnotationHandler;
import org.sonar.scm.svn.SvnConfiguration;
import org.sonar.scm.svn.SvnScmSupport;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnBlameCommand
extends BlameCommand {
    private static final Logger LOG = Loggers.get(SvnBlameCommand.class);
    private final SvnConfiguration configuration;

    public SvnBlameCommand(SvnConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blame(BlameCommand.BlameInput input, BlameCommand.BlameOutput output) {
        FileSystem fs = input.fileSystem();
        LOG.debug("Working directory: " + fs.baseDir().getAbsolutePath());
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnScmSupport.newSvnClientManager(this.configuration);
            for (InputFile inputFile : input.filesToBlame()) {
                this.blame(clientManager, inputFile, output);
            }
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", e);
                }
            }
        }
    }

    @VisibleForTesting
    void blame(SVNClientManager clientManager, InputFile inputFile, BlameCommand.BlameOutput output) {
        String filename = inputFile.relativePath();
        LOG.debug("Process file {}", (Object)filename);
        AnnotationHandler handler = new AnnotationHandler();
        try {
            if (!SvnBlameCommand.checkStatus(clientManager, inputFile)) {
                return;
            }
            SVNLogClient logClient = clientManager.getLogClient();
            logClient.setDiffOptions(new SVNDiffOptions(true, true, true));
            logClient.doAnnotate(inputFile.file(), SVNRevision.UNDEFINED, SVNRevision.create(1L), SVNRevision.BASE, true, true, (ISVNAnnotateHandler)handler, null);
        }
        catch (SVNAuthenticationException e) {
            if (this.configuration.isEmpty()) {
                LOG.warn("Authentication to SVN server is required but no authentication data was passed to the scanner");
            }
            throw new IllegalStateException("Authentication error when executing blame for file " + filename, e);
        }
        catch (SVNException e) {
            throw new IllegalStateException("Error when executing blame for file " + filename, e);
        }
        List<BlameLine> lines = handler.getLines();
        if (lines.size() == inputFile.lines() - 1) {
            lines.add(lines.get(lines.size() - 1));
        }
        output.blameResult(inputFile, lines);
    }

    private static boolean checkStatus(SVNClientManager clientManager, InputFile inputFile) throws SVNException {
        SVNStatusClient statusClient = clientManager.getStatusClient();
        try {
            SVNStatus status = statusClient.doStatus(inputFile.file(), false);
            if (status == null) {
                LOG.debug("File {} returns no svn state. Skipping it.", (Object)inputFile);
                return false;
            }
            if (status.getContentsStatus() != SVNStatusType.STATUS_NORMAL) {
                LOG.debug("File {} is not versionned or contains local modifications. Skipping it.", (Object)inputFile);
                return false;
            }
        }
        catch (SVNException e) {
            if (SVNErrorCode.WC_PATH_NOT_FOUND.equals(e.getErrorMessage().getErrorCode()) || SVNErrorCode.WC_NOT_WORKING_COPY.equals(e.getErrorMessage().getErrorCode())) {
                LOG.debug("File {} is not versionned. Skipping it.", (Object)inputFile);
                return false;
            }
            throw e;
        }
        return true;
    }
}

