/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Scanner;
import org.sonar.updatecenter.common.Sonar;
import org.sonar.updatecenter.common.SonarUpdate;
import org.sonar.updatecenter.common.Version;
import org.sonar.updatecenter.common.exception.IncompatiblePluginVersionException;
import org.sonar.updatecenter.common.exception.PluginNotFoundException;

public class UpdateCenter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCenter.class);
    private PluginReferential updateCenterPluginReferential;
    private PluginReferential installedPluginReferential;
    private Version installedSonarVersion;
    private Date date;
    private Sonar sonar;
    private List<Scanner> scanners;

    private UpdateCenter(PluginReferential updateCenterPluginReferential, List<Scanner> scanners, Sonar sonar) {
        this.updateCenterPluginReferential = updateCenterPluginReferential;
        this.sonar = sonar;
        this.installedPluginReferential = PluginReferential.createEmpty();
        this.scanners = scanners;
    }

    public static UpdateCenter create(PluginReferential updateCenterPluginReferential, List<Scanner> scanners, Sonar sonar) {
        return new UpdateCenter(updateCenterPluginReferential, scanners, sonar);
    }

    public PluginReferential getUpdateCenterPluginReferential() {
        return this.updateCenterPluginReferential;
    }

    public UpdateCenter registerInstalledPlugins(PluginReferential installedPluginReferential) {
        this.installedPluginReferential = installedPluginReferential;
        return this;
    }

    public Sonar getSonar() {
        return this.sonar;
    }

    public UpdateCenter setInstalledSonarVersion(Version installedSonarVersion) {
        this.installedSonarVersion = installedSonarVersion;
        return this;
    }

    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public UpdateCenter setDate(@Nullable Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
        return this;
    }

    public List<Scanner> getScanners() {
        return this.scanners;
    }

    public List<PluginUpdate> findAvailablePlugins() {
        ArrayList<PluginUpdate> availables = new ArrayList<PluginUpdate>();
        for (Plugin plugin : this.updateCenterPluginReferential.getPlugins()) {
            if (this.isInstalled(plugin)) continue;
            Release release = plugin.getLastCompatibleRelease(this.installedSonarVersion);
            if (release != null) {
                try {
                    PluginUpdate pluginUpdate = PluginUpdate.createWithStatus(release, PluginUpdate.Status.COMPATIBLE);
                    pluginUpdate.setDependencies(this.findInstallablePlugins(plugin.getKey(), release.getVersion()));
                    availables.add(pluginUpdate);
                }
                catch (IncompatiblePluginVersionException e) {
                    availables.add(PluginUpdate.createWithStatus(release, PluginUpdate.Status.DEPENDENCIES_REQUIRE_SONAR_UPGRADE));
                }
                continue;
            }
            release = plugin.getLastCompatibleReleaseIfUpgrade(this.installedSonarVersion);
            if (release == null) continue;
            availables.add(PluginUpdate.createWithStatus(release, PluginUpdate.Status.REQUIRE_SONAR_UPGRADE));
        }
        return availables;
    }

    public List<Plugin> findAllCompatiblePlugins() {
        ArrayList<Plugin> availables = new ArrayList<Plugin>();
        for (Plugin plugin : this.updateCenterPluginReferential.getPlugins()) {
            Release release = plugin.getLastCompatible(this.installedSonarVersion);
            if (release == null) continue;
            availables.add(plugin);
        }
        return availables;
    }

    public List<PluginUpdate> findPluginUpdates() {
        ArrayList<PluginUpdate> updates = new ArrayList<PluginUpdate>();
        for (Release installedRelease : this.getInstalledMasterReleases()) {
            try {
                Plugin plugin = this.findPlugin(installedRelease);
                for (Release nextRelease : plugin.getReleasesGreaterThan(installedRelease.getVersion())) {
                    updates.add(this.getPluginUpdate(plugin, nextRelease));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        return updates;
    }

    private PluginUpdate getPluginUpdate(Plugin plugin, Release nextRelease) {
        PluginUpdate pluginUpdate = PluginUpdate.createForPluginRelease(nextRelease, this.installedSonarVersion);
        try {
            if (pluginUpdate.isCompatible()) {
                pluginUpdate.setDependencies(this.findInstallablePlugins(plugin.getKey(), nextRelease.getVersion()));
            }
        }
        catch (IncompatiblePluginVersionException e) {
            pluginUpdate.setStatus(PluginUpdate.Status.DEPENDENCIES_REQUIRE_SONAR_UPGRADE);
        }
        return pluginUpdate;
    }

    public List<Release> findInstallablePlugins(String pluginKey, Version minimumVersion) {
        HashSet<Release> installablePlugins = new HashSet<Release>();
        HashSet<Release> checkedPlugins = new HashSet<Release>();
        this.addInstallablePlugins(pluginKey, minimumVersion, installablePlugins, checkedPlugins);
        return new ArrayList<Release>(installablePlugins);
    }

    private void addInstallablePlugins(String pluginKey, Version minimumVersion, Set<Release> installablePlugins, Set<Release> checkedPlugins) {
        try {
            Plugin plugin;
            Release pluginRelease;
            if (!this.contain(pluginKey, installablePlugins) && !this.contain(pluginKey, checkedPlugins) && (pluginRelease = (plugin = this.updateCenterPluginReferential.findPlugin(pluginKey)).getLastCompatibleRelease(this.installedSonarVersion)) != null) {
                if (pluginRelease.getVersion().compareTo(minimumVersion) < 0) {
                    throw new IncompatiblePluginVersionException("Plugin " + pluginKey + " is needed to be installed at version greater or equal " + minimumVersion);
                }
                this.addInstallableRelease(pluginRelease, installablePlugins, checkedPlugins);
            }
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException("Needed plugin '" + pluginKey + "' version " + minimumVersion + " not found.");
        }
    }

    private void addInstallableRelease(Release pluginRelease, Set<Release> installablePlugins, Set<Release> checkedPlugins) {
        this.addReleaseIfNotAlreadyInstalled(pluginRelease, installablePlugins);
        checkedPlugins.add(pluginRelease);
        for (Release outgoingDependency : pluginRelease.getOutgoingDependencies()) {
            this.addInstallablePlugins(outgoingDependency.getArtifact().getKey(), outgoingDependency.getVersion(), installablePlugins, checkedPlugins);
        }
        for (Release incomingDependency : pluginRelease.getIncomingDependencies()) {
            String pluginKey = incomingDependency.getArtifact().getKey();
            if (!this.isInstalled(pluginKey)) continue;
            this.addInstallablePlugins(pluginKey, incomingDependency.getVersion(), installablePlugins, checkedPlugins);
        }
    }

    private boolean contain(String pluginKey, Set<Release> installablePlugins) {
        return installablePlugins.stream().anyMatch(input -> input.getKey().equals(pluginKey));
    }

    private void addReleaseIfNotAlreadyInstalled(Release release, Set<Release> installablePlugins) {
        if (!this.isInstalled(release)) {
            installablePlugins.add(release);
        }
    }

    public List<SonarUpdate> findSonarUpdates() {
        ArrayList<SonarUpdate> updates = new ArrayList<SonarUpdate>();
        SortedSet<Release> releases = this.sonar.getReleasesGreaterThan(this.installedSonarVersion);
        for (Release release : releases) {
            updates.add(this.createSonarUpdate(release));
        }
        return updates;
    }

    private SonarUpdate createSonarUpdate(Release sonarRelease) {
        SonarUpdate update = new SonarUpdate(sonarRelease);
        for (Release installedRelease : this.getInstalledMasterReleases()) {
            try {
                Plugin plugin = this.findPlugin(installedRelease);
                Release release = plugin.getRelease(installedRelease.getAdjustedVersion());
                if (release.supportSonarVersion(sonarRelease.getVersion())) {
                    update.addCompatiblePlugin(plugin);
                    continue;
                }
                UpdateCenter.searchCompatiblePluginUpgrade(sonarRelease, update, installedRelease, plugin);
            }
            catch (NoSuchElementException e) {
                LOG.info("The plugin '" + installedRelease.getArtifact().getKey() + "' version : " + installedRelease.getVersion().getName() + " has not been found on the update center.");
            }
        }
        return update;
    }

    private static void searchCompatiblePluginUpgrade(Release sonarRelease, SonarUpdate update, Release installedRelease, Plugin plugin) {
        boolean ok = false;
        Release compatibleRelease = null;
        for (Release greaterPluginRelease : plugin.getReleasesGreaterThan(installedRelease.getVersion())) {
            if (!greaterPluginRelease.supportSonarVersion(sonarRelease.getVersion())) continue;
            compatibleRelease = greaterPluginRelease;
            ok = true;
        }
        if (ok) {
            update.addPluginToUpgrade(compatibleRelease);
        } else {
            update.addIncompatiblePlugin(plugin);
        }
    }

    PluginReferential getInstalledPluginReferential() {
        return this.installedPluginReferential;
    }

    private boolean isInstalled(Release releaseToFind) {
        return this.installedPluginReferential.doesContainRelease(releaseToFind.getArtifact().getKey(), releaseToFind.getVersion());
    }

    private boolean isInstalled(Plugin plugin) {
        return this.isInstalled(plugin.getKey());
    }

    private boolean isInstalled(String pluginKey) {
        return this.installedPluginReferential.doesContainPlugin(pluginKey);
    }

    private Plugin findPlugin(Release release) {
        String key = release.getArtifact().getKey();
        return this.updateCenterPluginReferential.findPlugin(key);
    }

    private List<Release> getInstalledMasterReleases() {
        return this.installedPluginReferential.getLastMasterReleases();
    }
}

