/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNCharsetInputStream;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTranslator {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static CodingErrorAction onMalformedInputAction = CodingErrorAction.REPORT;
    private static CodingErrorAction onUnmappableCharacterAction = CodingErrorAction.REPORT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translateString(String str, byte[] eol, Map<String, byte[]> keywords, boolean repair, boolean expand) throws SVNException {
        ByteArrayOutputStream bufferOS = new ByteArrayOutputStream();
        OutputStream resultOS = null;
        try {
            resultOS = SVNTranslator.getTranslatingOutputStream(bufferOS, null, eol, repair, keywords, expand);
            resultOS.write(str.getBytes());
        }
        catch (IOException e) {
            try {
                SVNTranslator.translationError(null, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(resultOS);
                throw throwable;
            }
            SVNFileUtil.closeFile(resultOS);
        }
        SVNFileUtil.closeFile(resultOS);
        return new String(bufferOS.toByteArray());
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, srcPath, dstPath, false, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), customEOLStyle, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, customEOLStyle, false, expand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean safelyEncode, boolean expand) throws SVNException {
        ISVNOptions options = adminArea.getWCAccess().getOptions();
        SVNVersionedProperties props = adminArea.getProperties(name);
        String keywords = props.getStringPropertyValue("svn:keywords");
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, adminArea.getFile(name).getPath(), options);
        String eolStyle = null;
        eolStyle = customEOLStyle != null ? customEOLStyle : props.getStringPropertyValue("svn:eol-style");
        boolean special = props.getPropertyValue("svn:special") != null;
        Map<String, byte[]> keywordsMap = null;
        if (keywords != null) {
            if (expand) {
                SVNEntry entry = adminArea.getVersionedEntry(name, true);
                String url = entry.getURL();
                String repositoryRoot = entry.getRepositoryRoot();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                keywordsMap = SVNTranslator.computeKeywords(keywords, url, repositoryRoot, author, date, rev, options);
            } else {
                keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null, null);
            }
        }
        byte[] eols = !expand ? SVNTranslator.getBaseEOL(eolStyle) : SVNTranslator.getEOL(eolStyle, options);
        if (expand && charset != null && safelyEncode) {
            File tmp = SVNAdminUtil.createTmpFile(adminArea, name, ".tmp", true);
            try {
                SVNTranslator.translate(src, tmp, charset, eols, keywordsMap, special, false);
                SVNTranslator.translate(tmp, dst, charset, eols, keywordsMap, special, true);
            }
            finally {
                SVNFileUtil.deleteFile(tmp);
            }
        } else {
            SVNTranslator.translate(src, dst, charset, eols, keywordsMap, special, expand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translate(File src, File dst, String charset, byte[] eol, Map<String, byte[]> keywords, boolean special, boolean expand) throws SVNException {
        if (src == null || dst == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS), SVNLogType.DEFAULT);
            return;
        }
        if (src.equals(dst)) {
            return;
        }
        if (special) {
            if (SVNFileType.getType(dst) != SVNFileType.NONE) {
                dst.delete();
            }
            if (!SVNFileUtil.symlinksSupported()) {
                SVNFileUtil.copyFile(src, dst, true);
            } else if (expand) {
                SVNFileUtil.createSymlink(dst, src);
            } else {
                SVNFileUtil.detranslateSymlink(src, dst);
            }
            return;
        }
        if ((charset == null || SVNProperty.isUTF8(charset)) && eol == null && (keywords == null || keywords.isEmpty())) {
            SVNFileUtil.copyFile(src, dst, false, false);
            return;
        }
        OutputStream os = SVNFileUtil.openFileForWriting(dst);
        OutputStream tos = SVNTranslator.getTranslatingOutputStream(os, charset, eol, true, keywords, expand);
        InputStream is = SVNFileUtil.openFileForReading(src, SVNLogType.WC);
        try {
            SVNTranslator.copy(is, tos);
        }
        catch (IOException e) {
            SVNTranslator.translationError(dst, e);
        }
        finally {
            SVNFileUtil.closeFile(tos);
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getTranslatedStream(SVNAdminArea adminArea, String name, boolean translateToNormalForm, boolean repairEOL) throws SVNException {
        boolean translationRequired;
        ISVNOptions options = adminArea.getWCAccess().getOptions();
        SVNVersionedProperties props = adminArea.getProperties(name);
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, adminArea.getFile(name).getPath(), options);
        String eolStyle = props.getStringPropertyValue("svn:eol-style");
        String keywords = props.getStringPropertyValue("svn:keywords");
        boolean special = props.getPropertyValue("svn:special") != null;
        File src = adminArea.getFile(name);
        if (special) {
            String linkPath;
            if (!SVNFileUtil.symlinksSupported()) {
                return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
            }
            if (SVNFileType.getType(src) != SVNFileType.SYMLINK) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if ((linkPath = SVNFileUtil.getSymlinkName(src)) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                os.write("link ".getBytes("UTF-8"));
                os.write(linkPath.getBytes("UTF-8"));
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            return new ByteArrayInputStream(os.toByteArray());
        }
        boolean bl = translationRequired = special || keywords != null || eolStyle != null || charset != null;
        if (translationRequired) {
            byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
            if (translateToNormalForm) {
                if (eolStyle != null && eol == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null, null);
                boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || repairEOL;
                return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, repair, keywordsMap, false);
            }
            SVNEntry entry = adminArea.getVersionedEntry(name, false);
            String url = entry.getURL();
            String repositoryRoot = entry.getRepositoryRoot();
            String author = entry.getAuthor();
            String date = entry.getCommittedDate();
            String rev = Long.toString(entry.getCommittedRevision());
            Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, url, repositoryRoot, author, date, rev, options);
            return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, true, keywordsMap, true);
        }
        return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
    }

    public static File getTranslatedFile(SVNAdminArea dir, String name, File src, boolean forceEOLRepair, boolean useGlobalTmp, boolean forceCopy, boolean toNormalFormat) throws SVNException {
        ISVNOptions options = dir.getWCAccess().getOptions();
        SVNVersionedProperties props = dir.getProperties(name);
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, dir.getFile(name).getPath(), options);
        String eolStyle = props.getStringPropertyValue("svn:eol-style");
        String keywords = props.getStringPropertyValue("svn:keywords");
        boolean special = props.getPropertyValue("svn:special") != null;
        boolean needsTranslation = charset != null || eolStyle != null || keywords != null || special;
        File result = null;
        if (!needsTranslation && !forceCopy) {
            result = src;
        } else {
            result = useGlobalTmp ? SVNFileUtil.createTempFile("svndiff", ".tmp") : SVNAdminUtil.createTmpFile(dir, name, ".tmp", true);
            if (toNormalFormat) {
                SVNTranslator.translateToNormalForm(src, result, charset, eolStyle, forceEOLRepair, keywords, special);
            } else {
                SVNEntry entry = dir.getVersionedEntry(name, false);
                String url = entry.getURL();
                String repositoryRoot = entry.getRepositoryRoot();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, url, repositoryRoot, author, date, rev, options);
                SVNTranslator.copyAndTranslate(src, result, charset, SVNTranslator.getEOL(eolStyle, options), keywordsMap, special, true, true);
            }
        }
        return result;
    }

    public static File maybeUpdateTargetEOLs(SVNAdminArea dir, File target, SVNProperties propDiff) throws SVNException {
        String eolStyle = null;
        if (propDiff != null && propDiff.containsName("svn:eol-style") && propDiff.getStringValue("svn:eol-style") != null) {
            eolStyle = propDiff.getStringValue("svn:eol-style");
            ISVNOptions options = dir.getWCAccess().getOptions();
            byte[] eol = SVNTranslator.getEOL(eolStyle, options);
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.copyAndTranslate(target, tmpFile, null, eol, null, false, false, true);
            return tmpFile;
        }
        return target;
    }

    public static File detranslateWorkingCopy(SVNAdminArea dir, String name, SVNProperties propDiff, boolean force) throws SVNException {
        boolean isRemoteBinary;
        SVNVersionedProperties props = dir.getProperties(name);
        boolean isLocalBinary = SVNProperty.isBinaryMimeType(props.getStringPropertyValue("svn:mime-type"));
        String mimeType = null;
        String charsetProp = null;
        String eolStyle = null;
        String keywords = null;
        boolean isSpecial = false;
        boolean isRemoteHasBinary = propDiff != null && propDiff.containsName("svn:mime-type");
        boolean isRemoteBinaryRemoved = isRemoteHasBinary && !SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        boolean bl = isRemoteBinary = isRemoteHasBinary && SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        if (!isLocalBinary && isRemoteBinary) {
            isSpecial = props.getPropertyValue("svn:special") != null;
            keywords = props.getStringPropertyValue("svn:keywords");
            charsetProp = props.getStringPropertyValue("svnkit:charset");
            mimeType = props.getStringPropertyValue("svn:mime-type");
        } else if (!isLocalBinary || isRemoteBinaryRemoved) {
            boolean bl2 = isSpecial = props.getPropertyValue("svn:special") != null;
            if (!isSpecial) {
                if (propDiff != null && propDiff.getStringValue("svn:eol-style") != null) {
                    eolStyle = propDiff.getStringValue("svn:eol-style");
                } else if (!isLocalBinary) {
                    eolStyle = props.getStringPropertyValue("svn:eol-style");
                }
                if (propDiff != null && propDiff.getStringValue("svnkit:charset") != null) {
                    charsetProp = propDiff.getStringValue("svnkit:charset");
                    mimeType = propDiff.getStringValue("svn:mime-type");
                } else if (!isLocalBinary) {
                    charsetProp = props.getStringPropertyValue("svnkit:charset");
                    mimeType = props.getStringPropertyValue("svn:mime-type");
                }
                if (!isLocalBinary) {
                    keywords = props.getStringPropertyValue("svn:keywords");
                }
            }
        }
        File detranslatedFile = null;
        ISVNOptions options = dir.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, dir.getFile(name).getPath(), options);
        if (force || charset != null || keywords != null || eolStyle != null || isSpecial) {
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.translateToNormalForm(dir.getFile(name), tmpFile, charset, eolStyle, true, keywords, isSpecial);
            detranslatedFile = tmpFile;
        } else {
            detranslatedFile = dir.getFile(name);
        }
        return detranslatedFile;
    }

    private static void translateToNormalForm(File source2, File destination, String charset, String eolStyle, boolean alwaysRepairEOLs, String keywords, boolean isSpecial) throws SVNException {
        byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
        if (eolStyle != null && eol == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null, null);
        boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || alwaysRepairEOLs;
        SVNTranslator.copyAndTranslate(source2, destination, charset, eol, keywordsMap, isSpecial, false, repair);
    }

    /*
     * Exception decompiling
     */
    public static void copyAndTranslate(File source, File destination, String charset, byte[] eol, Map<String, byte[]> keywords, boolean special, boolean expand, boolean repair) throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkWrappedException(IOException ioe, File file) throws SVNException {
        if (ioe instanceof IOExceptionWrapper) {
            IOExceptionWrapper ew = (IOExceptionWrapper)ioe;
            if (ew.getOriginalException().getErrorMessage().getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL, "File ''{0}'' has inconsistent newlines", (Object)file);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            throw ew.getOriginalException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNewLines(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return true;
        }
        InputStream is = null;
        try {
            int r;
            is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
            byte[] lastFoundEOL = null;
            byte[] currentEOL = null;
            while ((r = is.read()) >= 0) {
                if (r == 10) {
                    currentEOL = SVNProperty.EOL_LF_BYTES;
                } else if (r == 13) {
                    currentEOL = SVNProperty.EOL_CR_BYTES;
                    r = is.read();
                    if (r == 10) {
                        currentEOL = SVNProperty.EOL_CRLF_BYTES;
                    }
                }
                if (lastFoundEOL == null) {
                    lastFoundEOL = currentEOL;
                    continue;
                }
                if (currentEOL == null || lastFoundEOL == currentEOL) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return true;
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        byte[] buffer = new byte[8192];
        int read;
        while ((read = src.read(buffer)) >= 0) {
            if (read == 0) continue;
            dst.write(buffer, 0, read);
        }
        return;
    }

    public static OutputStream getTranslatingOutputStream(OutputStream out, String charset, byte[] eol, boolean repair, Map<String, byte[]> keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        Charset cs = Charset.forName(charset);
        byte[] lf = SVNProperty.EOL_LF_BYTES;
        if (expand) {
            if (eol != null) {
                boolean encodingConvertsEOL;
                byte[] convertedEOL = SVNTranslator.convertEOL(lf, UTF8_CHARSET, cs);
                boolean bl = encodingConvertsEOL = !Arrays.equals(lf, convertedEOL);
                if (Arrays.equals(convertedEOL, eol) && encodingConvertsEOL) {
                    out = new SVNCharsetOutputStream(out, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                    if (keywords != null) {
                        out = new SVNTranslatorOutputStream(out, null, false, keywords, expand);
                    }
                    return out;
                }
            }
            out = new SVNCharsetOutputStream(out, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        if (eol != null) {
            boolean encodingConvertsEOL;
            byte[] convertedEOL = SVNTranslator.convertEOL(eol, cs, UTF8_CHARSET);
            boolean bl = encodingConvertsEOL = !Arrays.equals(eol, convertedEOL);
            if (Arrays.equals(convertedEOL, lf) && encodingConvertsEOL) {
                if (keywords != null) {
                    out = new SVNTranslatorOutputStream(out, null, false, keywords, expand);
                }
                return new SVNCharsetOutputStream(out, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
            }
        }
        out = new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        return new SVNCharsetOutputStream(out, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
    }

    public static InputStream getTranslatingInputStream(InputStream in, String charset, byte[] eol, boolean repair, Map<String, byte[]> keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
        }
        Charset cs = Charset.forName(charset);
        byte[] lf = SVNProperty.EOL_LF_BYTES;
        if (expand) {
            if (eol != null) {
                boolean encodingConvertsEOL;
                byte[] convertedEOL = SVNTranslator.convertEOL(lf, UTF8_CHARSET, cs);
                boolean bl = encodingConvertsEOL = !Arrays.equals(convertedEOL, lf);
                if (Arrays.equals(eol, convertedEOL) && encodingConvertsEOL) {
                    if (keywords != null) {
                        in = new SVNTranslatorInputStream(in, null, false, keywords, expand);
                    }
                    return new SVNCharsetInputStream(in, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                }
            }
            in = new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
            return new SVNCharsetInputStream(in, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
        }
        if (eol != null) {
            boolean charsetConvertsEOL;
            byte[] convertedEOL = SVNTranslator.convertEOL(eol, cs, UTF8_CHARSET);
            boolean bl = charsetConvertsEOL = !Arrays.equals(convertedEOL, eol);
            if (Arrays.equals(lf, convertedEOL) && charsetConvertsEOL) {
                in = new SVNCharsetInputStream(in, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                if (keywords != null) {
                    in = new SVNTranslatorInputStream(in, null, false, keywords, expand);
                }
                return in;
            }
        }
        in = new SVNCharsetInputStream(in, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
        return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
    }

    private static byte[] convertEOL(byte[] eol, Charset from, Charset to) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(eol);
        CharBuffer charBuffer = from.decode(byteBuffer);
        ByteBuffer resultBuffer = to.encode(charBuffer);
        byte[] result = new byte[resultBuffer.limit()];
        resultBuffer.get(result, 0, result.length);
        return result;
    }

    public static Map<String, byte[]> computeKeywords(String keywords, String locationUrl, String repositoryRoot, String a, String d, String r, ISVNOptions options) {
        boolean expand;
        if (keywords == null) {
            return Collections.emptyMap();
        }
        boolean expandCustomKeywords = expand = locationUrl != null;
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            SVNKeywordFormatter keywordFormatter = new SVNKeywordFormatter(expand, expandCustomKeywords, locationUrl == null ? null : SVNURL.parseURIEncoded(locationUrl), repositoryRoot == null ? null : SVNURL.parseURIEncoded(repositoryRoot), a, d, r, options);
            StringTokenizer tokens = new StringTokenizer(keywords, " \t\n\b\r\f");
            while (tokens.hasMoreTokens()) {
                int pos;
                String token = tokens.nextToken();
                String customFormat = null;
                if (expandCustomKeywords && (pos = token.lastIndexOf(61)) >= 0) {
                    customFormat = token.substring(pos + 1);
                    token = token.substring(0, pos);
                }
                if (customFormat != null) {
                    byte[] customValue = keywordFormatter.format(customFormat);
                    map.put(token, customValue);
                    continue;
                }
                if ("LastChangedDate".equals(token) || "Date".equalsIgnoreCase(token)) {
                    byte[] date = keywordFormatter.format("%D");
                    map.put("LastChangedDate", date);
                    map.put("Date", date);
                    continue;
                }
                if ("LastChangedRevision".equals(token) || "Revision".equals(token) || "Rev".equalsIgnoreCase(token)) {
                    byte[] revision = keywordFormatter.format("%r");
                    map.put("LastChangedRevision", revision);
                    map.put("Revision", revision);
                    map.put("Rev", revision);
                    continue;
                }
                if ("LastChangedBy".equals(token) || "Author".equalsIgnoreCase(token)) {
                    byte[] author = keywordFormatter.format("%a");
                    map.put("LastChangedBy", author);
                    map.put("Author", author);
                    continue;
                }
                if ("HeadURL".equals(token) || "URL".equalsIgnoreCase(token)) {
                    byte[] url = keywordFormatter.format("%u");
                    map.put("HeadURL", url);
                    map.put("URL", url);
                    continue;
                }
                if ("Id".equalsIgnoreCase(token)) {
                    byte[] id = keywordFormatter.format("%b %r %d %a");
                    map.put("Id", (byte[])(expand ? id : null));
                    continue;
                }
                if (!"Header".equalsIgnoreCase(token)) continue;
                byte[] header = keywordFormatter.format("%u %r %d %a");
                map.put("Header", (byte[])(expand ? header : null));
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return map;
    }

    public static byte[] getEOL(String eolStyle, ISVNOptions options) {
        if ("native".equals(eolStyle)) {
            return options.getNativeEOL();
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static byte[] getBaseEOL(String eolStyle) {
        if ("native".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static String getCharset(String charset, String mimeType, Object path, ISVNOptions options) throws SVNException {
        boolean isSupported;
        if (charset == null) {
            charset = SVNTranslator.getGlobalCharset(options, mimeType);
        }
        if ("native".equals(charset)) {
            charset = options.getNativeCharset();
        }
        if (charset == null) {
            return null;
        }
        try {
            isSupported = Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            isSupported = false;
        }
        if (!isSupported) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Charset ''{0}'' is not supported on this computer; change svnkit:charset property value or remove that property for file ''{1}''", charset, path), SVNLogType.DEFAULT);
        }
        return charset;
    }

    private static String getGlobalCharset(ISVNOptions options, String mimeType) {
        if (options instanceof DefaultSVNOptions && SVNProperty.isTextMimeType(mimeType)) {
            DefaultSVNOptions defaults = (DefaultSVNOptions)options;
            return defaults.getGlobalCharset();
        }
        return null;
    }

    public static void translationError(File path, IOException e) throws SVNException {
        IOExceptionWrapper wrapper;
        SVNException wrappedException;
        SVNErrorMessage error = path != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Failed to translate ''{0}''", new Object[]{path}) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Translation failed");
        Exception cause = e;
        if (e instanceof IOExceptionWrapper && (wrappedException = (wrapper = (IOExceptionWrapper)e).getOriginalException()) != null) {
            error.setChildErrorMessage(wrappedException.getErrorMessage());
            cause = wrappedException;
        }
        SVNErrorManager.error(error, cause, SVNLogType.DEFAULT);
    }

    public static synchronized CodingErrorAction getOnMalformedInputAction() {
        return onMalformedInputAction;
    }

    public static synchronized CodingErrorAction getOnUnmappableCharacterAction() {
        return onUnmappableCharacterAction;
    }

    public static synchronized void setEncoderActions(CodingErrorAction onMalformedInput, CodingErrorAction onUnmappableCharacter) {
        onMalformedInputAction = onMalformedInput;
        onUnmappableCharacterAction = onUnmappableCharacter;
    }

    private static class SVNKeywordFormatter {
        private boolean expand;
        private boolean expandCustomKeywords;
        private String authorString;
        private String dateString;
        private String revisionString;
        private ISVNOptions options;
        private byte[] date;
        private byte[] idDate;
        private byte[] url;
        private byte[] baseUrl;
        private byte[] repositoryRoot;
        private byte[] reposRelPath;
        private byte[] rev;
        private byte[] author;
        private byte[] name;
        private byte[] id;
        private byte[] header;
        private Date javaDate;
        private SVNURL locationUrl;
        private SVNURL repositoryRootUrl;

        private SVNKeywordFormatter(boolean expand, boolean expandCustomKeywords, SVNURL locationUrl, SVNURL repositoryRootUrl, String authorString, String dateString, String revisionString, ISVNOptions options) {
            this.expand = expand;
            this.expandCustomKeywords = expandCustomKeywords;
            this.authorString = authorString;
            this.dateString = dateString;
            this.revisionString = revisionString;
            this.options = options;
            this.locationUrl = locationUrl;
            this.repositoryRootUrl = repositoryRootUrl;
            this.date = null;
            this.idDate = null;
            this.url = null;
            this.rev = null;
            this.author = null;
            this.name = null;
            this.id = null;
            this.header = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] format(String format) throws SVNException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] author;
                while (true) {
                    int pos;
                    for (pos = 0; pos < format.length() && format.charAt(pos) != '%'; ++pos) {
                    }
                    byteArrayOutputStream.write(format.substring(0, pos).getBytes("UTF-8"));
                    if (pos == format.length()) break;
                    if (pos + 1 == format.length()) {
                        byteArrayOutputStream.write(format.charAt(pos));
                        --pos;
                    } else {
                        switch (format.charAt(pos + 1)) {
                            case 'a': {
                                author = this.getAuthor();
                                if (author == null) break;
                                byteArrayOutputStream.write(author);
                                break;
                            }
                            case 'b': {
                                byte[] baseUrl = this.getName();
                                if (baseUrl == null) break;
                                byteArrayOutputStream.write(baseUrl);
                                break;
                            }
                            case 'd': {
                                byte[] idDate = this.getIdDate();
                                if (idDate == null) break;
                                byteArrayOutputStream.write(idDate);
                                break;
                            }
                            case 'D': {
                                byte[] date = this.getDate();
                                if (date == null) break;
                                byteArrayOutputStream.write(date);
                                break;
                            }
                            case 'P': {
                                byte[] reposRelPath = this.getReposRelPath();
                                if (reposRelPath == null) break;
                                byteArrayOutputStream.write(reposRelPath);
                                break;
                            }
                            case 'R': {
                                byte[] repositoryRoot = this.getRepositoryRoot();
                                if (repositoryRoot == null) break;
                                byteArrayOutputStream.write(repositoryRoot);
                                break;
                            }
                            case 'r': {
                                byte[] revision = this.getRevision();
                                if (revision == null) break;
                                byteArrayOutputStream.write(revision);
                                break;
                            }
                            case 'u': {
                                byte[] url = this.getUrl();
                                if (url == null) break;
                                byteArrayOutputStream.write(url);
                                break;
                            }
                            case '_': {
                                byteArrayOutputStream.write(32);
                                break;
                            }
                            case '%': {
                                byteArrayOutputStream.write(37);
                                break;
                            }
                            case 'H': {
                                byteArrayOutputStream.write(this.format("%P%_%r%_%d%_%a"));
                                break;
                            }
                            case 'I': {
                                byteArrayOutputStream.write(this.format("%b%_%r%_%d%_%a"));
                                break;
                            }
                            default: {
                                byteArrayOutputStream.write(format.charAt(pos));
                                byteArrayOutputStream.write(format.charAt(pos + 1));
                            }
                        }
                    }
                    format = format.substring(pos + 2);
                }
                author = byteArrayOutputStream.toByteArray();
                return author;
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
            finally {
                SVNFileUtil.closeFile(byteArrayOutputStream);
            }
            return null;
        }

        private Date getJavaDate() {
            if (this.javaDate == null) {
                this.javaDate = this.dateString == null ? null : SVNDate.parseDate(this.dateString);
            }
            return this.javaDate;
        }

        private byte[] getAuthor() throws UnsupportedEncodingException {
            if (this.author == null) {
                this.author = this.expand ? (this.authorString == null ? new byte[]{} : this.authorString.getBytes("UTF-8")) : this.author;
            }
            return this.author;
        }

        private byte[] getDate() throws UnsupportedEncodingException {
            if (this.date == null) {
                this.date = this.expand ? SVNDate.formatHumanDate(this.getJavaDate(), this.options).getBytes("UTF-8") : this.date;
            }
            return this.date;
        }

        private byte[] getRevision() throws UnsupportedEncodingException {
            if (this.rev == null) {
                this.rev = this.expand ? this.revisionString.getBytes("UTF-8") : this.rev;
            }
            return this.rev;
        }

        private byte[] getUrl() throws UnsupportedEncodingException {
            if (this.url == null && this.locationUrl != null) {
                this.url = this.expand ? this.locationUrl.toString().getBytes("UTF-8") : this.url;
            }
            return this.url;
        }

        private byte[] getBaseUrl() throws UnsupportedEncodingException, SVNException {
            if (this.baseUrl == null && this.locationUrl != null) {
                this.baseUrl = this.locationUrl.removePathTail().toString().getBytes("UTF-8");
            }
            return this.baseUrl;
        }

        private byte[] getRepositoryRoot() throws UnsupportedEncodingException {
            if (this.repositoryRoot == null && this.repositoryRootUrl != null) {
                this.repositoryRoot = this.repositoryRootUrl.toString().getBytes("UTF-8");
            }
            return this.repositoryRoot;
        }

        private byte[] getReposRelPath() throws UnsupportedEncodingException {
            if (this.reposRelPath == null && this.repositoryRootUrl != null && this.locationUrl != null) {
                this.reposRelPath = SVNPathUtil.getRelativePath(this.repositoryRootUrl.toDecodedString(), this.locationUrl.toDecodedString()).getBytes("UTF-8");
            }
            return this.reposRelPath;
        }

        private byte[] getName() throws UnsupportedEncodingException {
            if (this.name == null && this.locationUrl != null) {
                this.name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(this.locationUrl.toDecodedString())).getBytes("UTF-8");
            }
            return this.name;
        }

        private byte[] getIdDate() throws UnsupportedEncodingException {
            if (this.idDate == null) {
                this.idDate = SVNDate.formatShortDate(this.getJavaDate()).getBytes("UTF-8");
            }
            return this.idDate;
        }

        private byte[] getId() throws IOException {
            if (this.id == null && this.expand) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(this.getName());
                bos.write(32);
                bos.write(this.getRevision());
                bos.write(32);
                bos.write(this.getIdDate());
                bos.write(32);
                bos.write(this.getAuthor());
                bos.close();
                this.id = bos.toByteArray();
            }
            return this.id;
        }

        private byte[] getHeader() throws IOException {
            if (this.header == null && this.expand) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(this.getUrl());
                bos.write(32);
                bos.write(this.getRevision());
                bos.write(32);
                bos.write(this.getIdDate());
                bos.write(32);
                bos.write(this.getAuthor());
                bos.close();
                this.header = bos.toByteArray();
            }
            return this.header;
        }
    }
}

