/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNTreeConflictEditor;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbChangelist;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbCopy;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectCommittableExternalsImmediatelyBelow;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectDeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectMinMaxRevisions;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectMovedDescendantsSrc;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectMovedForDelete;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectMovedFromForDelete;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectOpDepthMovedPair;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCDb
implements ISVNWCDb {
    public static final int FORMAT_FROM_SDB = -1;
    public static final long UNKNOWN_WC_ID = -1L;
    static final long INVALID_REPOS_ID = -1L;
    private ISVNOptions config;
    private boolean autoUpgrade;
    private boolean enforceEmptyWQ;
    private Map<String, SVNWCDbDir> dirData;
    private SqlJetPagerJournalMode journalMode;
    private boolean temporaryDbInMemory;
    private boolean isAllowWC17Access;

    public static boolean isAbsolute(File localAbsPath) {
        return localAbsPath != null && localAbsPath.isAbsolute();
    }

    public static <E extends Enum<E>> EnumSet<E> getInfoFields(Class<E> clazz, E ... fields) {
        EnumSet<E> set = EnumSet.noneOf(clazz);
        for (E f : fields) {
            set.add(f);
        }
        return set;
    }

    public void setWC17SupportEnabled(boolean allowed) {
        this.isAllowWC17Access = allowed;
    }

    public boolean isWC17AccessEnabled() {
        return this.isAllowWC17Access;
    }

    @Override
    public void open(ISVNWCDb.SVNWCDbOpenMode mode, ISVNOptions config, boolean autoUpgrade, boolean enforceEmptyWQ) {
        this.config = config;
        this.autoUpgrade = autoUpgrade;
        this.enforceEmptyWQ = enforceEmptyWQ;
        this.dirData = new HashMap<String, SVNWCDbDir>();
    }

    public void setJournalModel(SqlJetPagerJournalMode journalMode) {
        this.journalMode = journalMode;
    }

    public void setTemporaryDbInMemory(boolean temporaryDbInMemory) {
        this.temporaryDbInMemory = temporaryDbInMemory;
    }

    @Override
    public void close() {
        HashSet<SVNWCDbRoot> roots2 = new HashSet<SVNWCDbRoot>();
        if (this.dirData != null) {
            for (Map.Entry<String, SVNWCDbDir> entry : this.dirData.entrySet()) {
                SVNWCDbDir pdh = entry.getValue();
                if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null) continue;
                roots2.add(pdh.getWCRoot());
            }
            this.dirData.clear();
        }
        this.closeManyWCRoots(roots2);
    }

    public void ensureNoUnfinishedTransactions() throws SVNException {
        HashSet<SVNWCDbRoot> roots2 = new HashSet<SVNWCDbRoot>();
        if (this.dirData != null) {
            for (Map.Entry entry : this.dirData.entrySet()) {
                SVNWCDbDir pdh = (SVNWCDbDir)entry.getValue();
                if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null) continue;
                roots2.add(pdh.getWCRoot());
            }
        }
        for (SVNWCDbRoot sVNWCDbRoot : roots2) {
            sVNWCDbRoot.ensureNoUnfinishedTransactions();
        }
    }

    private void closeManyWCRoots(Set<SVNWCDbRoot> roots2) {
        for (SVNWCDbRoot wcRoot : roots2) {
            try {
                wcRoot.close();
            }
            catch (SVNException sVNException) {}
        }
    }

    @Override
    public ISVNOptions getConfig() {
        return this.config;
    }

    @Override
    public void init(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long initialRev, SVNDepth depth, int workingCopyFormat) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (depth == SVNDepth.EMPTY || depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY);
        CreateDbInfo createDb = this.createDb(localAbsPath, reposRootUrl, reposUuid, "wc.db", workingCopyFormat, false);
        SVNWCDbDir pdh = new SVNWCDbDir(localAbsPath);
        pdh.setWCRoot(new SVNWCDbRoot(this, localAbsPath, createDb.sDb, createDb.wcId, -1, false, true, false));
        this.dirData.put(localAbsPath.getAbsolutePath(), pdh);
        InsertBase ibb = new InsertBase();
        ibb.status = initialRev > 0L ? ISVNWCDb.SVNWCDbStatus.Incomplete : ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibb.reposId = createDb.reposId;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = initialRev;
        ibb.children = null;
        ibb.depth = depth;
        ibb.wcId = createDb.wcId;
        ibb.wcRoot = pdh.getWCRoot();
        ibb.localRelpath = SVNFileUtil.createFilePath("");
        createDb.sDb.runTransaction(ibb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateDbInfo createDb(File dirAbsPath, SVNURL reposRootUrl, String reposUuid, String sdbFileName, int workingCopyFormat, boolean isUpgrade) throws SVNException {
        CreateDbInfo info = new CreateDbInfo();
        info.sDb = SVNWCDb.openDb(dirAbsPath, sdbFileName, SVNSqlJetDb.Mode.RWCreate, this.journalMode, this.temporaryDbInMemory);
        SVNWCDbCreateSchema createSchema = new SVNWCDbCreateSchema(info.sDb, SVNWCDbCreateSchema.MAIN_DB_STATEMENTS, workingCopyFormat, isUpgrade);
        try {
            createSchema.exec();
        }
        finally {
            createSchema.reset();
        }
        info.reposId = this.createReposId(info.sDb, reposRootUrl, reposUuid);
        SVNSqlJetStatement statement = info.sDb.getStatement(SVNWCDbStatements.INSERT_WCROOT);
        try {
            info.wcId = statement.done();
            CreateDbInfo createDbInfo = info;
            return createDbInfo;
        }
        finally {
            statement.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createReposId(SVNSqlJetDb sDb, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement getStmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY);
        try {
            getStmt.bindf("s", reposRootUrl);
            boolean haveRow = getStmt.next();
            if (haveRow) {
                long l = SvnWcDbStatementUtil.getColumnInt64(getStmt, SVNWCDbSchema.WCROOT__Fields.id);
                return l;
            }
        }
        finally {
            getStmt.reset();
        }
        SVNSqlJetStatement insertStmt = sDb.getStatement(SVNWCDbStatements.INSERT_REPOSITORY);
        try {
            insertStmt.bindf("ss", reposRootUrl, reposUuid);
            long l = insertStmt.done();
            return l;
        }
        finally {
            insertStmt.reset();
        }
    }

    public static void addWorkItems(SVNSqlJetDb sDb, SVNSkel skel) throws SVNException {
        if (skel == null) {
            return;
        }
        if (skel.first().isAtom()) {
            SVNWCDb.addSingleWorkItem(sDb, skel);
        } else {
            for (int i = 0; i < skel.getListSize(); ++i) {
                SVNWCDb.addSingleWorkItem(sDb, skel.getChild(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSingleWorkItem(SVNSqlJetDb sDb, SVNSkel workItem) throws SVNException {
        byte[] serialized = workItem.unparse();
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.INSERT_WORK_ITEM);
        try {
            stmt.bindBlob(1, serialized);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<File, File> getExternalsDefinedBelow(File localAbsPath) throws SVNException {
        TreeMap<File, File> externals = new TreeMap<File, File>(Collections.reverseOrder());
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_EXTERNALS_DEFINED);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            while (stmt.next()) {
                localRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.EXTERNALS__Fields.local_relpath));
                File defLocalRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.EXTERNALS__Fields.def_local_relpath));
                externals.put(SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelpath), SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), defLocalRelpath));
            }
        }
        finally {
            stmt.reset();
        }
        return externals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherExternalDefinitions(File localAbsPath, SVNExternalsStore externals) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_EXTERNAL_PROPERTIES);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            while (stmt.next()) {
                String externalProperty;
                SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                if (properties == null || (externalProperty = properties.getStringValue("svn:externals")) == null) continue;
                File nodeRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                File nodeAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), nodeRelPath);
                externals.addExternal(nodeAbsPath, null, externalProperty);
                String depthWord = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                externals.addDepth(nodeAbsPath, SvnWcDbStatementUtil.parseDepth(depthWord));
            }
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void addBaseExcludedNode(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, ISVNWCDb.SVNWCDbStatus status, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded);
        this.addExcludedOrNotPresentNode(localAbsPath, reposRelPath, reposRootUrl, reposUuid, revision, kind, status, conflict, workItems);
    }

    @Override
    public void addBaseDirectory(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, List<File> children, SVNDepth depth, SVNProperties davCache, SVNSkel conflict, boolean updateActualProps, SVNProperties actualProps, Map<String, SVNProperties> iprops, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.children = children;
        ibb.depth = depth;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = actualProps;
        }
        ibb.iprops = iprops;
        ibb.localRelpath = localRelpath;
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.wcRoot = pdh.getWCRoot();
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUpdateMovedTo(SVNWCDbRoot wcRoot, File childMovedFromRelPath, int opDepth, File newMovedToRelPath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_MOVED_TO_RELPATH);
        try {
            stmt.bindf("isis", wcRoot.getWcId(), childMovedFromRelPath, opDepth, newMovedToRelPath);
            long rowsAffected = stmt.done();
            assert (rowsAffected == 1L);
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveMovedFrom resolveMovedFrom(SVNWCDbRoot root, File rootRelPath, File localRelPath, int opDepth) throws SVNException {
        int moveFromDepth;
        File fromRelPath;
        ResolveMovedFrom resolveMovedFrom = new ResolveMovedFrom();
        String suffix = "";
        while (SVNWCUtils.relpathDepth(localRelPath) > opDepth) {
            suffix = SVNPathUtil.append(suffix, SVNFileUtil.getFileName(localRelPath));
        }
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_MOVED_FROM_FOR_DELETE);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                ResolveMovedFrom resolveMovedFrom2 = resolveMovedFrom;
                return resolveMovedFrom2;
            }
            fromRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
            int fromOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            moveFromDepth = ((SVNWCDbSelectMovedFromForDelete)stmt).getMovedHereOpDepth();
            if (SVNFileUtil.skipAncestor(rootRelPath, fromRelPath) == null) {
                resolveMovedFrom.movedFromRelPath = SVNFileUtil.createFilePath(fromRelPath, suffix);
                resolveMovedFrom.movedFromOpDepth = fromOpDepth;
                ResolveMovedFrom resolveMovedFrom3 = resolveMovedFrom;
                return resolveMovedFrom3;
            }
            if (moveFromDepth == 0) {
                ResolveMovedFrom resolveMovedFrom4 = resolveMovedFrom;
                return resolveMovedFrom4;
            }
        }
        finally {
            stmt.reset();
        }
        return this.resolveMovedFrom(root, rootRelPath, SVNFileUtil.createFilePath(fromRelPath, suffix), moveFromDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIncompleteChildren(SVNSqlJetDb db, long wcId, File localRelpath, long reposId, File reposPath, long revision, List<File> children, long opDepth) throws SVNException {
        SVNSqlJetStatement stmt;
        String name;
        File child;
        int i;
        assert (reposPath != null || opDepth > 0L);
        assert (reposId != -1L == (reposPath != null));
        HashMap<String, String> movedToRelPaths = new HashMap<String, String>();
        if (opDepth > 0L) {
            for (i = children.size() - 1; i >= 0; --i) {
                child = children.get(i);
                name = SVNFileUtil.getFileName(child);
                stmt = db.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
                try {
                    stmt.bindf("is", wcId, SVNFileUtil.createFilePath(localRelpath, name));
                    boolean haveRow = stmt.next();
                    if (!haveRow || stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.moved_to)) continue;
                    movedToRelPaths.put(name, stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    continue;
                }
                finally {
                    stmt.reset();
                }
            }
        }
        stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
        for (i = children.size() - 1; i >= 0; --i) {
            child = children.get(i);
            name = SVNFileUtil.getFileName(child);
            try {
                stmt.bindf("isisnnrsnsnnnnnnnnnnsn", wcId, SVNFileUtil.createFilePath(localRelpath, name), opDepth, localRelpath, revision, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.Incomplete), SvnWcDbStatementUtil.getKindText(ISVNWCDb.SVNWCDbKind.Unknown), movedToRelPaths.get(name));
                if (reposId != -1L) {
                    stmt.bindLong(5, reposId);
                    stmt.bindString(6, SVNFileUtil.getFilePath(SVNFileUtil.createFilePath(reposPath, name)));
                }
                stmt.done();
                continue;
            }
            finally {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendParentDelete(SVNSqlJetDb db, long wcId, File localRelPath, SVNNodeKind kind, int opDepth) throws SVNException {
        long parentOpDepth = 0L;
        File parentRelPath = SVNFileUtil.getFileDir(localRelPath);
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
        try {
            stmt.bindf("isi", wcId, parentRelPath, opDepth);
            boolean haveRow = stmt.next();
            if (haveRow) {
                parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            }
            stmt.reset();
            if (haveRow) {
                long existingOpDepth = 0L;
                stmt.bindf("isi", wcId, localRelPath, opDepth);
                haveRow = stmt.next();
                if (haveRow) {
                    existingOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                }
                stmt.reset();
                if (!haveRow || parentOpDepth < existingOpDepth) {
                    stmt = db.getStatement(SVNWCDbStatements.INSTALL_WORKING_NODE_FOR_DELETE);
                    stmt.bindf("isist", wcId, localRelPath, parentOpDepth, parentRelPath, kind);
                    stmt.done();
                }
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractParentDelete(SVNSqlJetDb db, long wcId, File localRelPath, int opDepth) throws SVNException {
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
        try {
            stmt.bindf("isi", wcId, localRelPath, opDepth);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void addBaseFile(File localAbspath, File reposRelpath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, SvnChecksum checksum, SVNProperties davCache, boolean deleteWorking, boolean updateActualProps, SVNProperties actualProps, boolean keepRecordedInfo, boolean insertBaseDeleted, Map<String, SVNProperties> iprops, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (reposRelpath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        assert (checksum != null);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.File;
        ibb.reposRelpath = reposRelpath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.checksum = checksum;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        ibb.iprops = iprops;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = actualProps;
        }
        ibb.keepRecordedInfo = keepRecordedInfo;
        ibb.insertBaseDeleted = insertBaseDeleted;
        ibb.deleteWorking = deleteWorking;
        ibb.localRelpath = localRelpath;
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.wcRoot = pdh.getWCRoot();
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void addBaseSymlink(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File target, SVNProperties davCache, SVNSkel conflict, boolean updateActualProps, SVNProperties acutalProps, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        assert (target != null);
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposUUID = reposUuid;
        ibb.reposRootURL = reposRootUrl;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Symlink;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.target = target;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = acutalProps;
        }
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.wcRoot = pdh.getWCRoot();
        ibb.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void addLock(File localAbsPath, ISVNWCDb.SVNWCDbLock lock) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        assert (lock != null);
        DirParsedInfo dir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = dir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        InsertLock ilb = new InsertLock();
        ilb.localAbsPath = localAbsPath;
        ilb.lock = lock;
        pdh.getWCRoot().getSDb().runTransaction(ilb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void addWorkQueue(File wcRootAbsPath, SVNSkel workItem) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        if (workItem == null) {
            return;
        }
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDb.addWorkItems(pdh.getWCRoot().getSDb(), workItem);
    }

    @Override
    public boolean checkPristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.checkPristine(pdh.getWCRoot(), checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedWorkQueue(File wcRootAbsPath, long id) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (id != 0L);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WORK_ITEM);
        try {
            stmt.bindLong(1, id);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNWCDb.WCDbWorkQueueInfo fetchWorkQueue(File wcRootAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        ISVNWCDb.WCDbWorkQueueInfo info = new ISVNWCDb.WCDbWorkQueueInfo();
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORK_ITEM);
        try {
            boolean haveRow = stmt.next();
            if (!haveRow) {
                info.id = 0L;
                info.workItem = null;
                ISVNWCDb.WCDbWorkQueueInfo wCDbWorkQueueInfo = info;
                return wCDbWorkQueueInfo;
            }
            info.id = stmt.getColumnLong(SVNWCDbSchema.WORK_QUEUE__Fields.id);
            info.workItem = SVNSkel.parse(stmt.getColumnBlob(SVNWCDbSchema.WORK_QUEUE__Fields.work));
            ISVNWCDb.WCDbWorkQueueInfo wCDbWorkQueueInfo = info;
            return wCDbWorkQueueInfo;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File fromRelPath(File wriAbsPath, File localRelPath) throws SVNException {
        DirParsedInfo parsed = this.parseDir(wriAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        File wcRootAbsPath = parsed.wcDbDir.getWCRoot().getAbsPath();
        return SVNFileUtil.createFilePath(wcRootAbsPath, localRelPath);
    }

    @Override
    public Set<String> getBaseChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, true, false);
    }

    public Set<String> getWorkingChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getBaseDavCache(File localAbsPath) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbsPath, SVNWCDbStatements.SELECT_BASE_DAV_CACHE);
        try {
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNProperties sVNProperties = stmt.getColumnProperties(SVNWCDbSchema.NODES__Fields.dav_cache);
            return sVNProperties;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDavCacheRecursive(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDb.verifyDirUsable(parsed.wcDbDir);
        SVNWCDbRoot root = parsed.wcDbDir.getWCRoot();
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.CLEAR_BASE_NODE_RECURSIVE_DAV_CACHE);
        try {
            stmt.bindf("is", root.getWcId(), SVNFileUtil.getFilePath(parsed.localRelPath));
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public ISVNWCDb.WCDbBaseInfo getBaseInfo(File localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo dir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = dir.wcDbDir;
        File localRelPath = dir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return this.getBaseInfo(dir.wcDbDir.getWCRoot(), localRelPath, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbBaseInfo getBaseInfo(SVNWCDbRoot root, File localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField ... fields) throws SVNException {
        ISVNWCDb.WCDbBaseInfo info;
        block38: {
            EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbBaseInfo.BaseInfoField.class, (Enum[])fields);
            info = new ISVNWCDb.WCDbBaseInfo();
            SVNSqlJetStatement stmt = root.getSDb().getStatement(f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock) ? SVNWCDbStatements.SELECT_BASE_NODE_WITH_LOCK : SVNWCDbStatements.SELECT_BASE_NODE);
            try {
                stmt.bindf("is", root.getWcId(), SVNFileUtil.getFilePath(localRelPath));
                boolean have_row = stmt.next();
                if (have_row) {
                    ISVNWCDb.SVNWCDbKind node_kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind)) {
                        info.kind = node_kind;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.status)) {
                        info.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision)) {
                        info.revision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath)) {
                        info.reposRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock)) {
                        SVNSqlJetStatement lockStmt = stmt.getJoinedStatement(SVNWCDbSchema.LOCK);
                        if (SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token)) {
                            info.lock = null;
                        } else {
                            info.lock = new ISVNWCDb.SVNWCDbLock();
                            info.lock.token = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token);
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                                info.lock.owner = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                                info.lock.comment = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                                info.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date));
                            }
                        }
                    }
                    info.reposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid)) {
                        if (SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl)) {
                                info.reposRootUrl = null;
                            }
                            if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid)) {
                                info.reposUuid = null;
                            }
                        } else {
                            ReposInfo reposInfo = this.fetchReposInfo(root.getSDb(), SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                            info.reposRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                            info.reposUuid = reposInfo.reposUuid;
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev)) {
                        info.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate)) {
                        info.changedDate = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor)) {
                        info.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lastModTime)) {
                        info.lastModTime = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.last_mod_time));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth)) {
                        String depth_str;
                        info.depth = node_kind != ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.UNKNOWN : ((depth_str = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth)) == null ? SVNDepth.UNKNOWN : SvnWcDbStatementUtil.parseDepth(depth_str));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.File) {
                            info.checksum = null;
                        } else {
                            try {
                                info.checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)root.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.translatedSize)) {
                        info.translatedSize = SvnWcDbStatementUtil.getTranslatedSize(stmt, SVNWCDbSchema.NODES__Fields.translated_size);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.target)) {
                        info.target = node_kind != ISVNWCDb.SVNWCDbKind.Symlink ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.hadProps)) {
                        boolean bl = info.hadProps = !stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.properties) && stmt.getColumnBlob(SVNWCDbSchema.NODES__Fields.properties).length > 2;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.props)) {
                        SVNProperties properties;
                        ISVNWCDb.SVNWCDbStatus nodeStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                        if (nodeStatus == ISVNWCDb.SVNWCDbStatus.Normal || nodeStatus == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                            properties = stmt.getColumnProperties(SVNWCDbSchema.NODES__Fields.properties);
                            if (properties == null) {
                                properties = new SVNProperties();
                            }
                        } else {
                            assert (stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.properties));
                            properties = null;
                        }
                        info.props = properties;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot)) {
                        info.updateRoot = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.file_external);
                    }
                    break block38;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getBaseProps(File localAbsPath) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbsPath, SVNWCDbStatements.SELECT_BASE_PROPS);
        try {
            SVNProperties props;
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}''  was not found.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties)) == null) {
                SVNProperties sVNProperties = new SVNProperties();
                return sVNProperties;
            }
            SVNProperties sVNProperties = props;
            return sVNProperties;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public int getFormatTemp(File localDirAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localDirAbsPath));
        SVNWCDbDir pdh = this.getOrCreateDir(localDirAbsPath, false);
        if (pdh == null || pdh.getWCRoot() == null) {
            try {
                DirParsedInfo parsed = this.parseDir(localDirAbsPath, SVNSqlJetDb.Mode.ReadOnly);
                pdh = parsed.wcDbDir;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                    throw e;
                }
                if (pdh != null) {
                    pdh.setWCRoot(null);
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Path ''{0}'' is not a working copy", (Object)localDirAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            assert (pdh.getWCRoot() != null);
        }
        assert (pdh.getWCRoot().getFormat() >= 1);
        return pdh.getWCRoot().getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SvnChecksum getPristineMD5(File wcRootAbsPath, SvnChecksum sha1Checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (sha1Checksum != null);
        assert (sha1Checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_MD5_CHECKSUM);
        try {
            stmt.bindChecksum(1, sha1Checksum);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with checksum ''{0}'' not found", (Object)sha1Checksum.toString());
                SVNErrorManager.error(err, SVNLogType.WC);
                SvnChecksum svnChecksum = null;
                return svnChecksum;
            }
            SvnChecksum md5Checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.PRISTINE__Fields.md5_checksum);
            assert (md5Checksum.getKind() == SvnChecksum.Kind.md5);
            SvnChecksum svnChecksum = md5Checksum;
            return svnChecksum;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File getPristinePath(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristinePath(pdh.getWCRoot(), checksum);
    }

    @Override
    public SvnChecksum getPristineSHA1(File wcRootAbsPath, SvnChecksum md5Checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (md5Checksum.getKind() == SvnChecksum.Kind.md5);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristineSHA1(pdh.getWCRoot(), md5Checksum);
    }

    @Override
    public File getPristineTempDir(File wcRootAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristineTempDir(pdh.getWCRoot(), wcRootAbsPath);
    }

    @Override
    public void globalRecordFileinfo(File localAbspath, long translatedSize, long lastModTime) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        RecordFileinfo rb = new RecordFileinfo();
        rb.wcRoot = pdh.getWCRoot();
        rb.localRelpath = parsed.localRelPath;
        rb.translatedSize = translatedSize;
        rb.lastModTime = lastModTime;
        pdh.getWCRoot().getSDb().runTransaction(rb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void installPristine(File tempfileAbspath, SvnChecksum sha1Checksum, SvnChecksum md5Checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(tempfileAbspath));
        File wriAbspath = SVNFileUtil.getParentFile(tempfileAbspath);
        DirParsedInfo parsed = this.parseDir(wriAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.installPristine(pdh.getWCRoot(), tempfileAbspath, sha1Checksum, md5Checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeHidden(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsedInfo = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsedInfo.wcDbDir;
        File localRelPath = parsedInfo.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), SVNFileUtil.getFilePath(localRelPath));
            boolean have_row = stmt.next();
            if (have_row) {
                ISVNWCDb.SVNWCDbStatus work_status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                boolean bl = work_status == ISVNWCDb.SVNWCDbStatus.Excluded;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
        ISVNWCDb.SVNWCDbStatus base_status = baseInfo.status;
        return base_status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || base_status == ISVNWCDb.SVNWCDbStatus.NotPresent || base_status == ISVNWCDb.SVNWCDbStatus.Excluded;
    }

    public DirParsedInfo parseDir(File localAbsPath, SVNSqlJetDb.Mode sMode) throws SVNException {
        return this.parseDir(localAbsPath, sMode, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirParsedInfo parseDir(File localAbspath, SVNSqlJetDb.Mode sMode, boolean isDetectWCGeneration, boolean isAdditionMode) throws SVNException {
        SVNErrorMessage err;
        File localDirAbspath;
        String buildRelPath;
        SVNNodeKind kind;
        DirParsedInfo info = new DirParsedInfo();
        File originalAbspath = localAbspath;
        SVNWCDbDir foundRoot = null;
        boolean movedUpwards = false;
        boolean alwaysCheck = false;
        sMode = SVNSqlJetDb.Mode.ReadWrite;
        SVNSqlJetDb sDb = null;
        int wc_format = 0;
        boolean isOldFormat = false;
        SVNWCDbDir probeRoot = this.dirData.get(localAbspath.getAbsolutePath());
        SVNFileType fileType = null;
        if (probeRoot != null) {
            fileType = SVNFileType.getType(localAbspath);
            if (!isAdditionMode || fileType != SVNFileType.SYMLINK) {
                info.wcDbDir = probeRoot;
                info.localRelPath = probeRoot.computeRelPath();
                return info;
            }
        }
        if (fileType == null) {
            fileType = SVNFileType.getType(localAbspath);
        }
        boolean isSymlink = fileType == SVNFileType.SYMLINK;
        SVNNodeKind sVNNodeKind = kind = fileType == SVNFileType.DIRECTORY || isSymlink && localAbspath.isDirectory() ? SVNNodeKind.DIR : SVNFileType.getNodeKind(fileType);
        if (kind != SVNNodeKind.DIR || isSymlink) {
            buildRelPath = SVNFileUtil.getFileName(localAbspath);
            localDirAbspath = SVNFileUtil.getParentFile(localAbspath);
            if (localDirAbspath == null) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)originalAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((probeRoot = this.dirData.get(localDirAbspath.getAbsolutePath())) != null) {
                if (!isSymlink || isAdditionMode) {
                    info.wcDbDir = probeRoot;
                    info.localRelPath = SVNFileUtil.createFilePath(info.wcDbDir.computeRelPath(), buildRelPath);
                    return info;
                }
                foundRoot = probeRoot;
            }
            if (kind == SVNNodeKind.NONE) {
                alwaysCheck = true;
            }
            localAbspath = localDirAbspath;
        } else {
            buildRelPath = "";
            localDirAbspath = localAbspath;
        }
        while (true) {
            SVNNodeKind resolvedKind;
            if (foundRoot == null) {
                while (true) {
                    try {
                        sDb = SVNWCDb.openDb(localAbspath, "wc.db", sMode, this.journalMode, this.temporaryDbInMemory);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.SQLITE_ERROR && !e.isEnoent()) {
                            throw e;
                        }
                        if ((!movedUpwards || alwaysCheck || isDetectWCGeneration) && (wc_format = this.getOldVersion(localAbspath)) != 0) break;
                        if (SVNFileUtil.getParentFile(localAbspath) == null) {
                            SVNNodeKind resolvedKind2;
                            if (isSymlink && !isAdditionMode && (resolvedKind2 = SVNFileType.getNodeKind(SVNFileType.getType(SVNFileUtil.resolveSymlink(localAbspath = originalAbspath)))) == SVNNodeKind.DIR) {
                                foundRoot = this.dirData.get(localAbspath.getAbsolutePath());
                                if (foundRoot != null) break;
                                kind = SVNNodeKind.DIR;
                                isSymlink = false;
                                movedUpwards = false;
                                localDirAbspath = localAbspath;
                                buildRelPath = "";
                                continue;
                            }
                            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)originalAbspath);
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        localAbspath = SVNFileUtil.getParentFile(localAbspath);
                        movedUpwards = true;
                        foundRoot = this.dirData.get(localAbspath.getAbsolutePath());
                        if (foundRoot != null) break;
                        continue;
                    }
                    break;
                }
            }
            if (foundRoot != null) {
                info.wcDbDir = foundRoot;
            } else if (wc_format == 0) {
                long wcId;
                block38: {
                    wcId = -1L;
                    try {
                        wcId = this.fetchWCId(sDb);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_CORRUPT) break block38;
                        SVNErrorMessage err2 = e.getErrorMessage().wrap("Missing a row in WCROOT for ''{0}''.", originalAbspath);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                }
                info.wcDbDir = new SVNWCDbDir(localAbspath);
                boolean allowWc17Access = this.isWC17AccessEnabled() || isDetectWCGeneration;
                info.wcDbDir.setWCRoot(new SVNWCDbRoot(this, localAbspath, sDb, wcId, -1, this.autoUpgrade, !allowWc17Access, this.enforceEmptyWQ));
            } else {
                info.wcDbDir = new SVNWCDbDir(localAbspath);
                info.wcDbDir.setWCRoot(new SVNWCDbRoot(this, localAbspath, null, -1L, wc_format, this.autoUpgrade, false, this.enforceEmptyWQ));
                isOldFormat = true;
            }
            String dirRelPath = SVNPathUtil.getRelativePath(info.wcDbDir.getWCRoot().getAbsPath().getAbsolutePath(), localDirAbspath.getAbsolutePath());
            info.localRelPath = SVNFileUtil.createFilePath(dirRelPath, buildRelPath);
            if (!isSymlink || isAdditionMode) break;
            boolean retryIfDir = false;
            if (isOldFormat) {
                try (SVNAdminArea area = null;){
                    area = SVNWCAccess.newInstance(null).open(localDirAbspath, false, false, 0);
                    retryIfDir = area.getEntry(SVNFileUtil.getFileName(originalAbspath), false) == null;
                }
            } else {
                try {
                    ISVNWCDb.WCDbInfo wcDbInfo = this.readInfo(info.wcDbDir.getWCRoot(), info.localRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.conflicted);
                    ISVNWCDb.SVNWCDbStatus status = wcDbInfo.status;
                    boolean conflicted = wcDbInfo.conflicted;
                    retryIfDir = (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded) && !conflicted;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_UPGRADE_REQUIRED && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                        throw e;
                    }
                    retryIfDir = true;
                }
            }
            if (!retryIfDir || (resolvedKind = SVNFileType.getNodeKind(SVNFileType.getType(SVNFileUtil.resolveSymlink(localAbspath)))) != SVNNodeKind.DIR) break;
            localAbspath = originalAbspath;
            kind = SVNNodeKind.DIR;
            isSymlink = false;
            movedUpwards = false;
            localDirAbspath = localAbspath;
            buildRelPath = "";
            foundRoot = null;
            wc_format = 0;
        }
        if (!isAdditionMode || !isSymlink) {
            File parentDir;
            SVNWCDbDir wcDbDir = new SVNWCDbDir(localDirAbspath);
            wcDbDir.setWCRoot(info.wcDbDir.getWCRoot());
            this.dirData.put(wcDbDir.getLocalAbsPath().getAbsolutePath(), wcDbDir);
            if (!movedUpwards) {
                return info;
            }
            File scanAbspath = localDirAbspath;
            do {
                SVNWCDbDir parentRoot;
                if ((parentRoot = this.dirData.get((parentDir = SVNFileUtil.getParentFile(scanAbspath)).getAbsolutePath())) != null) continue;
                SVNWCDbDir parentWcDbDir = new SVNWCDbDir(parentDir);
                parentWcDbDir.setWCRoot(info.wcDbDir.getWCRoot());
                this.dirData.put(parentWcDbDir.getLocalAbsPath().getAbsolutePath(), parentWcDbDir);
            } while (!localAbspath.equals(scanAbspath = parentDir));
        }
        return info;
    }

    /*
     * Loose catch block
     */
    private int getOldVersion(File localAbsPath) {
        File entriesFile;
        File adminDir;
        int formatVersion;
        block8: {
            if (localAbsPath == null) {
                return 0;
            }
            formatVersion = 0;
            adminDir = new File(localAbsPath, SVNFileUtil.getAdminDirectoryName());
            entriesFile = new File(adminDir, "entries");
            if (entriesFile.exists()) break block8;
            return 0;
            {
                catch (SVNException e) {
                    return 0;
                }
            }
        }
        try {
            formatVersion = this.readFormatVersion(entriesFile);
            return formatVersion;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.BAD_VERSION_FILE_FORMAT && (e.getErrorMessage().getChildErrorMessage() == null || e.getErrorMessage().getChildErrorMessage().getErrorCode() != SVNErrorCode.BAD_VERSION_FILE_FORMAT)) {
                throw e;
            }
            File formatFile = new File(adminDir, "format");
            if (formatFile.exists()) {
                formatVersion = this.readFormatVersion(formatFile);
            }
            return formatVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int readFormatVersion(File path) throws SVNException {
        SVNErrorMessage err;
        int formatVersion = -1;
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(path, Level.FINEST, SVNLogType.WC), "UTF-8"));
            line = reader.readLine();
        }
        catch (IOException e) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", path, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
            SVNFileUtil.closeFile(reader);
        }
        catch (SVNException svne) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err.setChildErrorMessage(svne.getErrorMessage());
            SVNErrorManager.error(err, svne, Level.FINEST, SVNLogType.WC);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(reader);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(reader);
        }
        SVNFileUtil.closeFile(reader);
        if (line == null || line.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)path);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err2);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)path);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        return formatVersion;
    }

    @Override
    public boolean isWCLocked(File localAbspath) throws SVNException {
        return this.isWCLocked(localAbspath, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWCLocked(File localAbspath, long recurseDepth) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbspath, SVNWCDbStatements.SELECT_WC_LOCK);
        try {
            boolean have_row = stmt.next();
            if (have_row) {
                long locked_levels = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                boolean bl = locked_levels == -1L || locked_levels >= recurseDepth;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        File parentFile = SVNFileUtil.getParentFile(localAbspath);
        if (parentFile == null) {
            return false;
        }
        try {
            return this.isWCLocked(parentFile, recurseDepth + 1L);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWCLocked(SVNWCDbRoot root, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_ANCESTORS_WC_LOCKS);
        int pathDepth = SVNWCUtils.relpathDepth(localRelpath);
        stmt.bindf("is", root.getWcId(), localRelpath);
        try {
            while (stmt.next()) {
                File lockedPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.WC_LOCK__Fields.local_dir_relpath);
                if (!SVNWCUtils.isAncestor(lockedPath, localRelpath)) continue;
                long locked_levels = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                int lockedPathDepth = SVNWCUtils.relpathDepth(lockedPath);
                boolean bl = locked_levels == -1L || locked_levels + (long)lockedPathDepth >= (long)pathDepth;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        return false;
    }

    @Override
    public SVNSqlJetDb getSDb(File localAbsPath) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return pdh.getWCRoot().getSDb();
    }

    @Override
    public void opAddDirectory(File localAbsPath, SVNProperties props, SVNSkel workItems) throws SVNException {
        File dirAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        String name = SVNFileUtil.getFileName(localAbsPath);
        DirParsedInfo parseDir = this.parseDir(dirAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = SVNFileUtil.createFilePath(parseDir.localRelPath, name);
        SVNWCDb.verifyDirUsable(pdh);
        InsertWorking ibw = new InsertWorking();
        ibw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibw.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibw.opDepth = SVNWCUtils.relpathDepth(localRelpath);
        ibw.localRelpath = localRelpath;
        ibw.wcRoot = pdh.getWCRoot();
        if (props != null && props.size() > 0) {
            ibw.updateActualProps = true;
            ibw.newActualProps = props;
        }
        ibw.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(ibw);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void opAddFile(File localAbsPath, SVNProperties props, SVNSkel workItems) throws SVNException {
        File dirAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        String name = SVNFileUtil.getFileName(localAbsPath);
        DirParsedInfo parseDir = this.parseDir(dirAbsPath, SVNSqlJetDb.Mode.ReadWrite, false, true);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = SVNFileUtil.createFilePath(parseDir.localRelPath, name);
        SVNWCDb.verifyDirUsable(pdh);
        InsertWorking ibw = new InsertWorking();
        ibw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibw.kind = ISVNWCDb.SVNWCDbKind.File;
        ibw.opDepth = SVNWCUtils.relpathDepth(localRelpath);
        ibw.localRelpath = localRelpath;
        ibw.wcRoot = pdh.getWCRoot();
        if (props != null && props.size() > 0) {
            ibw.updateActualProps = true;
            ibw.newActualProps = props;
        }
        ibw.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(ibw);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void opAddSymlink(File localAbsPath, File target, SVNProperties props, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        assert (target != null);
        File dirAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        String name = SVNFileUtil.getFileName(localAbsPath);
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = SVNFileUtil.createFilePath(parsed.localRelPath, name);
        InsertWorking iw = new InsertWorking();
        iw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        iw.kind = ISVNWCDb.SVNWCDbKind.Symlink;
        iw.opDepth = SVNWCUtils.relpathDepth(localRelPath);
        if (props != null && props.size() > 0) {
            iw.updateActualProps = true;
            iw.newActualProps = props;
        }
        iw.target = target;
        iw.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(iw);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void opCopy(File srcAbsPath, File dstAbsPath, File dstOpRootAbsPath, boolean isMove, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(srcAbsPath));
        assert (SVNWCDb.isAbsolute(dstAbsPath));
        assert (SVNWCDb.isAbsolute(dstOpRootAbsPath));
        DirParsedInfo parseSrcDir = this.parseDir(srcAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir srcPdh = parseSrcDir.wcDbDir;
        File localSrcRelpath = parseSrcDir.localRelPath;
        SVNWCDb.verifyDirUsable(srcPdh);
        DirParsedInfo parseDstDir = this.parseDir(dstAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir dstPdh = parseDstDir.wcDbDir;
        File localDstRelpath = parseDstDir.localRelPath;
        SVNWCDb.verifyDirUsable(dstPdh);
        File dstOpRootRelPath = SVNFileUtil.skipAncestor(dstPdh.getWCRoot().getAbsPath(), dstOpRootAbsPath);
        SvnWcDbCopy.copy(srcPdh, localSrcRelpath, dstPdh, localDstRelpath, dstOpRootRelPath, isMove, workItems);
    }

    @Override
    public void opCopyShadowedLayer(File srcAbsPath, File dstAbsPath, boolean isMove) throws SVNException {
        DirParsedInfo parseSrcDir = this.parseDir(srcAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir srcPdh = parseSrcDir.wcDbDir;
        File localSrcRelpath = parseSrcDir.localRelPath;
        SVNWCDb.verifyDirUsable(srcPdh);
        DirParsedInfo parseDstDir = this.parseDir(dstAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir dstPdh = parseDstDir.wcDbDir;
        File localDstRelpath = parseDstDir.localRelPath;
        SVNWCDb.verifyDirUsable(dstPdh);
        SvnWcDbCopy.copyShadowedLayer(srcPdh, localSrcRelpath, dstPdh, localDstRelpath, isMove);
    }

    @Override
    public void opCopyDir(File localAbsPath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, List<File> children, boolean isMove, SVNDepth depth, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbCopy.copyDir(pdh, localRelpath, props, changedRev, changedDate, changedAuthor, originalReposRelPath, originalRootUrl, originalUuid, originalRevision, children, isMove, depth, conflict, workItems);
    }

    @Override
    public void opCopyFile(File localAbsPath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, SvnChecksum checksum, boolean updateActualProps, SVNProperties newActualProps, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbCopy.copyFile(pdh, localRelpath, props, changedRev, changedDate, changedAuthor, originalReposRelPath, originalRootUrl, originalUuid, originalRevision, checksum, updateActualProps, newActualProps, conflict, workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opDelete(File localAbsPath, File movedToAbsPath, boolean deleteDirExternals, SVNSkel conflict, SVNSkel workItems, ISVNEventHandler eventHandler) throws SVNException {
        block17: {
            File movedToRelPath;
            DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
            SVNWCDbDir pdh = parsed.wcDbDir;
            File localRelpath = parsed.localRelPath;
            SVNWCDb.verifyDirUsable(pdh);
            if (movedToAbsPath != null) {
                DirParsedInfo parsedMovedTo = this.parseDir(movedToAbsPath, SVNSqlJetDb.Mode.ReadOnly);
                SVNWCDb.verifyDirUsable(parsedMovedTo.wcDbDir);
                if (!pdh.getWCRoot().getAbsPath().equals(parsedMovedTo.wcDbDir.getWCRoot().getAbsPath())) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move ''{0}'' to ''{1}'' because they are not in the same working copy", localAbsPath, movedToAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                movedToRelPath = parsedMovedTo.localRelPath;
            } else {
                movedToRelPath = null;
            }
            Delete deleteTxn = new Delete();
            deleteTxn.root = pdh.getWCRoot();
            deleteTxn.localRelPath = localRelpath;
            deleteTxn.deleteDepth = SVNWCUtils.relpathDepth(localRelpath);
            deleteTxn.eventHandler = eventHandler;
            deleteTxn.movedToRelPath = movedToRelPath;
            deleteTxn.deleteDirExternals = deleteDirExternals;
            deleteTxn.conflict = conflict;
            deleteTxn.workItems = workItems;
            pdh.flushEntries(localAbsPath);
            pdh.getWCRoot().getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                try {
                    deleteTxn.transaction(pdh.getWCRoot().getSDb());
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
                if (eventHandler == null || !pdh.getWCRoot().getSDb().getTemporaryDb().hasTable(SVNWCDbSchema.DELETE_LIST.toString())) break block17;
                SVNSqlJetSelectStatement selectDeleteList = new SVNSqlJetSelectStatement(pdh.getWCRoot().getSDb().getTemporaryDb(), SVNWCDbSchema.DELETE_LIST);
                try {
                    while (((SVNSqlJetStatement)selectDeleteList).next()) {
                        File path = SvnWcDbStatementUtil.getColumnPath(selectDeleteList, SVNWCDbSchema.DELETE_LIST__Fields.local_relpath);
                        path = pdh.getWCRoot().getAbsPath(path);
                        eventHandler.handleEvent(SVNEventFactory.createSVNEvent(path, SVNNodeKind.NONE, null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null, 1L, 1L), -1.0);
                    }
                }
                finally {
                    ((SVNSqlJetStatement)selectDeleteList).reset();
                }
                SVNWCDbCreateSchema dropList = new SVNWCDbCreateSchema(pdh.getWCRoot().getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_DELETE_LIST, -1, false);
                try {
                    dropList.done();
                }
                finally {
                    dropList.reset();
                }
            }
            catch (SVNException e) {
                pdh.getWCRoot().getSDb().rollback();
                throw e;
            }
            finally {
                pdh.getWCRoot().getSDb().commit();
            }
        }
    }

    @Override
    public void opMarkResolved(File localAbspath, boolean resolvedText, boolean resolvedProps, boolean resolvedTree, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        this.opMarkResolvedInternal(wcRoot, localRelpath, resolvedText, resolvedProps, resolvedTree, workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opMarkResolvedInternal(SVNWCDbRoot wcRoot, File localRelpath, boolean resolvedText, boolean resolvedProps, boolean resolvedTree, SVNSkel workItems) throws SVNException {
        SVNSkel conflicts;
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                stmt.reset();
                stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                stmt.bindf("is", wcRoot.getWcId(), localRelpath);
                haveRow = stmt.next();
                if (haveRow) {
                    return;
                }
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node '{0}' was not found.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelpath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (wcRoot.getFormat() == 29) {
                String conflictOld = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
                String conflictWorking = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                String conflictNew = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                String propReject = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
                byte[] treeConflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                conflicts = SvnWcDbConflicts.convertToConflictSkel(wcRoot.getAbsPath(), wcRoot.getDb(), SVNFileUtil.getFilePath(localRelpath), conflictOld, conflictWorking, conflictNew, propReject, treeConflictData);
            } else {
                conflicts = SVNSkel.parse(stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data));
            }
        }
        finally {
            stmt.reset();
        }
        boolean resolvedAll = SvnWcDbConflicts.conflictSkelResolve(conflicts, this, wcRoot.getAbsPath(), resolvedText, resolvedProps ? "" : null, resolvedTree);
        long updatedRows = 0L;
        if (wcRoot.getFormat() == 29) {
            updatedRows = this.updateActualConflict17(wcRoot, localRelpath, conflicts, resolvedAll);
        } else {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT);
            try {
                stmt.bindf("is", wcRoot.getWcId(), localRelpath);
                if (!resolvedAll) {
                    stmt.bindBlob(3, conflicts.unparse());
                }
                updatedRows = stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        if (updatedRows > 0L) {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_EMPTY);
            try {
                stmt.bindf("is", wcRoot.getWcId(), localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        SVNWCDb.addWorkItems(wcRoot.getSDb(), workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateActualConflict17(SVNWCDbRoot wcRoot, File localRelpath, SVNSkel conflicts, boolean resolvedAll) throws SVNException {
        File wcRootAbsPath = wcRoot.getAbsPath();
        byte[] treeConflictData = null;
        File conflictOldRelPath = null;
        File conflictNewRelPath = null;
        File conflictWorkingRelPath = null;
        File prejRelPath = null;
        if (!resolvedAll && conflicts != null) {
            List<SVNWCConflictDescription17> conflictDescriptions = SvnWcDbConflicts.convertFromSkel(wcRoot.getDb(), SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelpath), false, conflicts);
            File conflictOldAbsPath = null;
            File conflictNewAbsPath = null;
            File conflictWorkingAbsPath = null;
            File prejAbsPath = null;
            for (SVNWCConflictDescription17 conflictDescription17 : conflictDescriptions) {
                SVNMergeFileSet mergeFiles;
                SVNConflictDescription conflictDescription = conflictDescription17.toConflictDescription();
                if (conflictDescription instanceof SVNTextConflictDescription) {
                    SVNTextConflictDescription textConflictDescription = (SVNTextConflictDescription)conflictDescription;
                    mergeFiles = textConflictDescription.getMergeFiles();
                    conflictOldAbsPath = mergeFiles.getBaseFile();
                    conflictWorkingAbsPath = mergeFiles.getLocalFile();
                    conflictNewAbsPath = mergeFiles.getRepositoryFile();
                    continue;
                }
                if (conflictDescription instanceof SVNPropertyConflictDescription) {
                    SVNPropertyConflictDescription propertyConflictDescription = (SVNPropertyConflictDescription)conflictDescription;
                    mergeFiles = propertyConflictDescription.getMergeFiles();
                    prejAbsPath = mergeFiles.getRepositoryFile();
                    continue;
                }
                if (!(conflictDescription instanceof SVNTreeConflictDescription)) continue;
                SVNTreeConflictDescription treeConflictDescription = (SVNTreeConflictDescription)conflictDescription;
                treeConflictData = SVNTreeConflictUtil.getSingleTreeConflictRawData(treeConflictDescription);
            }
            conflictOldRelPath = conflictOldAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictOldAbsPath);
            conflictNewRelPath = conflictNewAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictNewAbsPath);
            conflictWorkingRelPath = conflictWorkingAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictWorkingAbsPath);
            prejRelPath = prejAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, prejAbsPath);
        }
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT_DATA_17);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelpath);
            if (!resolvedAll) {
                stmt.bindString(3, SVNFileUtil.getFilePath(conflictOldRelPath));
                stmt.bindString(4, SVNFileUtil.getFilePath(conflictNewRelPath));
                stmt.bindString(5, SVNFileUtil.getFilePath(conflictWorkingRelPath));
                stmt.bindString(6, SVNFileUtil.getFilePath(prejRelPath));
                stmt.bindBlob(7, treeConflictData);
            }
            long l = stmt.done();
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void opMarkConflict(File localAbspath, SVNSkel conflictSkel, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        this.markConflictInternal(pdh.getWCRoot(), localRelPath, conflictSkel);
        if (workItems != null) {
            SVNWCDb.addWorkItems(pdh.getWCRoot().getSDb(), workItems);
        }
        this.flushEntries(pdh.getWCRoot(), localRelPath, SVNDepth.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markConflictInternal(SVNWCDbRoot wcRoot, File localRelPath, SVNSkel conflictSkel) throws SVNException {
        boolean gotRow;
        boolean isComplete = SvnWcDbConflicts.isConflictSkelComplete(conflictSkel);
        assert (isComplete);
        if (wcRoot.getFormat() == 29) {
            this.markConflictInternal17(wcRoot, localRelPath, conflictSkel);
            return;
        }
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            gotRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        stmt = null;
        try {
            if (gotRow) {
                stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT_DATA);
                stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            } else {
                stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_CONFLICT_DATA);
                stmt.bindf("is", wcRoot.getWcId(), localRelPath);
                if (localRelPath.getPath().length() > 0) {
                    stmt.bindString(4, SVNPathUtil.removeTail(SVNFileUtil.getFilePath(localRelPath)));
                }
            }
            byte[] conflictData = conflictSkel.unparse();
            stmt.bindBlob(3, conflictData);
            stmt.exec();
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markConflictInternal17(SVNWCDbRoot wcRoot, File localRelPath, SVNSkel conflictSkel) throws SVNException {
        File wcRootAbsPath = wcRoot.getAbsPath();
        File localAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, localRelPath);
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        List locations = (List)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.locations);
        File conflictOldRelPath = null;
        File conflictNewRelPath = null;
        File conflictWorkingRelPath = null;
        File prejRelPath = null;
        byte[] treeConflictRawData = null;
        if (conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.textConflicted)) {
            Structure<SvnWcDbConflicts.TextConflictInfo> textConflictInfoStructure = SvnWcDbConflicts.readTextConflict(wcRoot.getDb(), localAbsPath, conflictSkel);
            File mineAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.mineAbsPath);
            File theirOldAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirOldAbsPath);
            File theirAbsPath = (File)textConflictInfoStructure.get(SvnWcDbConflicts.TextConflictInfo.theirAbsPath);
            conflictOldRelPath = theirOldAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, theirOldAbsPath);
            conflictNewRelPath = theirAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, theirAbsPath);
            File file = conflictWorkingRelPath = mineAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, mineAbsPath);
        }
        if (conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.propConflicted)) {
            Structure<SvnWcDbConflicts.PropertyConflictInfo> propertyConflictInfoStructure = SvnWcDbConflicts.readPropertyConflict(wcRoot.getDb(), localAbsPath, conflictSkel);
            File markerAbsPath = (File)propertyConflictInfoStructure.get(SvnWcDbConflicts.PropertyConflictInfo.markerAbspath);
            File file = prejRelPath = markerAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, markerAbsPath);
        }
        if (conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted)) {
            Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(wcRoot.getDb(), localAbsPath, conflictSkel);
            SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
            SVNConflictAction action = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
            SVNConflictVersion sourceLeftVersion = (SVNConflictVersion)locations.get(0);
            SVNConflictVersion sourceRightVersion = (SVNConflictVersion)locations.get(1);
            SVNNodeKind nodeKind = SVNNodeKind.UNKNOWN;
            if (sourceRightVersion != null) {
                nodeKind = sourceRightVersion.getKind();
            } else if (sourceLeftVersion != null) {
                nodeKind = sourceLeftVersion.getKind();
            }
            SVNTreeConflictDescription treeConflictDescription = new SVNTreeConflictDescription(localAbsPath, nodeKind, action, reason, operation, sourceLeftVersion, sourceRightVersion);
            treeConflictRawData = SVNTreeConflictUtil.getSingleTreeConflictRawData(treeConflictDescription);
        }
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean gotRow = stmt.next();
            stmt.reset();
            if (gotRow) {
                stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT_DATA_17);
                stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            } else {
                stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_CONFLICT_DATA_17);
                stmt.bindf("is", wcRoot.getWcId(), localRelPath);
                if (SVNFileUtil.getFilePath(localRelPath).length() > 0) {
                    stmt.bindString(8, SVNPathUtil.removeTail(SVNFileUtil.getFilePath(localRelPath)));
                }
            }
            stmt.bindString(3, SVNFileUtil.getFilePath(conflictOldRelPath));
            stmt.bindString(4, SVNFileUtil.getFilePath(conflictNewRelPath));
            stmt.bindString(5, SVNFileUtil.getFilePath(conflictWorkingRelPath));
            stmt.bindString(6, SVNFileUtil.getFilePath(prejRelPath));
            stmt.bindBlob(7, treeConflictRawData);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    private void flushEntries(SVNWCDbRoot wcRoot, File localAbsPath, SVNDepth depth) {
        Map<String, SVNWCDbDir> cache = wcRoot.getDb().dirData;
        if (cache.size() == 0) {
            return;
        }
        cache.remove(localAbsPath.getAbsolutePath());
        if (depth.compareTo(SVNDepth.EMPTY) > 0) {
            Iterator<Map.Entry<String, SVNWCDbDir>> iterator2 = cache.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, SVNWCDbDir> entry = iterator2.next();
                String itemAbsPath = entry.getKey();
                if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
                    iterator2.remove();
                    continue;
                }
                if (depth != SVNDepth.INFINITY || !SVNPathUtil.isAncestor(localAbsPath.getAbsolutePath(), itemAbsPath)) continue;
                iterator2.remove();
            }
        }
        File parentAbsPath = SVNFileUtil.getFileDir(localAbsPath);
        cache.remove(parentAbsPath.getAbsolutePath());
    }

    @Override
    public Map<String, SVNTreeConflictDescription> opReadAllTreeConflicts(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return this.readAllTreeConflicts(pdh, localRelpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SVNTreeConflictDescription> readAllTreeConflicts(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        if (pdh.getWCRoot().getFormat() == 29) {
            return this.readAllTreeConflicts17(pdh, localRelpath);
        }
        HashMap<String, SVNTreeConflictDescription> treeConflicts = new HashMap<String, SVNTreeConflictDescription>();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_CONFLICT);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File childRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
                String childBaseName = SVNFileUtil.getFileName(childRelpath);
                byte[] conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data);
                SVNSkel skel = SVNSkel.parse(conflictData);
                Structure<SvnWcDbConflicts.ConflictInfo> conflictInfo = SvnWcDbConflicts.readConflictInfo(skel);
                if (conflictInfo != null && conflictInfo.is(SvnWcDbConflicts.ConflictInfo.treeConflicted)) {
                    List locations = (List)conflictInfo.get(SvnWcDbConflicts.ConflictInfo.locations);
                    SVNConflictVersion leftVersion = null;
                    SVNConflictVersion rightVersion = null;
                    if (locations != null && locations.size() > 0) {
                        leftVersion = (SVNConflictVersion)locations.get(0);
                    }
                    if (locations != null && locations.size() > 1) {
                        rightVersion = (SVNConflictVersion)locations.get(1);
                    }
                    File childAbsPath = pdh.getWCRoot().getAbsPath(childRelpath);
                    Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfo = SvnWcDbConflicts.readTreeConflict(this, childAbsPath, skel);
                    SVNNodeKind tcKind = leftVersion != null ? leftVersion.getKind() : (rightVersion != null ? rightVersion.getKind() : SVNNodeKind.FILE);
                    SVNTreeConflictDescription treeConflict = new SVNTreeConflictDescription(childAbsPath, tcKind, (SVNConflictAction)treeConflictInfo.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange), (SVNConflictReason)treeConflictInfo.get(SvnWcDbConflicts.TreeConflictInfo.localChange), (SVNOperation)conflictInfo.get(SvnWcDbConflicts.ConflictInfo.conflictOperation), leftVersion, rightVersion);
                    treeConflicts.put(childBaseName, treeConflict);
                }
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return treeConflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SVNTreeConflictDescription> readAllTreeConflicts17(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        HashMap<String, SVNTreeConflictDescription> treeConflicts = new HashMap<String, SVNTreeConflictDescription>();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_CONFLICT_17);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File childRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
                String childBaseName = SVNFileUtil.getFileName(childRelpath);
                byte[] conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                SVNSkel skel = SVNSkel.parse(conflictData);
                SVNTreeConflictDescription treeConflictDescription = SVNTreeConflictUtil.readSingleTreeConflict(skel, SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelpath));
                treeConflicts.put(childBaseName, treeConflictDescription);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return treeConflicts;
    }

    @Override
    public SVNTreeConflictDescription opReadTreeConflict(File localAbsPath) throws SVNException {
        List<SVNConflictDescription> conflicts = this.readConflicts(localAbsPath);
        if (conflicts == null || conflicts.isEmpty()) {
            return null;
        }
        for (SVNConflictDescription conflictDescription : conflicts) {
            if (!conflictDescription.isTreeConflict()) continue;
            return (SVNTreeConflictDescription)conflictDescription;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void opMakeCopy(File localAbspath, SVNSkel conflicts, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelpath = this.toRelPath(localAbspath);
        SVNSqlJetDb sdb = pdh.getWCRoot().getSDb();
        sdb.beginTransaction(SqlJetTransactionMode.WRITE);
        SVNSqlJetStatement stmt = null;
        try {
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Modification of ''{0}'' already exists", (Object)localAbspath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            this.catchCopyOfServerExcluded(pdh.getWCRoot(), localRelpath);
            MakeCopy makeCopy = new MakeCopy();
            makeCopy.pdh = pdh;
            makeCopy.localAbspath = localAbspath;
            makeCopy.localRelpath = localRelpath;
            makeCopy.opDepth = SVNWCUtils.relpathDepth(localRelpath);
            makeCopy.conflicts = conflicts;
            makeCopy.workItems = workItems;
            sdb.runTransaction(makeCopy);
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
            sdb.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRevert(File localAbspath, SVNDepth depth, boolean clearChangelists) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetDb sdb = pdh.getWCRoot().getSDb();
        sdb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            SVNWCDbCreateSchema stmt = new SVNWCDbCreateSchema(sdb.getTemporaryDb(), SVNWCDbCreateSchema.REVERT_LIST, -1, false);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (depth == SVNDepth.INFINITY) {
                SvnWcDbRevert.revertRecursive(pdh.getWCRoot(), parsed.localRelPath, clearChangelists);
            } else if (depth == SVNDepth.EMPTY) {
                SvnWcDbRevert.revert(pdh.getWCRoot(), parsed.localRelPath, clearChangelists);
            }
        }
        catch (SVNException e) {
            sdb.rollback();
            throw e;
        }
        finally {
            sdb.commit();
        }
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void opSetChangelist(File localAbspath, String changelistName, String[] changeLists, SVNDepth depth, ISVNEventHandler eventHandler) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SvnWcDbChangelist.setChangelist(pdh.getWCRoot(), parsed.localRelPath, changelistName, changeLists, depth, eventHandler);
    }

    @Override
    public void opSetProps(File localAbsPath, SVNProperties props, SVNSkel conflict, boolean clearRecordedInfo, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SetProperties spb = new SetProperties();
        spb.props = props;
        spb.pdh = pdh;
        spb.conflict = conflict;
        spb.workItems = workItems;
        spb.localRelpath = parsed.localRelPath;
        spb.clearRecordedInfo = clearRecordedInfo;
        pdh.getWCRoot().getSDb().runTransaction(spb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActualProperties(SVNSqlJetDb db, long wcId, File localRelpath, SVNProperties props) throws SVNException {
        long affectedRows;
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_PROPS);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.bindProperties(3, props);
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 1L || props == null) {
            return;
        }
        stmt = db.getStatement(SVNWCDbStatements.INSERT_ACTUAL_PROPS);
        try {
            stmt.bindf("is", wcId, localRelpath);
            if (localRelpath != null && !"".equals(SVNFileUtil.getFilePath(localRelpath))) {
                stmt.bindString(3, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
            } else {
                stmt.bindNull(3);
            }
            stmt.bindProperties(4, props);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void opSetTreeConflict(File localAbspath, SVNTreeConflictDescription treeConflict) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        SVNSkel conflictSkel = SvnWcDbConflicts.treeConflictDescriptionToSkel(this, localAbspath, treeConflict);
        this.opMarkConflict(localAbspath, conflictSkel, null);
    }

    @Override
    public Set<String> readChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, false, false);
    }

    @Override
    public Set<String> getChildrenOfWorkingNode(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        TreeSet<String> names = new TreeSet<String>();
        SVNSqlJetStatement work_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WORKING_CHILDREN);
        work_stmt.bindf("is", wcId, SVNFileUtil.getFilePath(localRelPath));
        this.addChildren(names, work_stmt);
        return names;
    }

    @Override
    public void readChildren(File localAbsPath, Map<String, ISVNWCDb.SVNWCDbInfo> children, Set<String> conflicts) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        this.readChildren(pdh.getWCRoot(), localRelPath, children, conflicts);
    }

    public void readChildren(SVNWCDbRoot root, File localRelPath, Map<String, ISVNWCDb.SVNWCDbInfo> children, Set<String> conflicts) throws SVNException {
        GatherChildren gather = new GatherChildren();
        gather.dirRelPath = localRelPath;
        gather.wcRoot = root;
        gather.nodes = children;
        gather.conflicts = conflicts;
        root.getSDb().runTransaction(gather, SqlJetTransactionMode.READ_ONLY);
    }

    private Set<String> gatherChildren(File localAbsPath, boolean baseOnly, boolean workOnly) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        TreeSet<String> names = new TreeSet<String>();
        if (!workOnly) {
            SVNSqlJetStatement base_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_BASE_NODE_CHILDREN);
            base_stmt.bindf("is", wcId, localRelPath);
            this.addChildren(names, base_stmt);
        }
        if (!baseOnly) {
            SVNSqlJetStatement work_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE_CHILDREN);
            work_stmt.bindf("is", wcId, localRelPath);
            this.addChildren(names, work_stmt);
        }
        return names;
    }

    @Override
    public Map<String, ISVNWCDb.WCDbBaseInfo> getBaseChildrenMap(File localAbsPath, boolean fetchLocks) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        return this.getBaseChildrenMap(parsed.wcDbDir.getWCRoot(), parsed.localRelPath, fetchLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ISVNWCDb.WCDbBaseInfo> getBaseChildrenMap(SVNWCDbRoot wcRoot, File localRelPath, boolean fetchLocks) throws SVNException {
        long wcId = wcRoot.getWcId();
        SVNSqlJetDb sDb = wcRoot.getSDb();
        TreeMap<String, ISVNWCDb.WCDbBaseInfo> children = new TreeMap<String, ISVNWCDb.WCDbBaseInfo>();
        SVNSqlJetSelectStatement baseStmt = (SVNSqlJetSelectStatement)sDb.getStatement(SVNWCDbStatements.SELECT_BASE_CHILDREN_INFO);
        baseStmt.bindf("is", wcId, localRelPath);
        Map<String, Object> row = null;
        try {
            while (baseStmt.next()) {
                ISVNWCDb.WCDbBaseInfo child = new ISVNWCDb.WCDbBaseInfo();
                child.updateRoot = (row = baseStmt.getRowValues2(row)).get(SVNWCDbSchema.NODES__Fields.file_external.toString()) != null;
                child.status = SvnWcDbStatementUtil.parsePresence((String)row.get(SVNWCDbSchema.NODES__Fields.presence.toString()));
                child.revision = (Long)row.get(SVNWCDbSchema.NODES__Fields.revision.toString());
                String path = (String)row.get(SVNWCDbSchema.NODES__Fields.repos_path.toString());
                child.reposRelPath = path != null ? new File(path) : null;
                child.depth = SvnWcDbStatementUtil.parseDepth((String)row.get(SVNWCDbSchema.NODES__Fields.depth.toString()));
                child.kind = SvnWcDbStatementUtil.parseKind((String)row.get(SVNWCDbSchema.NODES__Fields.kind.toString()));
                if (fetchLocks) {
                    SVNSqlJetStatement lockStmt = fetchLocks ? sDb.getStatement(SVNWCDbStatements.SELECT_LOCK) : null;
                    try {
                        child.lock = null;
                        lockStmt.bindf("is", row.get(SVNWCDbSchema.NODES__Fields.repos_id.toString()), row.get(SVNWCDbSchema.NODES__Fields.repos_path.toString()));
                        if (lockStmt.next()) {
                            child.lock = SvnWcDbStatementUtil.getLockFromColumns(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token, SVNWCDbSchema.LOCK__Fields.lock_owner, SVNWCDbSchema.LOCK__Fields.lock_comment, SVNWCDbSchema.LOCK__Fields.lock_date);
                        }
                    }
                    finally {
                        lockStmt.reset();
                    }
                }
                String child_relpath = (String)row.get(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                children.put(SVNPathUtil.tail(child_relpath), child);
            }
        }
        finally {
            baseStmt.reset();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildren(Set<String> children, SVNSqlJetStatement stmt) throws SVNException {
        try {
            while (stmt.next()) {
                String child_relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                String name = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(child_relpath));
                children.add(name);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readConflictVictims(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        ArrayList<String> victims = new ArrayList<String>();
        HashSet<String> found = new HashSet<String>();
        SVNSqlJetStatement stmt = wcInfo.wcDbDir.getWCRoot().getFormat() == 29 ? sDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CONFLICT_VICTIMS_17) : sDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CONFLICT_VICTIMS);
        try {
            stmt.bindf("is", wcId, SVNFileUtil.getFilePath(localRelPath));
            while (stmt.next()) {
                String child_relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath);
                String child_name = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(child_relpath));
                found.add(child_name);
            }
        }
        finally {
            stmt.reset();
        }
        victims.addAll(found);
        return victims;
    }

    @Override
    public List<SVNConflictDescription> readConflicts(File localAbsPath) throws SVNException {
        List<SVNWCConflictDescription17> conflicts = this.readConflicts(localAbsPath, false);
        ArrayList<SVNConflictDescription> translated = new ArrayList<SVNConflictDescription>();
        for (SVNWCConflictDescription17 description : conflicts) {
            SVNMergeFileSet mergeFiles = new SVNMergeFileSet(null, null, description.getBaseFile(), description.getMyFile(), localAbsPath.getAbsolutePath(), description.getTheirFile(), description.getMergedFile(), null, description.getMimeType());
            if (description.getKind() == SVNWCConflictDescription17.ConflictKind.PROPERTY) {
                translated.add(new SVNPropertyConflictDescription(mergeFiles, description.getNodeKind(), description.getPropertyName(), description.getAction(), description.getReason()));
                continue;
            }
            if (description.getKind() == SVNWCConflictDescription17.ConflictKind.TREE) {
                translated.add(new SVNTreeConflictDescription(localAbsPath, description.getNodeKind(), description.getAction(), description.getReason(), description.getOperation(), description.getSrcLeftVersion(), description.getSrcRightVersion()));
                continue;
            }
            if (description.getKind() != SVNWCConflictDescription17.ConflictKind.TEXT) continue;
            translated.add(new SVNTextConflictDescription(mergeFiles, description.getNodeKind(), description.getAction(), description.getReason()));
        }
        return translated;
    }

    public List<SVNWCConflictDescription17> readConflicts(File localAbsPath, boolean createTempFiles) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        if (pdh.getWCRoot().getFormat() == 29) {
            return this.readConflicts17(pdh.getWCRoot(), parseDir.localRelPath, createTempFiles);
        }
        SVNSkel conflictSkel = SvnWcDbConflicts.readConflict(pdh.getWCRoot().getDb(), localAbsPath);
        return SvnWcDbConflicts.convertFromSkel(this, localAbsPath, createTempFiles, conflictSkel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SVNWCConflictDescription17> readConflicts17(SVNWCDbRoot wcRoot, File localRelPath, boolean createTempFiles) throws SVNException {
        File localAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath);
        ArrayList<SVNWCConflictDescription17> conflicts = new ArrayList<SVNWCConflictDescription17>();
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_CONFLICT_DETAILS);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            while (stmt.next()) {
                String conflictOld = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
                String conflictWorking = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                String conflictNew = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new);
                String propReject = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
                byte[] treeConflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                if (conflictOld != null || conflictWorking != null || conflictNew != null) {
                    File conflictNewAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), conflictNew);
                    File conflictOldAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), conflictOld);
                    File conflictWorkingAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), conflictWorking);
                    SVNWCConflictDescription17 conflictDescription = SVNWCConflictDescription17.createText(localAbsPath);
                    conflictDescription.setTheirFile(conflictNewAbsPath);
                    conflictDescription.setBaseFile(conflictOldAbsPath);
                    conflictDescription.setMyFile(conflictWorkingAbsPath);
                    conflicts.add(conflictDescription);
                }
                if (propReject != null) {
                    File propRejectAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), propReject);
                    SVNWCConflictDescription17 conflictDescription = SVNWCConflictDescription17.createProp(localAbsPath, SVNNodeKind.UNKNOWN, "");
                    conflictDescription.setTheirFile(propRejectAbsPath);
                    conflicts.add(conflictDescription);
                }
                if (treeConflictData == null) continue;
                SVNSkel tcSkel = SVNSkel.parse(treeConflictData);
                SVNTreeConflictDescription tcDesc = SVNTreeConflictUtil.readSingleTreeConflict(tcSkel, localAbsPath);
                SVNWCConflictDescription17 conflictDescription = SVNWCConflictDescription17.createTree(localAbsPath, tcDesc.getNodeKind(), tcDesc.getOperation(), tcDesc.getSourceLeftVersion(), tcDesc.getSourceRightVersion());
                conflictDescription.setAction(tcDesc.getConflictAction());
                conflictDescription.setReason(tcDesc.getConflictReason());
                if (tcDesc.getMergeFiles() != null) {
                    conflictDescription.setMyFile(tcDesc.getMergeFiles().getLocalFile());
                }
                conflicts.add(conflictDescription);
            }
            ArrayList<SVNWCConflictDescription17> arrayList = conflicts;
            return arrayList;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public SVNSkel readConflict(File localAbsPath) throws SVNException {
        DirParsedInfo pdh = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir wcDbDir = pdh.wcDbDir;
        SVNWCDb.verifyDirUsable(wcDbDir);
        File localRelPath = pdh.localRelPath;
        return this.readConflictInternal(wcDbDir.getWCRoot(), localRelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNSkel readConflictInternal(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        if (wcRoot.getFormat() == 29) {
            return this.readConflictInternal17(wcRoot, localRelPath);
        }
        SVNSqlJetStatement statement = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            SVNSkel sVNSkel;
            byte[] conflictData;
            statement.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = statement.next();
            if (!haveRow) {
                SVNSqlJetStatement selectNodeInfoStatement = null;
                try {
                    selectNodeInfoStatement = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                    selectNodeInfoStatement.bindf("is", wcRoot.getWcId(), localRelPath);
                    haveRow = selectNodeInfoStatement.next();
                    if (haveRow) {
                        SVNSkel sVNSkel2 = null;
                        return sVNSkel2;
                    }
                }
                catch (SVNException sVNException) {
                }
                finally {
                    if (selectNodeInfoStatement != null) {
                        selectNodeInfoStatement.reset();
                    }
                }
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localRelPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if ((conflictData = statement.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data)) != null) {
                sVNSkel = SVNSkel.parse(conflictData);
                return sVNSkel;
            }
            sVNSkel = null;
            return sVNSkel;
        }
        finally {
            statement.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNSkel readConflictInternal17(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            if (!stmt.next()) {
                SVNSkel sVNSkel = null;
                return sVNSkel;
            }
            String conflictOld = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
            String conflictWorking = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
            String conflictNew = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new);
            String propReject = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
            byte[] treeConflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
            SVNSkel sVNSkel = SvnWcDbConflicts.convertToConflictSkel(wcRoot.getAbsPath(), wcRoot.getDb(), SVNFileUtil.getFilePath(localRelPath), conflictOld, conflictWorking, conflictNew, propReject, treeConflictData);
            return sVNSkel;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public ISVNWCDb.WCDbInfo readInfo(File localAbsPath, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        ReposInfo reposInfo;
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        ISVNWCDb.WCDbInfo info = this.readInfo(wcInfo.wcDbDir.getWCRoot(), localRelPath, fields);
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbInfo.InfoField.class, (Enum[])fields);
        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposUuid)) {
            reposInfo = this.fetchReposInfo(sDb, info.reposId);
            if (reposInfo.reposRootUrl != null) {
                info.reposRootUrl = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRootUrl) ? SVNURL.parseURIEncoded(reposInfo.reposRootUrl) : null;
            }
            String string = info.reposUuid = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposUuid) ? reposInfo.reposUuid : null;
        }
        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalUuid)) {
            reposInfo = this.fetchReposInfo(sDb, info.originalReposId);
            if (reposInfo.reposRootUrl != null) {
                info.originalRootUrl = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRootUrl) ? SVNURL.parseURIEncoded(reposInfo.reposRootUrl) : null;
            }
            info.originalUuid = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalUuid) ? reposInfo.reposUuid : null;
        }
        return info;
    }

    @Override
    public Structure<StructureFields.NodeInfo> readInfo(File localAbsPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return this.readInfo(localAbsPath, false, fields);
    }

    @Override
    public Structure<StructureFields.NodeInfo> readInfo(File localAbsPath, boolean isAdditionMode, StructureFields.NodeInfo ... fields) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath, isAdditionMode);
        File localRelPath = wcInfo.localRelPath;
        SVNWCDbRoot wcRoot = wcInfo.wcDbDir.getWCRoot();
        return this.readInfo(wcRoot, localRelPath, fields);
    }

    private Structure<StructureFields.NodeInfo> readInfo(SVNWCDbRoot wcRoot, File localRelPath, StructureFields.NodeInfo ... fields) throws SVNException {
        Structure<StructureFields.NodeInfo> info;
        SVNSqlJetDb sDb = wcRoot.getSDb();
        if (fields != null) {
            boolean needsOriginalReposId;
            Object fieldsInfo = Structure.obtain(StructureFields.NodeInfo.class, fields);
            boolean needsReposId = (((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.reposRootUrl) || ((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.reposUuid)) && !((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.reposId);
            boolean bl = needsOriginalReposId = (((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.originalRootUrl) || ((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.originalUuid)) && !((Structure)fieldsInfo).hasField(StructureFields.NodeInfo.originalReposId);
            if (needsReposId || needsOriginalReposId) {
                int modifiedFieldsCount = fields.length + (needsReposId ? 1 : 0) + (needsOriginalReposId ? 1 : 0);
                StructureFields.NodeInfo[] modifiedFields = new StructureFields.NodeInfo[modifiedFieldsCount];
                System.arraycopy(fields, 0, modifiedFields, 0, fields.length);
                int index = fields.length;
                if (needsReposId) {
                    modifiedFields[index] = StructureFields.NodeInfo.reposId;
                    ++index;
                }
                if (needsOriginalReposId) {
                    modifiedFields[index] = StructureFields.NodeInfo.originalReposId;
                    ++index;
                }
                fields = modifiedFields;
            }
        }
        if ((info = SvnWcDbShared.readInfo(wcRoot, localRelPath, fields)).hasField(StructureFields.NodeInfo.reposRootUrl) || info.hasField(StructureFields.NodeInfo.reposUuid)) {
            Structure<StructureFields.RepositoryInfo> reposInfo = this.fetchRepositoryInfo(sDb, info.lng(StructureFields.NodeInfo.reposId));
            reposInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into(info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid});
            reposInfo.release();
        }
        if (info.hasField(StructureFields.NodeInfo.originalRootUrl) || info.hasField(StructureFields.NodeInfo.originalUuid)) {
            Structure<StructureFields.RepositoryInfo> reposInfo = this.fetchRepositoryInfo(sDb, info.lng(StructureFields.NodeInfo.originalReposId));
            reposInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into(info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.originalRootUrl, StructureFields.NodeInfo.originalUuid});
            reposInfo.release();
        }
        return info;
    }

    @Override
    public ISVNWCDb.SVNWCDbInfo readSingleInfo(File localAbsPath, boolean baseTreeOnly, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        DirParsedInfo pdh = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(pdh.wcDbDir);
        return this.readSingleInfo(pdh.wcDbDir.getWCRoot(), pdh.localRelPath, baseTreeOnly, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISVNWCDb.SVNWCDbInfo readSingleInfo(SVNWCDbRoot wcRoot, File localRelPath, boolean baseTreeOnly, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        boolean haveWork;
        long reposId;
        SvnChecksum checksum;
        Object originalReposRelPath = null;
        SVNProperties properties = null;
        ISVNWCDb.SVNWCDbInfo info = new ISVNWCDb.SVNWCDbInfo();
        if (!baseTreeOnly) {
            ISVNWCDb.WCDbInfo wcDbInfo = this.readInfo(wcRoot, localRelPath, fields);
            info.load(wcDbInfo);
            checksum = wcDbInfo.checksum;
            reposId = wcDbInfo.reposId;
            haveWork = wcDbInfo.haveWork;
        } else {
            haveWork = false;
            ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(wcRoot, localRelPath, ISVNWCDb.WCDbBaseInfo.fromInfoFields(fields));
            info.load(baseInfo);
            checksum = baseInfo.checksum;
            reposId = baseInfo.reposId;
            properties = baseInfo.props;
            info.haveBase = true;
            boolean bl = info.fileExternal = baseInfo.updateRoot && info.kind == ISVNWCDb.SVNWCDbKind.File;
        }
        if (haveWork && (info.haveBase || info.haveMoreWork)) {
            SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_MOVED_TO);
            try {
                stmt.bindf("is", wcRoot.getWcId(), localRelPath);
                while (stmt.next()) {
                    long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    File movedToRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    SVNWCContext.NodeMovedAway move = new SVNWCContext.NodeMovedAway();
                    move.movedToAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), movedToRelPath);
                    File curRelPath = SVNWCUtils.relpathPrefix(localRelPath, opDepth);
                    move.opRootAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), curRelPath);
                    move.next = info.movedTo;
                    info.movedTo = move;
                }
            }
            finally {
                stmt.reset();
            }
        }
        if (!baseTreeOnly && info.haveBase && (haveWork || info.kind == ISVNWCDb.SVNWCDbKind.File)) {
            boolean updateRoot;
            ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(wcRoot, localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot);
            if (haveWork) {
                info.lock = baseInfo.lock;
            }
            boolean bl = info.fileExternal = (updateRoot = baseInfo.updateRoot) && info.kind == ISVNWCDb.SVNWCDbKind.File;
        }
        if (info.status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo additionInfo = this.scanAddition(wcRoot, localRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
            info.movedHere = additionInfo.status == ISVNWCDb.SVNWCDbStatus.MovedHere;
            boolean bl = info.incomplete = additionInfo.status == ISVNWCDb.SVNWCDbStatus.Incomplete;
        }
        if (SVNFileUtil.symlinksSupported() && info.kind == ISVNWCDb.SVNWCDbKind.File && (info.hadProps || info.propsMod || baseTreeOnly && properties != null)) {
            if (!baseTreeOnly) {
                properties = info.propsMod ? this.readProperties(wcRoot, localRelPath) : SvnWcDbProperties.readPristineProperties(wcRoot, localRelPath);
            }
            info.special = properties != null && properties.getSVNPropertyValue("svn:special") != null;
        }
        info.hasChecksum = checksum != null;
        info.copied = originalReposRelPath != null;
        ReposInfo reposInfo = this.fetchReposInfo(wcRoot.getSDb(), reposId);
        info.reposRootUrl = reposInfo.reposRootUrl == null ? null : SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
        info.reposUuid = reposInfo.reposUuid;
        if (!baseTreeOnly && info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
            info.locked = this.isWCLocked(wcRoot, localRelPath);
        }
        info.hasDescendants = info.kind == ISVNWCDb.SVNWCDbKind.Dir ? true : this.findConflictDescendants(wcRoot, localRelPath);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findConflictDescendants(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.FIND_CONFLICT_DESCENDANT);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean bl = stmt.next();
            return bl;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readOpDepth(SVNWCDbRoot root, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = null;
        try {
            stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (stmt.next()) {
                long l = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                return l;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            catch (SVNException sVNException) {}
        }
        return 0L;
    }

    @Override
    public ISVNWCDb.WCDbInfo readInfoBelowWorking(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        return this.readInfoBelowWorking(wcInfo.wcDbDir.getWCRoot(), localRelPath, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbInfo readInfoBelowWorking(SVNWCDbRoot wcRoot, File localRelPath, int belowOpDepth) throws SVNException {
        ISVNWCDb.WCDbInfo info = new ISVNWCDb.WCDbInfo();
        SVNSqlJetStatement stmt = null;
        try {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (belowOpDepth >= 0) {
                while (haveRow && SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth) > (long)belowOpDepth) {
                    haveRow = stmt.next();
                }
            }
            if (haveRow) {
                haveRow = stmt.next();
                if (haveRow) {
                    info.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                }
                while (haveRow) {
                    if (SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth) > 0L) {
                        info.haveWork = true;
                    } else {
                        info.haveBase = true;
                    }
                    haveRow = stmt.next();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            catch (SVNException sVNException) {}
        }
        if (info.haveWork) {
            info.status = SVNWCDb.getWorkingStatus(info.status);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbInfo readInfo(SVNWCDbRoot wcRoot, File localRelPath, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        ISVNWCDb.WCDbInfo info;
        block64: {
            info = new ISVNWCDb.WCDbInfo();
            EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbInfo.InfoField.class, (Enum[])fields);
            SVNSqlJetStatement stmtInfo = null;
            SVNSqlJetStatement stmtActual = null;
            try {
                stmtInfo = wcRoot.getSDb().getStatement(f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lock) ? SVNWCDbStatements.SELECT_NODE_INFO_WITH_LOCK : SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcRoot.getWcId(), localRelPath);
                boolean haveInfo = stmtInfo.next();
                boolean haveActual = false;
                if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.propsMod)) {
                    stmtActual = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                    stmtActual.bindf("is", wcRoot.getWcId(), localRelPath);
                    haveActual = stmtActual.next();
                }
                if (haveInfo) {
                    File relativePath;
                    SVNSqlJetStatement stmtBaseLock;
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                    ISVNWCDb.SVNWCDbKind nodeKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.status)) {
                        info.status = SvnWcDbStatementUtil.getColumnPresence(stmtInfo);
                        if (opDepth != 0L) {
                            info.status = SVNWCDb.getWorkingStatus(info.status);
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.kind)) {
                        info.kind = nodeKind;
                    }
                    long l = info.reposId = opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.revision)) {
                        long l2 = info.revision = opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRelPath)) {
                        File file = info.reposRelPath = opDepth != 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedDate)) {
                        SVNDate sVNDate = info.changedDate = SvnWcDbStatementUtil.isColumnNull(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_date) ? null : SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedRev)) {
                        info.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedAuthor)) {
                        info.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_author);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lastModTime)) {
                        info.lastModTime = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.last_mod_time);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.depth)) {
                        info.depth = nodeKind != ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.UNKNOWN : SvnWcDbStatementUtil.getColumnDepth(stmtInfo, SVNWCDbSchema.NODES__Fields.depth);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.checksum)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.File) {
                            info.checksum = null;
                        } else {
                            try {
                                info.checksum = SvnWcDbStatementUtil.getColumnChecksum(stmtInfo, SVNWCDbSchema.NODES__Fields.checksum);
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcRoot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.translatedSize)) {
                        info.translatedSize = SvnWcDbStatementUtil.getTranslatedSize(stmtInfo, SVNWCDbSchema.NODES__Fields.translated_size);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.target)) {
                        info.target = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.symlink_target));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist) && haveActual) {
                        info.changelist = SvnWcDbStatementUtil.getColumnText(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    }
                    long l3 = info.originalReposId = opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        long l4 = info.originalRevision = opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalReposRelpath)) {
                        File file = info.originalReposRelpath = opDepth == 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.propsMod) && haveActual) {
                        boolean bl = info.propsMod = !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.hadProps)) {
                        byte[] props = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                        boolean bl = info.hadProps = props != null && props.length > 2;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted) && haveActual) {
                        boolean bl = info.conflicted = !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lock) && opDepth == 0L && !SvnWcDbStatementUtil.isColumnNull(stmtBaseLock = stmtInfo.getJoinedStatement(SVNWCDbSchema.LOCK.toString()), SVNWCDbSchema.LOCK__Fields.lock_token)) {
                        info.lock = new ISVNWCDb.SVNWCDbLock();
                        info.lock.token = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_token);
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                            info.lock.owner = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_owner);
                        }
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                            info.lock.comment = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_comment);
                        }
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                            info.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_date));
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveWork)) {
                        boolean bl = info.haveWork = opDepth != 0L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.opRoot)) {
                        boolean bl = info.opRoot = opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.movedHere)) {
                        info.movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmtInfo, SVNWCDbSchema.NODES__Fields.moved_here);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.movedTo) && (relativePath = SvnWcDbStatementUtil.getColumnPath(stmtInfo, SVNWCDbSchema.NODES__Fields.moved_to)) != null) {
                        info.movedToAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), relativePath);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveWork)) {
                        while (opDepth != 0L && (haveInfo = stmtInfo.next())) {
                            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                            if (!f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveMoreWork)) continue;
                            if (opDepth > 0L) {
                                info.haveMoreWork = true;
                            }
                            if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase)) continue;
                        }
                        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase)) {
                            info.haveBase = opDepth == 0L;
                        }
                    }
                    break block64;
                }
                if (haveActual) {
                    if (SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Corrupt data for ''{0}''", (Object)wcRoot.getAbsPath(localRelPath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    assert (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted));
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.status)) {
                        info.status = ISVNWCDb.SVNWCDbStatus.Normal;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.kind)) {
                        info.kind = ISVNWCDb.SVNWCDbKind.Unknown;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.revision)) {
                        info.revision = -1L;
                    }
                    info.reposId = -1L;
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedRev)) {
                        info.changedRev = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.depth)) {
                        info.depth = SVNDepth.UNKNOWN;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalReposId)) {
                        info.originalReposId = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        info.originalRevision = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist)) {
                        info.changelist = stmtActual.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        info.originalRevision = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted)) {
                        info.conflicted = true;
                    }
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcRoot.getAbsPath(localRelPath));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                try {
                    if (stmtInfo != null) {
                        stmtInfo.reset();
                    }
                }
                catch (SVNException sVNException) {}
                try {
                    if (stmtActual != null) {
                        stmtActual.reset();
                    }
                }
                catch (SVNException sVNException) {}
            }
        }
        return info;
    }

    public static ISVNWCDb.SVNWCDbStatus getWorkingStatus(ISVNWCDb.SVNWCDbStatus status) {
        if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            return status;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
            return ISVNWCDb.SVNWCDbStatus.Deleted;
        }
        return ISVNWCDb.SVNWCDbStatus.Added;
    }

    @Override
    public ISVNWCDb.SVNWCDbKind readKind(File localAbsPath, boolean allowMissing) throws SVNException {
        try {
            ISVNWCDb.WCDbInfo info = this.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.kind);
            return info.kind;
        }
        catch (SVNException e) {
            if (allowMissing && e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return ISVNWCDb.SVNWCDbKind.Unknown;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNNodeKind readKind(File localAbsPath, boolean allowMissing, boolean showDeleted, boolean showHidden) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        File localRelPath = parsed.localRelPath;
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveInfo = stmt.next();
            if (!haveInfo) {
                if (allowMissing) {
                    SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
                    return sVNNodeKind;
                }
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (!showDeleted || !showHidden) {
                int opDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                boolean reportNone = false;
                ISVNWCDb.SVNWCDbStatus status = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                if (opDepth > 0) {
                    status = this.convertToWorkingStatus(status);
                }
                switch (status) {
                    case NotPresent: {
                        if (showHidden && showDeleted) break;
                        reportNone = true;
                        break;
                    }
                    case Excluded: 
                    case ServerExcluded: {
                        if (showHidden) break;
                        reportNone = true;
                        break;
                    }
                    case Deleted: {
                        if (showDeleted) break;
                        reportNone = true;
                        break;
                    }
                }
                if (reportNone) {
                    SVNNodeKind sVNNodeKind = SVNNodeKind.NONE;
                    return sVNNodeKind;
                }
            }
            SVNNodeKind sVNNodeKind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind) == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
            return sVNNodeKind;
        }
        finally {
            stmt.reset();
        }
    }

    private ISVNWCDb.SVNWCDbStatus convertToWorkingStatus(ISVNWCDb.SVNWCDbStatus status) {
        ISVNWCDb.SVNWCDbStatus workStatus = status;
        assert (workStatus == ISVNWCDb.SVNWCDbStatus.Normal || workStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || workStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted || workStatus == ISVNWCDb.SVNWCDbStatus.Incomplete || workStatus == ISVNWCDb.SVNWCDbStatus.Excluded);
        if (workStatus == ISVNWCDb.SVNWCDbStatus.Excluded) {
            return ISVNWCDb.SVNWCDbStatus.Excluded;
        }
        if (workStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || workStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
            return ISVNWCDb.SVNWCDbStatus.Deleted;
        }
        return ISVNWCDb.SVNWCDbStatus.Added;
    }

    @Override
    public InputStream readPristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.readPristine(pdh.getWCRoot(), wcRootAbsPath, checksum);
    }

    @Override
    public SVNProperties readPristineProperties(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbProperties.readPristineProperties(pdh.getWCRoot(), localRelPath);
    }

    public void readPropertiesRecursively(File localAbsPath, SVNDepth depth, boolean baseProperties, boolean pristineProperties, Collection<String> changelists, ISvnObjectReceiver<SVNProperties> receiver) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbProperties.readPropertiesRecursively(pdh.getWCRoot(), localRelPath, depth, baseProperties, pristineProperties, changelists, receiver);
    }

    @Override
    public SVNProperties readProperties(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        return this.readProperties(wcRoot, localRelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties readProperties(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        try {
            SvnWcDbShared.begingReadTransaction(wcRoot);
            SVNProperties sVNProperties = SvnWcDbProperties.readProperties(wcRoot, localRelPath);
            return sVNProperties;
        }
        finally {
            SvnWcDbShared.commitTransaction(wcRoot);
        }
    }

    private SVNSqlJetStatement getStatementForPath(File localAbsPath, SVNWCDbStatements statementIndex) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(parsed.wcDbDir);
        SVNWCDbRoot wcRoot = parsed.wcDbDir.getWCRoot();
        SVNSqlJetStatement statement = wcRoot.getSDb().getStatement(statementIndex);
        statement.bindf("is", wcRoot.getWcId(), SVNFileUtil.getFilePath(parsed.localRelPath));
        return statement;
    }

    @Override
    public void removeBase(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        BaseRemove brb = new BaseRemove();
        brb.localRelpath = localRelpath;
        brb.wcId = pdh.getWCRoot().getWcId();
        brb.root = pdh.getWCRoot();
        pdh.getWCRoot().getSDb().runTransaction(brb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void removeBase(File localAbsPath, boolean keepAsWorking, boolean queueDeletes, boolean removeLocks, long notPresentRevision, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        BaseRemove brb = new BaseRemove();
        brb.localRelpath = localRelpath;
        brb.wcId = pdh.getWCRoot().getWcId();
        brb.root = pdh.getWCRoot();
        brb.keepAsWorking = keepAsWorking;
        brb.queueDeletes = queueDeletes;
        brb.removeLocks = removeLocks;
        brb.notPresentRevision = notPresentRevision;
        brb.conflict = conflict;
        brb.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(brb);
        pdh.flushEntries(localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMovedHere(File movedToRelPath, SVNWCDbRoot wcRoot) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.CLEAR_MOVED_HERE_RECURSIVE);
        try {
            stmt.bindf("isi", wcRoot.getWcId(), movedToRelPath, SVNWCUtils.relpathDepth(movedToRelPath));
            long affected = stmt.done();
            if (affected == 0L) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", new Object[]{movedToRelPath});
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        long reposId = SVNWCDb.scanUpwardsForRepos(reposInfo, pdh.getWCRoot(), localRelpath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_LOCK);
        try {
            stmt.bindf("is", reposId, reposInfo.relPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void removePristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.removePristine(pdh.getWCRoot(), checksum);
    }

    @Override
    public ISVNWCDb.WCDbAdditionInfo scanAddition(File localAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        return this.scanAddition(wcRoot, localRelpath, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISVNWCDb.WCDbAdditionInfo scanAddition(SVNWCDbRoot wcRoot, File localRelpath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField ... fields) throws SVNException {
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.class, (Enum[])fields);
        File buildRelpath = SVNFileUtil.createFilePath("");
        ISVNWCDb.WCDbAdditionInfo additionInfo = new ISVNWCDb.WCDbAdditionInfo();
        additionInfo.originalRevision = -1L;
        long originalReposId = -1L;
        additionInfo.movedFromRelPath = null;
        additionInfo.movedFromOpRootRelPath = null;
        additionInfo.movedFromOpDepth = 0;
        File currentRelpath = localRelpath;
        File reposPrefixPath = SVNFileUtil.createFilePath("");
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            ISVNWCDb.SVNWCDbStatus presence;
            SVNErrorMessage err;
            stmt.bindf("is", wcRoot.getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                stmt.reset();
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((presence = SvnWcDbStatementUtil.getColumnPresence(stmt)) != ISVNWCDb.SVNWCDbStatus.Normal) {
                stmt.reset();
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be added.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision)) {
                additionInfo.originalRevision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status)) {
                additionInfo.status = ISVNWCDb.SVNWCDbStatus.Added;
            }
            long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            int i = SVNWCUtils.relpathDepth(localRelpath);
            while ((long)i > opDepth) {
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                --i;
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.opRootAbsPath)) {
                additionInfo.opRootAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), currentRelpath);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposId) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision) && additionInfo.originalRevision == -1L || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromOpRootRelPath)) {
                if (!localRelpath.equals(currentRelpath)) {
                    stmt.reset();
                    stmt.bindf("is", wcRoot.getWcId(), currentRelpath);
                    haveRow = stmt.next();
                    if (!haveRow) {
                        stmt.reset();
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), currentRelpath));
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision) && additionInfo.originalRevision == -1L) {
                        additionInfo.originalRevision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                    }
                }
                if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath)) {
                    additionInfo.originalReposRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path);
                }
                if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id) && (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposId) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromOpRootRelPath))) {
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposId)) {
                        originalReposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                        ReposInfo reposInfo = this.fetchReposInfo(wcRoot.getSDb(), originalReposId);
                        additionInfo.originalRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                        additionInfo.originalUuid = reposInfo.reposUuid;
                        additionInfo.originalReposId = originalReposId;
                    }
                    boolean movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here);
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status)) {
                        additionInfo.status = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here) ? ISVNWCDb.SVNWCDbStatus.MovedHere : ISVNWCDb.SVNWCDbStatus.Copied;
                    }
                    if (movedHere && (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.movedFromOpRootRelPath))) {
                        Structure<StructureFields.MovedFromInfo> movedFromInfo = SvnWcDbShared.getMovedFromInfo(wcRoot, currentRelpath, localRelpath);
                        additionInfo.movedFromOpRootRelPath = currentRelpath = (File)movedFromInfo.get(StructureFields.MovedFromInfo.movedFromOpRootRelPath);
                        additionInfo.movedFromRelPath = (File)movedFromInfo.get(StructureFields.MovedFromInfo.movedFromRelPath);
                        additionInfo.movedFromOpDepth = (int)movedFromInfo.lng(StructureFields.MovedFromInfo.opDepth);
                    }
                }
            }
            block4: while (true) {
                stmt.reset();
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                stmt.bindf("is", wcRoot.getWcId(), currentRelpath);
                haveRow = stmt.next();
                if (!haveRow) {
                    break;
                }
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                i = SVNWCUtils.relpathDepth(currentRelpath);
                while (true) {
                    if ((long)i <= opDepth) continue block4;
                    reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                    currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                    --i;
                }
                break;
            }
        }
        finally {
            stmt.reset();
        }
        buildRelpath = reposPrefixPath;
        if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposId)) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(wcRoot, currentRelpath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath)) {
                additionInfo.reposRelPath = SVNFileUtil.createFilePath(baseInfo.reposRelPath, buildRelpath);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposId)) {
                additionInfo.reposId = baseInfo.reposId;
            }
        }
        if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid)) {
            originalReposId = additionInfo.originalReposId;
        }
        if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid)) {
            ISVNWCDb.WCDbRepositoryInfo rInfo = new ISVNWCDb.WCDbRepositoryInfo();
            long reposId = SVNWCDb.scanUpwardsForRepos(rInfo, wcRoot, currentRelpath);
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath)) {
                additionInfo.reposRelPath = SVNFileUtil.createFilePath(rInfo.relPath, buildRelpath);
            }
            if (reposId != -1L && f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid)) {
                ReposInfo reposInfo = this.fetchReposInfo(wcRoot.getSDb(), reposId);
                if (reposInfo.reposRootUrl != null) {
                    additionInfo.reposRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                }
                additionInfo.reposUuid = reposInfo.reposUuid;
            }
        }
        if (originalReposId != -1L && f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid)) {
            ReposInfo reposInfo = this.fetchReposInfo(wcRoot.getSDb(), originalReposId);
            if (reposInfo.reposRootUrl != null) {
                additionInfo.originalRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
            }
            additionInfo.originalUuid = reposInfo.reposUuid;
        }
        return additionInfo;
    }

    @Override
    public ISVNWCDb.WCDbRepositoryInfo scanBaseRepository(File localAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.class, (Enum[])fields);
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        reposInfo.relPath = baseInfo.reposRelPath;
        if (f.contains((Object)ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl) || f.contains((Object)ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid)) {
            SVNWCDb.fetchReposInfo(reposInfo, pdh.getWCRoot().getSDb(), baseInfo.reposId);
        }
        return reposInfo;
    }

    @Override
    public ISVNWCDb.WCDbRepositoryInfo readRepositoryInfo(File localAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.class, (Enum[])fields);
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        ISVNWCDb.WCDbRepositoryInfo repositoryInfo = this.readRepositoryInfo(pdh.getWCRoot(), parsed.localRelPath);
        SVNWCDb.fetchReposInfo(repositoryInfo, pdh.getWCRoot().getSDb(), repositoryInfo.reposId);
        return repositoryInfo;
    }

    private ISVNWCDb.WCDbRepositoryInfo readRepositoryInfo(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        ISVNWCDb.WCDbRepositoryInfo repositoryInfo = new ISVNWCDb.WCDbRepositoryInfo();
        ISVNWCDb.WCDbInfo info = wcRoot.getDb().readInfo(wcRoot, localRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.reposId);
        repositoryInfo.revision = info.revision;
        repositoryInfo.relPath = info.reposRelPath;
        repositoryInfo.reposId = info.reposId;
        if (repositoryInfo.relPath == null) {
            if (info.status == ISVNWCDb.SVNWCDbStatus.Added) {
                ISVNWCDb.WCDbAdditionInfo additionInfo = this.scanAddition(wcRoot, localRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposId);
                repositoryInfo.relPath = additionInfo.reposRelPath;
                repositoryInfo.reposId = additionInfo.reposId;
            } else if (info.status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                ISVNWCDb.WCDbDeletionInfo deletionInfo = this.scanDeletion(wcRoot, localRelPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath);
                if (deletionInfo.workDelAbsPath != null) {
                    File workRelAbsPath = SVNFileUtil.getFileDir(deletionInfo.workDelAbsPath);
                    ISVNWCDb.WCDbAdditionInfo additionInfo = this.scanAddition(workRelAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposId);
                    repositoryInfo.relPath = additionInfo.reposRelPath == null ? null : SVNFileUtil.createFilePath(additionInfo.reposRelPath, SVNFileUtil.skipAncestor(workRelAbsPath, SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath)));
                    repositoryInfo.reposId = additionInfo.reposId;
                } else {
                    ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(deletionInfo.baseDelAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
                    repositoryInfo.revision = baseInfo.revision;
                    repositoryInfo.relPath = baseInfo.reposRelPath;
                    repositoryInfo.reposId = baseInfo.reposId;
                    repositoryInfo.relPath = baseInfo.reposRelPath == null ? null : SVNFileUtil.createFilePath(baseInfo.reposRelPath, SVNFileUtil.skipAncestor(deletionInfo.baseDelAbsPath, SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath)));
                }
            } else if (info.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                File parentRelPath = SVNFileUtil.getFileDir(localRelPath);
                String name = SVNFileUtil.getFileName(localRelPath);
                ISVNWCDb.WCDbAdditionInfo additionInfo = this.scanAddition(wcRoot, parentRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposId);
                repositoryInfo.relPath = SVNFileUtil.createFilePath(additionInfo.reposRelPath, name);
                repositoryInfo.reposId = additionInfo.reposId;
            } else {
                SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
            }
        }
        return repositoryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long scanUpwardsForRepos(ISVNWCDb.WCDbRepositoryInfo reposInfo, SVNWCDbRoot wcroot, File localRelPath) throws SVNException {
        assert (wcroot.getSDb() != null && wcroot.getWcId() != -1L);
        assert (reposInfo != null);
        SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
        try {
            stmt.bindf("is", wcroot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
                long l = 0L;
                return l;
            }
            assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_id));
            assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_path));
            reposInfo.relPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
            long l = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchReposInfo(ISVNWCDb.WCDbRepositoryInfo reposInfo, SVNSqlJetDb sdb, long reposId) throws SVNException {
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", reposId);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)reposId);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            reposInfo.rootUrl = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REPOSITORY__Fields.root) ? SVNURL.parseURIEncoded(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root)) : null;
            reposInfo.uuid = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid);
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public ISVNWCDb.WCDbDeletionInfo scanDeletion(File localAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        return this.scanDeletion(wcRoot, localRelPath, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISVNWCDb.WCDbDeletionInfo scanDeletion(SVNWCDbRoot wcRoot, File localRelPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField ... fields) throws SVNException {
        File currentRelPath = localRelPath;
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.class, (Enum[])fields);
        ISVNWCDb.WCDbDeletionInfo deletionInfo = new ISVNWCDb.WCDbDeletionInfo();
        boolean scan = f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToOpRootAbsPath) || f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToAbsPath);
        SVNWCDbSelectDeletionInfo stmt = (SVNWCDbSelectDeletionInfo)wcRoot.getSDb().getStatement(scan ? SVNWCDbStatements.SELECT_DELETION_INFO_SCAN : SVNWCDbStatements.SELECT_DELETION_INFO);
        try {
            boolean haveBase;
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            ISVNWCDb.SVNWCDbStatus workPresence = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
            boolean bl = haveBase = !stmt.getInternalStatement().isColumnNull(SVNWCDbSchema.NODES__Fields.presence);
            if (workPresence != ISVNWCDb.SVNWCDbStatus.NotPresent && workPresence != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be deleted.", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            if (workPresence == ISVNWCDb.SVNWCDbStatus.NotPresent && f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) {
                deletionInfo.workDelAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), currentRelPath);
                if (!scan && !f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) {
                    ISVNWCDb.WCDbDeletionInfo wCDbDeletionInfo = deletionInfo;
                    return wCDbDeletionInfo;
                }
            }
            while (true) {
                int currentDepth = SVNWCUtils.relpathDepth(currentRelPath);
                while (true) {
                    if (scan) {
                        MovedTo movedTo = this.getMovedTo(scan, stmt, currentRelPath, wcRoot, localRelPath);
                        scan = movedTo.scan;
                        deletionInfo.movedToAbsPath = movedTo.movedToRelPath == null ? null : SVNFileUtil.createFilePath(wcRoot.getAbsPath(), movedTo.movedToRelPath);
                        File file = deletionInfo.movedToOpRootAbsPath = movedTo.movedToOpRootRelPath == null ? null : SVNFileUtil.createFilePath(wcRoot.getAbsPath(), movedTo.movedToOpRootRelPath);
                        if (!(scan || f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath) || f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath))) {
                            ISVNWCDb.WCDbDeletionInfo wCDbDeletionInfo = deletionInfo;
                            return wCDbDeletionInfo;
                        }
                    }
                    if ((long)currentDepth <= opDepth) break;
                    currentRelPath = SVNFileUtil.getFileDir(currentRelPath);
                    if (!scan && (long)(--currentDepth) != opDepth) continue;
                    stmt.reset();
                    stmt.bindf("is", wcRoot.getWcId(), currentRelPath);
                    haveRow = stmt.next();
                    assert (haveRow);
                    haveBase = !stmt.getInternalStatement().isColumnNull(SVNWCDbSchema.NODES__Fields.presence);
                }
                stmt.reset();
                assert (SVNFileUtil.getFilePath(currentRelPath).length() != 0);
                File parentRelPath = SVNFileUtil.getFileDir(currentRelPath);
                stmt.bindf("is", wcRoot.getWcId(), parentRelPath);
                haveRow = stmt.next();
                if (!haveRow) {
                    if (haveBase && f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) {
                        deletionInfo.baseDelAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), currentRelPath);
                    }
                    break;
                }
                if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath) && deletionInfo.workDelAbsPath == null) {
                    deletionInfo.workDelAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), currentRelPath);
                    if (!scan && !f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) {
                        break;
                    }
                }
                currentRelPath = parentRelPath;
                opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                haveBase = !stmt.getInternalStatement().isColumnNull(SVNWCDbSchema.NODES__Fields.presence);
            }
        }
        finally {
            stmt.reset();
        }
        return deletionInfo;
    }

    public MovedTo getMovedTo(boolean scan, SVNWCDbSelectDeletionInfo stmt, File currentRelPath, SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        MovedTo movedTo = new MovedTo();
        movedTo.scan = scan;
        File movedToRelPath = SvnWcDbStatementUtil.getColumnPath(stmt.getJoinedStatement(SVNWCDbSchema.NODES), SVNWCDbSchema.NODES__Fields.moved_to);
        if (movedToRelPath != null) {
            File movedToOpRootRelPath = movedToRelPath;
            if (!localRelPath.equals(currentRelPath)) {
                File movedChildRelPath = SVNFileUtil.skipAncestor(currentRelPath, localRelPath);
                assert (movedChildRelPath != null && SVNFileUtil.getFilePath(movedChildRelPath).length() > 0);
                movedToRelPath = SVNFileUtil.createFilePath(movedToOpRootRelPath, movedChildRelPath);
            }
            if (movedToOpRootRelPath != null) {
                movedTo.movedToOpRootRelPath = movedToOpRootRelPath;
            }
            if (movedToRelPath != null) {
                movedTo.movedToRelPath = movedToRelPath;
            }
            movedTo.scan = false;
        }
        return movedTo;
    }

    public SVNWCDbDir navigateToParent(SVNWCDbDir childPdh, SVNSqlJetDb.Mode sMode) throws SVNException {
        SVNWCDbDir parentPdh = childPdh.getParent();
        if (parentPdh != null && parentPdh.getWCRoot() != null) {
            return parentPdh;
        }
        File parentAbsPath = SVNFileUtil.getParentFile(childPdh.getLocalAbsPath());
        assert (parentAbsPath != null);
        parentPdh = this.parseDir((File)parentAbsPath, (SVNSqlJetDb.Mode)sMode).wcDbDir;
        SVNWCDb.verifyDirUsable(parentPdh);
        childPdh.setParent(parentPdh);
        return parentPdh;
    }

    @Override
    public void setBaseDavCache(File localAbsPath, SVNProperties props) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbShared.begingWriteTransaction(pdh.getWCRoot());
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_BASE_NODE_DAV_CACHE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), parsed.localRelPath);
            stmt.bindProperties(3, props);
            stmt.exec();
        }
        catch (SVNException e) {
            SvnWcDbShared.rollbackTransaction(pdh.getWCRoot());
            throw e;
        }
        finally {
            stmt.reset();
            SvnWcDbShared.commitTransaction(pdh.getWCRoot());
        }
    }

    @Override
    public File toRelPath(File wriAbsPath, File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(wriAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        File rootAbsPath = parsed.wcDbDir.getWCRoot().getAbsPath();
        return SVNPathUtil.isAncestor(rootAbsPath.getPath(), localAbsPath.getPath()) ? SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(rootAbsPath.getPath(), localAbsPath.getPath())) : localAbsPath;
    }

    @Override
    public File toRelPath(File localAbsPath) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        return parsed.localRelPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileExternalTemp(File path) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(path, SVNWCDbStatements.SELECT_FILE_EXTERNAL);
        try {
            boolean have_row = stmt.next();
            if (!have_row) {
                String string = null;
                return string;
            }
            String string = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.file_external);
            return string;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void cleanupPristine(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.cleanupPristine(pdh.getWCRoot(), localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fetchWCId(SVNSqlJetDb sDb) throws SVNException {
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WCROOT_NULL);
        try {
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Missing a row in WCROOT.");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long l = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WCROOT__Fields.id);
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReposInfo fetchReposInfo(SVNSqlJetDb sDb, long repos_id) throws SVNException {
        ReposInfo info = new ReposInfo();
        if (repos_id == -1L) {
            return info;
        }
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", repos_id);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)repos_id);
                SVNErrorManager.error(err, SVNLogType.WC);
                ReposInfo reposInfo = info;
                return reposInfo;
            }
            info.reposRootUrl = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root);
            info.reposUuid = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid);
        }
        finally {
            stmt.reset();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure<StructureFields.RepositoryInfo> fetchRepositoryInfo(SVNSqlJetDb sDb, long repos_id) throws SVNException {
        Object info = Structure.obtain(StructureFields.RepositoryInfo.class);
        if (repos_id == -1L) {
            return info;
        }
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", repos_id);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)repos_id);
                SVNErrorManager.error(err, SVNLogType.WC);
                Object x = info;
                return x;
            }
            ((Structure)info).set((StructureFields.RepositoryInfo)StructureFields.RepositoryInfo.reposRootUrl, SVNURL.parseURIEncoded(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root)));
            ((Structure)info).set((StructureFields.RepositoryInfo)StructureFields.RepositoryInfo.reposUuid, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid));
        }
        finally {
            stmt.reset();
        }
        return info;
    }

    private static SVNSqlJetDb openDb(File dirAbsPath, String sdbFileName, SVNSqlJetDb.Mode sMode, SqlJetPagerJournalMode journalMode, boolean temporaryDbInMemory) throws SVNException {
        if (dirAbsPath == null || sdbFileName == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return SVNSqlJetDb.open(SVNWCUtils.admChild(dirAbsPath, sdbFileName), sMode, journalMode, temporaryDbInMemory);
    }

    protected static void verifyDirUsable(SVNWCDbDir pdh) throws SVNException {
        if (!SVNWCDbDir.isUsable(pdh)) {
            if (pdh != null && pdh.getWCRoot() != null && pdh.getWCRoot().getFormat() < 29) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            assert (false);
        }
    }

    @Override
    public SVNSqlJetDb borrowDbTemp(File localDirAbsPath, ISVNWCDb.SVNWCDbOpenMode mode) throws SVNException {
        assert (SVNWCDb.isAbsolute(localDirAbsPath));
        SVNSqlJetDb.Mode smode = mode == ISVNWCDb.SVNWCDbOpenMode.ReadOnly ? SVNSqlJetDb.Mode.ReadOnly : SVNSqlJetDb.Mode.ReadWrite;
        DirParsedInfo parsed = this.parseDir(localDirAbsPath, smode);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return pdh.getWCRoot().getSDb();
    }

    @Override
    public boolean isWCRoot(File localAbspath) throws SVNException {
        return this.isWCRoot(localAbspath, false);
    }

    @Override
    public boolean isWCRoot(File localAbspath, boolean isAdditionMode) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite, false, isAdditionMode);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return localRelPath == null || localRelPath.getPath().equals("");
    }

    @Override
    public void opStartDirectoryUpdateTemp(File localAbspath, File newReposRelpath, long newRevision) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(newRevision));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        StartDirectoryUpdate du = new StartDirectoryUpdate();
        du.wcId = pdh.getWCRoot().getWcId();
        du.newRevision = newRevision;
        du.newReposRelpath = newReposRelpath;
        du.localRelpath = localRelPath;
        pdh.getWCRoot().getSDb().runTransaction(du);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opMakeCopyTemp(File localAbspath, boolean removeBase) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean haveRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Modification of ''{0}'' already exists", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.catchCopyOfAbsent(pdh, localRelPath);
        MakeCopy mcb = new MakeCopy();
        mcb.pdh = pdh;
        mcb.localRelpath = localRelPath;
        mcb.localAbspath = localAbspath;
        mcb.opDepth = SVNWCUtils.relpathDepth(localRelPath);
        pdh.getWCRoot().getSDb().runTransaction(mcb);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catchCopyOfAbsent(SVNWCDbDir pdh, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.HAS_SERVER_EXCLUDED_NODES);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            if (stmt.next()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.AUTHZ_UNREADABLE, "Cannot copy ''{0}'', excluded by server", (Object)SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catchCopyOfServerExcluded(SVNWCDbRoot wcRoot, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.HAS_SERVER_EXCLUDED_DESCENDANTS);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                File serverExcludedRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.AUTHZ_UNREADABLE, "Cannot copy ''{0}'' excluded by server", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), serverExcludedRelpath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gatherRepoChildren(SVNWCDbRoot root, File localRelpath, long opDepth) throws SVNException {
        ArrayList<String> children = new ArrayList<String>();
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_OP_DEPTH_CHILDREN);
        try {
            stmt.bindf("isi", root.getWcId(), localRelpath, opDepth);
            boolean haveRow = stmt.next();
            while (haveRow) {
                String childRelpath = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath)));
                children.add(childRelpath);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetchReposId(SVNSqlJetDb db, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement getStmt = db.getStatement(SVNWCDbStatements.SELECT_REPOSITORY);
        try {
            getStmt.bindf("s", reposRootUrl);
            getStmt.nextRow();
            long l = getStmt.getColumnLong(SVNWCDbSchema.REPOSITORY__Fields.id);
            return l;
        }
        finally {
            getStmt.reset();
        }
    }

    @Override
    public void opSetNewDirToIncompleteTemp(File localAbspath, File reposRelpath, SVNURL reposRootURL, String reposUuid, long revision, SVNDepth depth, boolean insertBaseDeleted, boolean deleteWorking, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (reposRelpath != null && reposRootURL != null && reposUuid != null);
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase insertBase = new InsertBase();
        insertBase.reposRootURL = reposRootURL;
        insertBase.reposUUID = reposUuid;
        insertBase.status = ISVNWCDb.SVNWCDbStatus.Incomplete;
        insertBase.kind = ISVNWCDb.SVNWCDbKind.Dir;
        insertBase.reposRelpath = reposRelpath;
        insertBase.revision = revision;
        insertBase.depth = depth;
        insertBase.localRelpath = parsed.localRelPath;
        insertBase.wcId = pdh.getWCRoot().getWcId();
        insertBase.wcRoot = pdh.getWCRoot();
        insertBase.insertBaseDeleted = insertBaseDeleted;
        insertBase.deleteWorking = deleteWorking;
        insertBase.conflict = conflict;
        insertBase.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(insertBase);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void opBumpRevisionPostUpdate(File localAbsPath, SVNDepth depth, File newReposRelPath, SVNURL newReposRootURL, String newReposUUID, long newRevision, Collection<File> excludedPaths, Map<File, Map<String, SVNProperties>> inheritableProperties, ISVNEventHandler eventHandler) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = parseDir.localRelPath;
        if (excludedPaths != null && excludedPaths.contains(localRelPath)) {
            return;
        }
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        BumpRevisionPostUpdate brb = new BumpRevisionPostUpdate();
        brb.depth = depth;
        brb.newReposRelPath = newReposRelPath;
        brb.newReposRootURL = newReposRootURL;
        brb.newReposUUID = newReposUUID;
        brb.newRevision = newRevision;
        brb.localRelPath = localRelPath;
        brb.wcRoot = pdh.getWCRoot().getAbsPath();
        brb.exludedRelPaths = excludedPaths;
        brb.dbWcRoot = pdh.getWCRoot();
        brb.iprops = inheritableProperties;
        brb.eventHandler = eventHandler;
        pdh.getWCRoot().getSDb().runTransaction(brb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public File getWCRootTempDir(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveWorkingTemp(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetBaseIncompleteTemp(File localDirAbspath, boolean incomplete) throws SVNException {
        SVNWCDbDir pdh;
        long affectedNodeRows;
        ISVNWCDb.SVNWCDbStatus baseStatus = this.getBaseInfo((File)localDirAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.status}).status;
        assert (baseStatus == ISVNWCDb.SVNWCDbStatus.Normal || baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete);
        SVNSqlJetStatement stmt = this.getStatementForPath(localDirAbspath, SVNWCDbStatements.UPDATE_NODE_BASE_PRESENCE);
        try {
            stmt.bindString(3, incomplete ? "incomplete" : "normal");
            affectedNodeRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        long affectedRows = affectedNodeRows;
        if (affectedRows > 0L && (pdh = this.getOrCreateDir(localDirAbspath, false)) != null) {
            pdh.flushEntries(localDirAbspath);
        }
    }

    private SVNWCDbDir getOrCreateDir(File localDirAbspath, boolean createAllowed) {
        SVNWCDbDir pdh = this.dirData.get(localDirAbspath.getAbsolutePath());
        if (pdh == null && createAllowed) {
            pdh = new SVNWCDbDir(localDirAbspath);
            this.dirData.put(localDirAbspath.getAbsolutePath(), pdh);
        }
        return pdh;
    }

    @Override
    public void opSetDirDepthTemp(File localAbspath, SVNDepth depth) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (depth.getId() >= SVNDepth.EMPTY.getId() && depth.getId() <= SVNDepth.INFINITY.getId());
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        this.updateDepthValues(localAbspath, pdh, localRelpath, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDepthValues(File localAbspath, SVNWCDbDir pdh, File localRelpath, SVNDepth depth) throws SVNException {
        long affectedRows;
        pdh.flushEntries(localAbspath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_NODE_BASE_DEPTH);
        try {
            stmt.bindf("iss", pdh.getWCRoot().getWcId(), localRelpath, SVNDepth.asString(depth));
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' os not a committed directory", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveEntryTemp(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SVNSqlJetDb sdb = pdh.getWCRoot().getSDb();
        long wcId = pdh.getWCRoot().getWcId();
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.DELETE_NODES);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_WITHOUT_CONFLICT);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void opSetRevAndReposRelpathTemp(File localAbspath, long revision, boolean setReposRelpath, File reposRelpath, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(revision) || setReposRelpath);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SetRevRelpath baton = new SetRevRelpath();
        baton.pdh = pdh;
        baton.localRelpath = parseDir.localRelPath;
        baton.rev = revision;
        baton.setReposRelpath = setReposRelpath;
        baton.reposRelpath = reposRelpath;
        baton.reposRootUrl = reposRootUrl;
        baton.reposUuid = reposUuid;
        pdh.flushEntries(localAbspath);
        pdh.getWCRoot().getSDb().runTransaction(baton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opSetRevAndReposRelpath(SVNWCDbRoot wcRoot, File localRelpath, Map<String, SVNProperties> nodeIprops, long revision, boolean setReposRelpath, final File reposRelpath, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement stmt = null;
        if (SVNRevision.isValidRevisionNumber(revision)) {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_BASE_REVISION);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelpath, revision);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        if (setReposRelpath) {
            final long reposId = this.createReposId(wcRoot.getSDb(), reposRootUrl, reposUuid);
            stmt = new SVNSqlJetUpdateStatement(wcRoot.getSDb(), SVNWCDbSchema.NODES){

                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    HashMap<String, Object> values2 = new HashMap<String, Object>();
                    values2.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), reposId);
                    values2.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), SVNFileUtil.getFilePath(reposRelpath));
                    return values2;
                }
            };
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelpath, 0);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        try {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_IPROPS);
            stmt.bindf("isb", wcRoot.getWcId(), localRelpath, nodeIprops != null ? SVNSkel.createInheritedProperties(nodeIprops).unparse() : null);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void obtainWCLock(File localAbspath, int levelsToLock, boolean stealLock) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (levelsToLock >= -1);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        WCLockObtain baton = new WCLockObtain();
        baton.pdh = pdh;
        baton.localRelpath = localRelpath;
        if (!stealLock) {
            SVNWCDbRoot wcroot = pdh.getWCRoot();
            int depth = SVNWCUtils.relpathDepth(localRelpath);
            for (SVNWCDbRoot.WCLock lock : wcroot.getOwnedLocks()) {
                if (!SVNWCUtils.isAncestor(lock.localRelpath, localRelpath) || lock.levels != -1 && lock.levels + SVNWCUtils.relpathDepth(lock.localRelpath) < depth) continue;
                File lockAbspath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), lock.localRelpath);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked via ''{1}''", localAbspath, lockAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ISVNWCDb.WCDbWorkQueueInfo wq = this.fetchWorkQueue(pdh.getWCRoot().getAbsPath());
            if (wq.workItem != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "There are unfinished work items in ''{0}''; run ''svn cleanup'' first.", (Object)pdh.getWCRoot().getAbsPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        baton.stealLock = stealLock;
        baton.levelsToLock = levelsToLock;
        pdh.getWCRoot().getSDb().runTransaction(baton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stealWCLock(SVNWCDbRoot wcroot, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK);
        try {
            stmt.bindf("is", wcroot.getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWCLock(File localAbspath) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot.WCLock foundLock = null;
        List<SVNWCDbRoot.WCLock> ownedLocks = pdh.getWCRoot().getOwnedLocks();
        for (SVNWCDbRoot.WCLock lock : ownedLocks) {
            if (!lock.localRelpath.equals(localRelpath)) continue;
            foundLock = lock;
            break;
        }
        if (foundLock == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy not locked at ''{0}''", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ownedLocks.remove(foundLock);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File getWCRoot(File wcRootAbspath) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(wcRootAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        if (pdh.getWCRoot() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "The node ''{0}'' is not in the working copy", (Object)wcRootAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return pdh.getWCRoot().getAbsPath();
    }

    @Override
    public void forgetDirectoryTemp(File localDirAbspath) throws SVNException {
        HashSet<SVNWCDbRoot> roots2 = new HashSet<SVNWCDbRoot>();
        Iterator<Map.Entry<String, SVNWCDbDir>> i = this.dirData.entrySet().iterator();
        while (i.hasNext()) {
            SVNWCDbDir pdh;
            block3: {
                Map.Entry<String, SVNWCDbDir> entry = i.next();
                pdh = entry.getValue();
                if (!SVNWCUtils.isAncestor(localDirAbspath, pdh.getLocalAbsPath())) continue;
                try {
                    this.releaseWCLock(pdh.getLocalAbsPath());
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) break block3;
                    throw e;
                }
            }
            i.remove();
            if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null || !SVNWCUtils.isAncestor(localDirAbspath, pdh.getWCRoot().getAbsPath())) continue;
            roots2.add(pdh.getWCRoot());
        }
        this.closeManyWCRoots(roots2);
    }

    @Override
    public boolean isWCLockOwns(File localAbspath, boolean exact) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        if (pdh.getWCRoot() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "The node ''{0}'' was not found.", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCDb.verifyDirUsable(pdh);
        boolean ownLock = false;
        List<SVNWCDbRoot.WCLock> ownedLocks = pdh.getWCRoot().getOwnedLocks();
        int lockLevel = SVNWCUtils.relpathDepth(localRelpath);
        if (exact) {
            for (SVNWCDbRoot.WCLock lock : ownedLocks) {
                if (!lock.localRelpath.equals(localRelpath)) continue;
                ownLock = true;
                return ownLock;
            }
        } else {
            for (SVNWCDbRoot.WCLock lock : ownedLocks) {
                if (!SVNWCUtils.isAncestor(lock.localRelpath, localRelpath) || lock.levels != -1 && SVNWCUtils.relpathDepth(lock.localRelpath) + lock.levels < lockLevel) continue;
                ownLock = true;
                return ownLock;
            }
        }
        return ownLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetTextConflictMarkerFilesTemp(File localAbspath, File oldBasename, File newBasename, File wrkBasename) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean gotRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            gotRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        try {
            if (gotRow) {
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_TEXT_CONFLICTS);
            } else {
                if (oldBasename == null && newBasename == null && wrkBasename == null) {
                    return;
                }
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_TEXT_CONFLICTS);
                stmt.bindString(6, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
            }
            stmt.bindf("issss", pdh.getWCRoot().getWcId(), localRelpath, oldBasename, newBasename, wrkBasename);
            stmt.done();
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    @Override
    public void addBaseNotPresentNode(File localAbspath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        this.addExcludedOrNotPresentNode(localAbspath, reposRelPath, reposRootUrl, reposUuid, revision, kind, ISVNWCDb.SVNWCDbStatus.NotPresent, conflict, workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetPropertyConflictMarkerFileTemp(File localAbspath, String prejBasename) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean gotRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            gotRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        try {
            if (gotRow) {
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_PROPERTY_CONFLICTS);
            } else {
                if (prejBasename == null) {
                    return;
                }
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_PROPERTY_CONFLICTS);
                if (localRelpath != null && !"".equals(SVNFileUtil.getFilePath(localRelpath))) {
                    stmt.bindString(4, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
                } else {
                    stmt.bindNull(4);
                }
            }
            stmt.bindf("iss", pdh.getWCRoot().getWcId(), localRelpath, prejBasename);
            stmt.done();
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    private void addExcludedOrNotPresentNode(File localAbspath, File reposRelpath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, ISVNWCDb.SVNWCDbStatus status, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (reposRelpath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent);
        DirParsedInfo parseDir = this.parseDir(SVNFileUtil.getParentFile(localAbspath), SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = SVNFileUtil.createFilePath(parseDir.localRelPath, SVNFileUtil.getFileName(localAbspath));
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.status = status;
        ibb.kind = kind;
        ibb.reposRelpath = reposRelpath;
        ibb.revision = revision;
        ibb.children = null;
        ibb.depth = SVNDepth.UNKNOWN;
        ibb.checksum = null;
        ibb.target = null;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.wcRoot = pdh.getWCRoot();
        ibb.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void globalCommit(File localAbspath, long newRevision, long changedRevision, SVNDate changedDate, String changedAuthor, SvnChecksum newChecksum, List<File> newChildren, SVNProperties newDavCache, boolean keepChangelist, boolean noUnlock, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(newRevision));
        assert (newChecksum == null || newChildren == null);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        Commit cb = new Commit();
        cb.pdh = pdh;
        cb.localRelpath = localRelpath;
        cb.newRevision = newRevision;
        cb.changedRev = changedRevision;
        cb.changedDate = changedDate;
        cb.changedAuthor = changedAuthor;
        cb.newChecksum = newChecksum;
        cb.newChildren = newChildren;
        cb.newDavCache = newDavCache;
        cb.keepChangelist = keepChangelist;
        cb.noUnlock = noUnlock;
        cb.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(cb);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReposInfo2 determineReposInfo(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        ReposInfo2 info = new ReposInfo2();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_id));
                assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_path));
                info.reposId = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
                info.reposRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
                ReposInfo2 reposInfo2 = info;
                return reposInfo2;
            }
        }
        finally {
            stmt.reset();
        }
        File localParentRelpath = SVNFileUtil.getFileDir(localRelpath);
        String name = SVNFileUtil.getFileName(localRelpath);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        info.reposId = SVNWCDb.scanUpwardsForRepos(reposInfo, pdh.getWCRoot(), localParentRelpath);
        File reposParentRelpath = reposInfo.relPath;
        info.reposRelPath = SVNFileUtil.createFilePath(reposParentRelpath, name);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Structure<StructureFields.PristineInfo> readPristineInfo(File localAbspath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbspath);
        SVNWCDbDir dir = wcInfo.wcDbDir;
        SVNSqlJetStatement stmt = dir.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        File relativePath = wcInfo.localRelPath;
        Object result = Structure.obtain(StructureFields.PristineInfo.class);
        try {
            SVNProperties props;
            stmt.bindf("is", dir.getWCRoot().getWcId(), relativePath);
            if (!stmt.next()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbspath), SVNLogType.WC);
            }
            long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            ISVNWCDb.SVNWCDbStatus status = SvnWcDbStatementUtil.getColumnPresence(stmt);
            if (opDepth > 0L && status == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                boolean hasNext = stmt.next();
                assert (hasNext);
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                status = SvnWcDbStatementUtil.getColumnPresence(stmt);
            }
            ISVNWCDb.SVNWCDbKind kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.kind, (Object)kind);
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_date, SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date)));
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_author, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author));
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_rev, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_revision));
            if (opDepth > 0L) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.status, (Object)SVNWCDb.getWorkingStatus(status));
            } else {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.status, (Object)status);
            }
            if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.UNKNOWN);
            } else {
                String depthStr = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                if (depthStr == null) {
                    ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.UNKNOWN);
                } else {
                    ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.fromString(depthStr));
                }
            }
            if (kind == ISVNWCDb.SVNWCDbKind.File) {
                SvnChecksum checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.checksum, checksum);
            } else if (kind == ISVNWCDb.SVNWCDbKind.Symlink) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.target, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
            }
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.hadProps, SvnWcDbStatementUtil.hasColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties));
            if (status == ISVNWCDb.SVNWCDbStatus.Normal || status == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                if (props == null) {
                    props = new SVNProperties();
                }
            } else {
                assert (stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.properties));
                props = null;
            }
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.props, props);
        }
        finally {
            stmt.reset();
        }
        return result;
    }

    public DirParsedInfo obtainWcRoot(File localAbspath) throws SVNException {
        return this.obtainWcRoot(localAbspath, false);
    }

    public DirParsedInfo obtainWcRoot(File localAbspath, boolean isAdditionMode) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadOnly, false, isAdditionMode);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return parseDir;
    }

    @Override
    public void registerExternal(File definingAbsPath, File localAbsPath, SVNNodeKind kind, SVNURL reposRootUrl, String reposUuid, File reposRelPath, long operationalRevision, long revision) throws SVNException {
        SvnWcDbExternals.addExternalDir(this, localAbsPath, definingAbsPath, reposRootUrl, reposUuid, definingAbsPath, reposRelPath, operationalRevision, revision, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveNode(File localAbspath, long notPresentRevision, ISVNWCDb.SVNWCDbKind notPresentKind) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.getWCRoot().getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            long reposId = -1L;
            File reposRelPath = null;
            if (notPresentRevision >= 0L) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(pdh.getWCRoot(), localRelpath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
                reposId = baseInfo.reposId;
                reposRelPath = baseInfo.reposRelPath;
            }
            SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_NODES_RECURSIVE);
            try {
                stmt.bindf("isi", pdh.getWCRoot().getWcId(), localRelpath, 0);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
            try {
                stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (notPresentRevision >= 0L) {
                InsertBase ib = new InsertBase();
                ib.reposId = reposId;
                ib.reposRelpath = reposRelPath;
                ib.status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                ib.kind = notPresentKind;
                ib.revision = notPresentRevision;
                ib.localRelpath = localRelpath;
                ib.wcId = pdh.getWCRoot().getWcId();
                ib.wcRoot = pdh.getWCRoot();
                pdh.getWCRoot().getSDb().runTransaction(ib);
            }
        }
        catch (SVNException e) {
            pdh.getWCRoot().getSDb().rollback();
            throw e;
        }
        finally {
            pdh.getWCRoot().getSDb().commit();
        }
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void upgradeBegin(File localAbspath, ISVNWCDb.SVNWCDbUpgradeData upgradeData, SVNURL repositoryRootUrl, String repositoryUUID, int targetWorkingCopyFormat) throws SVNException {
        CreateDbInfo dbInfo = this.createDb(localAbspath, repositoryRootUrl, repositoryUUID, "wc.db", targetWorkingCopyFormat, true);
        upgradeData.repositoryId = dbInfo.reposId;
        upgradeData.workingCopyId = dbInfo.wcId;
        SVNWCDbDir pdh = new SVNWCDbDir(localAbspath);
        SVNWCDbRoot root = new SVNWCDbRoot(this, localAbspath, dbInfo.sDb, dbInfo.wcId, -1, true, false, false);
        pdh.setWCRoot(root);
        upgradeData.root = root;
        this.dirData.put(upgradeData.rootAbsPath.getAbsolutePath(), pdh);
    }

    @Override
    public ISVNWCDb.SVNWCDbNodeCheckReplaceData nodeCheckReplace(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo pdh = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(pdh.wcDbDir);
        if (pdh.localRelPath == null || pdh.localRelPath.getPath() == null || pdh.localRelPath.getPath().length() == 0) {
            return ISVNWCDb.SVNWCDbNodeCheckReplaceData.NO_REPLACE;
        }
        CheckReplace checkReplace = new CheckReplace(pdh.wcDbDir.getWCRoot().getWcId(), pdh.localRelPath);
        checkReplace.replace = false;
        checkReplace.replaceRoot = false;
        checkReplace.baseReplace = false;
        pdh.wcDbDir.getWCRoot().getSDb().runTransaction(checkReplace, SqlJetTransactionMode.READ_ONLY);
        return new ISVNWCDb.SVNWCDbNodeCheckReplaceData(checkReplace.replaceRoot, checkReplace.replace, checkReplace.baseReplace);
    }

    @Override
    public ISVNWCDb.SVNWCDbBaseMovedToData baseMovedTo(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        BaseMovedTo bmt = new BaseMovedTo();
        bmt.wcRoot = pdh.getWCRoot();
        bmt.localRelPath = parsed.localRelPath;
        bmt.opDepth = 0L;
        pdh.getWCRoot().getSDb().runTransaction(bmt);
        ISVNWCDb.SVNWCDbBaseMovedToData baseMovedToData = new ISVNWCDb.SVNWCDbBaseMovedToData();
        if (bmt.moveDstRelPath != null) {
            baseMovedToData.moveDstAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), bmt.moveDstRelPath);
        }
        if (bmt.moveDstOpRootRelPath != null) {
            baseMovedToData.moveDstOpRootAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), bmt.moveDstOpRootRelPath);
        }
        if (bmt.moveSrcRootRelPath != null) {
            baseMovedToData.moveSrcRootAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), bmt.moveSrcRootRelPath);
        }
        if (bmt.moveSrcOpRootRelPath != null) {
            baseMovedToData.moveSrcOpRootAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), bmt.moveSrcOpRootRelPath);
        }
        return baseMovedToData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNWCDb.NodeInstallInfo readNodeInstallInfo(File localAbsPath, File wriAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        if (wriAbsPath == null) {
            wriAbsPath = localAbsPath;
        }
        DirParsedInfo parsed = this.parseDir(wriAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(parsed.wcDbDir);
        ISVNWCDb.NodeInstallInfo nodeInstallInfo = new ISVNWCDb.NodeInstallInfo();
        File localRelPath = parsed.localRelPath;
        SVNWCDbRoot wcRoot = parsed.wcDbDir.getWCRoot();
        File wcRootAbsPath = wcRoot.getAbsPath();
        if (!localAbsPath.equals(wriAbsPath)) {
            if (!SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(wcRootAbsPath), SVNFileUtil.getFilePath(localAbsPath))) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' is not in working copy ''{1}''", localAbsPath, wcRootAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            localRelPath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(SVNFileUtil.getFilePath(wcRootAbsPath), SVNFileUtil.getFilePath(localAbsPath)));
        }
        nodeInstallInfo.wcRoot = wcRoot;
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                nodeInstallInfo.checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                nodeInstallInfo.properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                nodeInstallInfo.changedDate = SvnWcDbStatementUtil.getColumnDate(stmt, SVNWCDbSchema.NODES__Fields.changed_date);
            } else {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node '{0}' is not installable", (Object)localAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
        finally {
            stmt.reset();
        }
        return nodeInstallInfo;
    }

    @Override
    public void resolveBreakMovedAway(File localAbsPath, File srcOpRootAbsPath, boolean markTreeConflictResolved, ISVNEventHandler eventHandler) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        File delRelPath = srcOpRootAbsPath != null ? SVNFileUtil.skipAncestor(pdh.getWCRoot().getAbsPath(), srcOpRootAbsPath) : null;
        ResolveBreakMovedAway resolveBreakMovedAway = new ResolveBreakMovedAway();
        resolveBreakMovedAway.wcRoot = parsed.wcDbDir.getWCRoot();
        resolveBreakMovedAway.localRelPath = localRelPath;
        resolveBreakMovedAway.eventHandler = eventHandler;
        resolveBreakMovedAway.delRelPath = delRelPath;
        resolveBreakMovedAway.markTreeConflictResolved = markTreeConflictResolved;
        pdh.getWCRoot().getSDb().runTransaction(resolveBreakMovedAway);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findSrcOpDepth(SVNWCDbRoot wcRoot, File srcRelPath, long deleteOpDepth) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HIGHEST_WORKING_NODE);
        try {
            stmt.bindf("isi", wcRoot.getWcId(), srcRelPath, deleteOpDepth);
            boolean haveRow = stmt.next();
            if (haveRow) {
                long l = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                return l;
            }
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is not deleted", new Object[]{srcRelPath});
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
            long l = -1L;
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseMovedTo opDepthMovedTo(long opDepth, SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        boolean haveRow;
        BaseMovedTo movedTo = new BaseMovedTo();
        File relPath = localRelPath;
        long deleteOpDepth = 0L;
        do {
            SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), relPath, opDepth);
                haveRow = stmt.next();
                if (haveRow) {
                    deleteOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    movedTo.moveDstOpRootRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    if (movedTo.moveDstOpRootRelPath != null) {
                        movedTo.moveSrcRootRelPath = relPath;
                    }
                }
            }
            finally {
                stmt.reset();
            }
            if (movedTo.moveDstOpRootRelPath != null) continue;
            relPath = SVNFileUtil.getFileDir(relPath);
        } while (movedTo.moveDstOpRootRelPath == null && haveRow && deleteOpDepth <= (long)SVNWCUtils.relpathDepth(relPath));
        if (movedTo.moveDstOpRootRelPath != null) {
            movedTo.moveDstRelPath = SVNFileUtil.createFilePath(movedTo.moveDstOpRootRelPath, SVNPathUtil.getRelativePath(SVNFileUtil.getFilePath(relPath), SVNFileUtil.getFilePath(localRelPath)));
            while (deleteOpDepth < (long)SVNWCUtils.relpathDepth(relPath)) {
                relPath = SVNFileUtil.getFileDir(relPath);
            }
            movedTo.moveSrcOpRootRelPath = relPath;
        }
        return movedTo;
    }

    @Override
    public void resolveDeleteRaiseMovedAway(File localAbsPath, ISVNEventHandler eventHandler) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        TcInfo tcInfo = this.getTcInfo(localAbsPath);
        SVNTreeConflictDescription treeConflictDescription = tcInfo.treeConflictDescription;
        SVNOperation operation = treeConflictDescription.getOperation();
        SVNConflictReason reason = treeConflictDescription.getConflictReason();
        SVNConflictAction action = treeConflictDescription.getConflictAction();
        SVNConflictVersion oldVersion = treeConflictDescription.getSourceLeftVersion();
        SVNConflictVersion newVersion = treeConflictDescription.getSourceRightVersion();
        ResolveDeleteRaiseMovedAway resolveDeleteRaiseMovedAway = new ResolveDeleteRaiseMovedAway();
        resolveDeleteRaiseMovedAway.pdh = pdh;
        resolveDeleteRaiseMovedAway.localRelPath = localRelPath;
        resolveDeleteRaiseMovedAway.operation = operation;
        resolveDeleteRaiseMovedAway.action = action;
        resolveDeleteRaiseMovedAway.oldVersion = oldVersion;
        resolveDeleteRaiseMovedAway.newVersion = newVersion;
        pdh.getWCRoot().getSDb().runTransaction(resolveDeleteRaiseMovedAway);
        this.updateMoveListNotify(pdh.getWCRoot(), oldVersion.getPegRevision(), newVersion != null ? newVersion.getPegRevision() : -1L, eventHandler);
    }

    private void markTreeConflict(File localRelPath, SVNWCDbRoot wcRoot, SVNConflictVersion oldVersion, SVNConflictVersion newVersion, File moveRootDstRelPath, SVNOperation operation, SVNNodeKind oldKind, SVNNodeKind newKind, File oldReposRelPath, SVNConflictReason reason, SVNConflictAction action, File moveSrcOpRootRelPath) throws SVNException {
        SVNSkel conflict;
        File newReposRelPath;
        File moveSrcOpRootAbsPath = moveSrcOpRootRelPath != null ? SVNFileUtil.createFilePath(wcRoot.getAbsPath(), moveSrcOpRootRelPath) : null;
        File oldReposRelPathPart = oldReposRelPath != null ? SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(oldVersion.getPath(), SVNFileUtil.getFilePath(oldReposRelPath))) : null;
        File file = newReposRelPath = oldReposRelPathPart != null ? SVNFileUtil.createFilePath(newVersion.getPath(), SVNFileUtil.getFilePath(oldReposRelPathPart)) : null;
        if (newReposRelPath == null) {
            newReposRelPath = SVNFileUtil.createFilePath(newVersion.getPath(), SVNPathUtil.getRelativePath(SVNFileUtil.getFilePath(moveRootDstRelPath), SVNFileUtil.getFilePath(localRelPath)));
        }
        try {
            conflict = this.readConflictInternal(wcRoot, localRelPath);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            conflict = null;
        }
        if (conflict != null) {
            Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflict);
            SVNOperation conflictOperation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
            boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
            if (conflictOperation != SVNOperation.UPDATE && conflictOperation != SVNOperation.SWITCH) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict", (Object)localRelPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (treeConflicted) {
                Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this, wcRoot.getAbsPath(), conflict);
                SVNConflictReason existingReason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
                SVNConflictAction existingAction = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
                File existingAbsPath = (File)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.moveSrcOpRootAbsPath);
                if (reason != existingReason || action != existingAction || reason == SVNConflictReason.MOVED_AWAY && !moveSrcOpRootAbsPath.equals(SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(SVNFileUtil.getFilePath(wcRoot.getAbsPath()), SVNFileUtil.getFilePath(existingAbsPath))))) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict");
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                return;
            }
        } else {
            conflict = SvnWcDbConflicts.createConflictSkel();
        }
        SvnWcDbConflicts.addTreeConflict(conflict, this, SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath), reason, action, moveSrcOpRootAbsPath);
        SVNConflictVersion conflictOldVersion = reason != SVNConflictReason.UNVERSIONED ? new SVNConflictVersion(oldVersion.getRepositoryRoot(), SVNFileUtil.getFilePath(oldReposRelPath), oldVersion.getPegRevision(), oldKind) : null;
        SVNConflictVersion conflictNewVersion = new SVNConflictVersion(newVersion.getRepositoryRoot(), SVNFileUtil.getFilePath(newReposRelPath), newVersion.getPegRevision(), newKind);
        if (operation == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflict, conflictOldVersion, conflictNewVersion);
        } else {
            assert (operation == SVNOperation.SWITCH);
            SvnWcDbConflicts.conflictSkelOpSwitch(conflict, conflictOldVersion, conflictNewVersion);
        }
        this.markConflictInternal(wcRoot, localRelPath, conflict);
        SVNWCDb.updateMoveListAdd(wcRoot, localRelPath, SVNEventAction.TREE_CONFLICT, newKind, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMoveListNotify(SVNWCDbRoot wcRoot, long oldRevision, long newRevision, ISVNEventHandler eventHandler) throws SVNException {
        SVNSqlJetStatement stmt;
        if (eventHandler != null) {
            stmt = wcRoot.getSDb().getTemporaryDb().getStatement(SVNWCDbStatements.SELECT_UPDATE_MOVE_LIST);
            try {
                boolean haveRow = stmt.next();
                while (haveRow) {
                    File localRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.UPDATE_MOVE_LIST__Fields.local_relpath));
                    SVNEventAction eventAction = SvnWcDbStatementUtil.getColumnEventAction(stmt, SVNWCDbSchema.UPDATE_MOVE_LIST__Fields.action);
                    SVNNodeKind kind = SvnWcDbStatementUtil.getColumnNodeKind(stmt, SVNWCDbSchema.UPDATE_MOVE_LIST__Fields.kind);
                    SVNStatusType contentStatus = SvnWcDbStatementUtil.getColumnStatusType(stmt, SVNWCDbSchema.UPDATE_MOVE_LIST__Fields.content_state);
                    SVNStatusType propStatus = SvnWcDbStatementUtil.getColumnStatusType(stmt, SVNWCDbSchema.UPDATE_MOVE_LIST__Fields.prop_state);
                    SVNEvent event = SVNEventFactory.createSVNEvent(SVNFileUtil.createFilePath(wcRoot.getAbsPath(), SVNFileUtil.getFilePath(localRelPath)), kind, null, newRevision, contentStatus, propStatus, SVNStatusType.UNKNOWN, eventAction, eventAction, null, null);
                    event.setPreviousRevision(oldRevision);
                    eventHandler.handleEvent(event, -1.0);
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
        }
        if (wcRoot.getSDb().getTemporaryDb().hasTable(SVNWCDbSchema.UPDATE_MOVE_LIST.name())) {
            stmt = new SVNWCDbCreateSchema(wcRoot.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.FINALIZE_UPDATE_MOVE, -1, false);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private TcInfo getTcInfo(File srcAbsPath) throws SVNException {
        SVNSkel conflictSkel = this.readConflict(srcAbsPath);
        if (conflictSkel == null) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' is not in conflict", (Object)srcAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
        List locations = (List)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.locations);
        SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
        if (operation != SVNOperation.UPDATE && operation != SVNOperation.SWITCH || !treeConflicted) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' is not a tree-conflict victim", (Object)srcAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        SVNConflictVersion oldVersion = null;
        SVNConflictVersion newVersion = null;
        if (locations != null) {
            assert (locations.size() >= 2);
            oldVersion = (SVNConflictVersion)locations.get(0);
            newVersion = (SVNConflictVersion)locations.get(1);
        }
        Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this, srcAbsPath, conflictSkel);
        SVNConflictReason localChange = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
        SVNConflictAction incomingChange = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
        TcInfo tcInfo = new TcInfo();
        tcInfo.moveSrcOpRootAbsPath = (File)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.moveSrcOpRootAbsPath);
        tcInfo.treeConflictDescription = new SVNTreeConflictDescription(srcAbsPath, SVNNodeKind.UNKNOWN, incomingChange, localChange, operation, oldVersion, newVersion);
        return tcInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMoveListAdd(SVNWCDbRoot wcRoot, File localRelPath, SVNEventAction eventAction, SVNNodeKind kind, SVNStatusType contentState, SVNStatusType propState) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getTemporaryDb().getStatement(SVNWCDbStatements.INSERT_UPDATE_MOVE_LIST);
        try {
            stmt.bindf("siiii", localRelPath, eventAction.getID(), kind.getID(), contentState.getID(), propState.getID());
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void updateMovedAwayConflictVictim(File victimAbsPath, ISVNEventHandler eventHandler) throws SVNException {
        TcInfo tcInfo = this.getTcInfo(victimAbsPath);
        SVNTreeConflictDescription conflictDescription = tcInfo.treeConflictDescription;
        File moveSrcOpRootAbsPath = tcInfo.moveSrcOpRootAbsPath;
        if (moveSrcOpRootAbsPath != null) {
            SVNWCContext.writeCheck(this, moveSrcOpRootAbsPath);
            DirParsedInfo parsed = this.parseDir(victimAbsPath, SVNSqlJetDb.Mode.ReadOnly);
            SVNWCDbDir pdh = parsed.wcDbDir;
            File localRelPath = parsed.localRelPath;
            SVNWCDb.verifyDirUsable(pdh);
            File moveSrcOpRootRelPath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(SVNFileUtil.getFilePath(pdh.getWCRoot().getAbsPath()), SVNFileUtil.getFilePath(moveSrcOpRootAbsPath)));
            UpdateMovedAwayConflictVictim updateMovedAwayConflictVictim = new UpdateMovedAwayConflictVictim();
            updateMovedAwayConflictVictim.wcRoot = pdh.getWCRoot();
            updateMovedAwayConflictVictim.victimRelPath = localRelPath;
            updateMovedAwayConflictVictim.localChange = conflictDescription.getConflictReason();
            updateMovedAwayConflictVictim.incomingChange = conflictDescription.getConflictAction();
            updateMovedAwayConflictVictim.moveSrcOpRootRelPath = moveSrcOpRootRelPath;
            updateMovedAwayConflictVictim.oldVersion = conflictDescription.getSourceLeftVersion();
            updateMovedAwayConflictVictim.newVersion = conflictDescription.getSourceRightVersion();
            updateMovedAwayConflictVictim.operation = conflictDescription.getOperation();
            pdh.getWCRoot().getSDb().runTransaction(updateMovedAwayConflictVictim);
            this.updateMoveListNotify(pdh.getWCRoot(), conflictDescription.getSourceLeftVersion().getPegRevision(), conflictDescription.getSourceRightVersion().getPegRevision(), eventHandler);
            if (eventHandler != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelPath), SVNNodeKind.NONE, null, conflictDescription.getSourceRightVersion().getPegRevision(), SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.UPDATE_COMPLETED, SVNEventAction.UPDATE_COMPLETED, null, null);
                eventHandler.handleEvent(event, -1.0);
            }
        }
    }

    private void driveTreeConflictEditor(SVNTreeConflictEditor treeConflictEditor, File srcRelPath, File dstRelPath, int srcOpDepth, SVNOperation operation, SVNConflictReason localChange, SVNConflictAction incomingChange, SVNConflictVersion oldVersion, SVNConflictVersion newVersion, SVNWCDbRoot wcRoot) throws SVNException {
        if (operation == SVNOperation.UPDATE && operation == SVNOperation.SWITCH) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Cannot auto-resolve tree-conflict on '{0}'", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), srcRelPath));
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        this.updateMovedAwayNode(treeConflictEditor, srcRelPath, dstRelPath, srcOpDepth, dstRelPath, oldVersion.getPegRevision(), wcRoot);
        this.replaceMovedLayer(wcRoot, srcRelPath, dstRelPath, srcOpDepth);
        treeConflictEditor.complete();
    }

    private void updateMovedAwayNode(SVNTreeConflictEditor treeConflictEditor, File srcRelPath, File dstRelPath, int srcOpDepth, File moveRootDstRelPath, long moveRootDstRevision, SVNWCDbRoot wcRoot) throws SVNException {
        int dstOpDepth = SVNWCUtils.relpathDepth(moveRootDstRelPath);
        UpdateMovedAwayNodeInfo srcInfo = this.getInfo(wcRoot, srcRelPath, srcOpDepth);
        SVNProperties srcProps = srcInfo.props;
        SvnChecksum srcChecksum = srcInfo.checksum;
        List<String> srcChildren = srcInfo.children;
        SVNNodeKind srcKind = srcInfo.kind;
        UpdateMovedAwayNodeInfo dstInfo = this.getInfo(wcRoot, dstRelPath, dstOpDepth);
        SVNProperties dstProps = dstInfo.props;
        SvnChecksum dstChecksum = dstInfo.checksum;
        List<String> dstChildren = dstInfo.children;
        SVNNodeKind dstKind = dstInfo.kind;
        if (srcKind == SVNNodeKind.NONE || dstKind != SVNNodeKind.NONE && srcKind != dstKind) {
            treeConflictEditor.delete(SVNFileUtil.getFilePath(dstRelPath), moveRootDstRevision);
        }
        if (srcKind != SVNNodeKind.NONE && srcKind != dstKind) {
            if (srcKind == SVNNodeKind.FILE) {
                InputStream inputStream2 = SvnWcDbPristines.readPristine(wcRoot, wcRoot.getAbsPath(), srcChecksum);
                treeConflictEditor.addFile(SVNFileUtil.getFilePath(dstRelPath), srcChecksum, inputStream2, srcProps, moveRootDstRevision);
            } else if (srcKind == SVNNodeKind.DIR) {
                treeConflictEditor.addDir(SVNFileUtil.getFilePath(dstRelPath), srcChildren, srcProps, moveRootDstRevision);
            }
        } else if (srcKind != SVNNodeKind.NONE) {
            SVNProperties props;
            boolean match = this.propsMatch(srcProps, dstProps);
            SVNProperties sVNProperties = props = match ? null : srcProps;
            if (srcKind == SVNNodeKind.FILE) {
                if (SvnChecksum.match(srcChecksum, dstChecksum)) {
                    srcChecksum = null;
                }
                InputStream inputStream3 = srcChecksum != null ? SvnWcDbPristines.readPristine(wcRoot, wcRoot.getAbsPath(), srcChecksum) : null;
                if (props != null || srcChecksum != null) {
                    treeConflictEditor.alterFile(SVNFileUtil.getFilePath(dstRelPath), moveRootDstRevision, props, srcChecksum, inputStream3);
                }
            } else if (srcKind == SVNNodeKind.DIR) {
                List<String> children;
                List<String> list = children = this.childrenMatch(srcChildren, dstChildren) ? null : srcChildren;
                if (props != null || children != null) {
                    treeConflictEditor.alterDir(SVNFileUtil.getFilePath(dstRelPath), moveRootDstRevision, children, props);
                }
            }
        }
        if (srcKind == SVNNodeKind.DIR) {
            int j = 0;
            int i = 0;
            while (i < srcChildren.size() || j < dstChildren.size()) {
                String childName;
                boolean srcOnly = false;
                boolean dstOnly = false;
                if (i >= srcChildren.size()) {
                    dstOnly = true;
                    childName = dstChildren.get(j);
                } else if (j >= dstChildren.size()) {
                    srcOnly = true;
                    childName = srcChildren.get(i);
                } else {
                    String dstName;
                    String srcName = srcChildren.get(i);
                    int cmp = srcName.compareTo(dstName = dstChildren.get(j));
                    if (cmp > 0) {
                        dstOnly = true;
                    } else if (cmp < 0) {
                        srcOnly = true;
                    }
                    childName = dstOnly ? dstName : srcName;
                }
                File srcChildRelPath = SVNFileUtil.createFilePath(srcRelPath, childName);
                File dstChildRelPath = SVNFileUtil.createFilePath(dstRelPath, childName);
                this.updateMovedAwayNode(treeConflictEditor, srcChildRelPath, dstChildRelPath, srcOpDepth, moveRootDstRelPath, moveRootDstRevision, wcRoot);
                if (!dstOnly) {
                    ++i;
                }
                if (srcOnly) continue;
                ++j;
            }
        }
    }

    private boolean propsMatch(SVNProperties srcProps, SVNProperties dstProps) {
        if (srcProps == null && dstProps == null) {
            return true;
        }
        if (srcProps != null || dstProps != null) {
            return false;
        }
        SVNProperties diff = dstProps.compareTo(srcProps);
        return diff == null || diff.size() <= 0;
    }

    private boolean childrenMatch(List<String> srcChildren, List<String> dstChildren) {
        if (srcChildren.size() != dstChildren.size()) {
            return false;
        }
        for (int i = 0; i < srcChildren.size(); ++i) {
            String dstChild;
            String srcChild = srcChildren.get(i);
            if (srcChild.equals(dstChild = dstChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceMovedLayer(SVNWCDbRoot wcRoot, File srcRelPath, File dstRelPath, int srcOpDepth) throws SVNException {
        int dstOpDepth = SVNWCUtils.relpathDepth(dstRelPath);
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_LOCAL_RELPATH_OP_DEPTH);
        try {
            stmt.bindf("isi", wcRoot.getWcId(), srcRelPath, srcOpDepth);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File srcCpRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                File dstCpRelPath = SVNFileUtil.createFilePath(dstRelPath, SVNFileUtil.skipAncestor(srcRelPath, srcCpRelPath));
                SVNSqlJetStatement stmt2 = wcRoot.getSDb().getStatement(SVNWCDbStatements.COPY_MOVE_NODE);
                try {
                    stmt2.bindf("isisis", wcRoot.getWcId(), srcCpRelPath, srcOpDepth, dstCpRelPath, dstOpDepth, SVNFileUtil.getFileDir(dstCpRelPath));
                    stmt2.done();
                }
                finally {
                    stmt2.reset();
                }
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
    }

    private UpdateMovedAwayNodeInfo getInfo(SVNWCDbRoot wcRoot, File localRelPath, int opDepth) throws SVNException {
        UpdateMovedAwayNodeInfo updateMovedAwayNodeInfo = new UpdateMovedAwayNodeInfo();
        try {
            Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(wcRoot, localRelPath, opDepth, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.propsMod);
            updateMovedAwayNodeInfo.kind = depthInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
            updateMovedAwayNodeInfo.checksum = (SvnChecksum)depthInfo.get(StructureFields.NodeInfo.checksum);
            updateMovedAwayNodeInfo.props = (SVNProperties)depthInfo.get(StructureFields.NodeInfo.propsMod);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                updateMovedAwayNodeInfo.kind = SVNNodeKind.NONE;
            }
            throw e;
        }
        Set<String> children = wcRoot.getDb().getChildrenOpDepth(wcRoot, localRelPath, opDepth).keySet();
        updateMovedAwayNodeInfo.children = new ArrayList<String>(children);
        Collections.sort(updateMovedAwayNodeInfo.children);
        return updateMovedAwayNodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suitableForMove(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        boolean haveRow;
        long revision = -1L;
        File reposRelPath = null;
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            haveRow = stmt.next();
            if (haveRow) {
                revision = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
                reposRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
            }
        }
        finally {
            stmt.reset();
        }
        if (!haveRow) {
            return;
        }
        stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_REPOS_PATH_REVISION);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            haveRow = stmt.next();
            while (haveRow) {
                SVNErrorMessage errorMessage;
                long nodeRevision = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
                File relPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                relPath = SVNFileUtil.skipAncestor(localRelPath, relPath);
                relPath = SVNFileUtil.createFilePath(reposRelPath, relPath);
                if (revision != nodeRevision) {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Cannot apply update because move source '{0}' is a mixed-revision working copy", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath));
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                if (!relPath.equals(SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path)))) {
                    errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Cannot apply update because move source '{0}' is a switched subtree", (Object)SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath));
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
    }

    public void wqAdd(File wriAbsPath, SVNSkel workItem) throws SVNException {
        assert (SVNWCDb.isAbsolute(wriAbsPath));
        if (workItem == null) {
            return;
        }
        DirParsedInfo parsed = this.parseDir(wriAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDb.addWorkItems(pdh.getWCRoot().getSDb(), workItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ISVNWCDb.SVNWCDbKind> getChildrenOpDepth(SVNWCDbRoot wcRoot, File localRelPath, int opDepth) throws SVNException {
        HashMap<String, ISVNWCDb.SVNWCDbKind> relPathToKind = new HashMap<String, ISVNWCDb.SVNWCDbKind>();
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_OP_DEPTH_CHILDREN);
        try {
            stmt.bindf("isi", wcRoot.getWcId(), localRelPath, opDepth);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File childRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                ISVNWCDb.SVNWCDbKind childKind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                relPathToKind.put(SVNFileUtil.getFileName(childRelPath), childKind);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return relPathToKind;
    }

    @Override
    public ISVNWCDb.SwitchedInfo isSwitched(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = parsed.localRelPath;
        ISVNWCDb.SwitchedInfo switchedInfo = new ISVNWCDb.SwitchedInfo();
        switchedInfo.isSwitched = false;
        if (localRelPath.getPath().length() == 0) {
            switchedInfo.isWcRoot = true;
            switchedInfo.kind = ISVNWCDb.SVNWCDbKind.Dir;
            return switchedInfo;
        }
        switchedInfo.isWcRoot = false;
        IsSwitched is = new IsSwitched();
        is.wcRoot = pdh.getWCRoot();
        is.localRelPath = localRelPath;
        pdh.getWCRoot().getSDb().runTransaction(is);
        switchedInfo.isSwitched = is.isSwitched;
        switchedInfo.kind = is.kind;
        return switchedInfo;
    }

    @Override
    public List<File> getConflictMarkerFiles(File localAbsPath) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        if (pdh.getWCRoot().getFormat() == 29) {
            GetConflictMarkerFiles17 conflictMarkerFiles = new GetConflictMarkerFiles17();
            conflictMarkerFiles.wcRoot = pdh.getWCRoot();
            conflictMarkerFiles.localRelPath = parsed.localRelPath;
            pdh.getWCRoot().getSDb().runTransaction(conflictMarkerFiles);
            return conflictMarkerFiles.markerFiles;
        }
        GetConflictMarkerFiles conflictMarkerFiles = new GetConflictMarkerFiles();
        conflictMarkerFiles.wcRoot = pdh.getWCRoot();
        conflictMarkerFiles.localRelPath = parsed.localRelPath;
        pdh.getWCRoot().getSDb().runTransaction(conflictMarkerFiles);
        return conflictMarkerFiles.markerFiles;
    }

    @Override
    public long[] minMaxRevisions(File localAbsPath, boolean committed) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return this.getMinMaxRevisions(pdh.getWCRoot(), parsed.localRelPath, committed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getMinMaxRevisions(SVNWCDbRoot wcRoot, File localRelPath, boolean committed) throws SVNException {
        long maxRevision;
        long minRevision;
        SVNWCDbSelectMinMaxRevisions stmt = (SVNWCDbSelectMinMaxRevisions)wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_MIN_MAX_REVISIONS);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            stmt.next();
            if (committed) {
                minRevision = stmt.getMinChangedRevision();
                maxRevision = stmt.getMaxChangedRevision();
            } else {
                minRevision = stmt.getMinRevision();
                maxRevision = stmt.getMaxRevision();
            }
        }
        finally {
            stmt.reset();
        }
        return new long[]{minRevision, maxRevision};
    }

    @Override
    public boolean opHandleMoveBack(File localAbsPath, File movedFromAbsPath, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot wcRoot = pdh.getWCRoot();
        File movedFromRelPath = SVNFileUtil.skipAncestor(wcRoot.getAbsPath(), movedFromAbsPath);
        if ("".equals(parsed.localRelPath) || movedFromRelPath == null) {
            SVNWCDb.addWorkItems(wcRoot.getSDb(), workItems);
            return false;
        }
        HandleMoveBack handleMoveBack = new HandleMoveBack();
        handleMoveBack.wcRoot = wcRoot;
        handleMoveBack.localRelPath = parsed.localRelPath;
        handleMoveBack.movedFromRelPath = movedFromRelPath;
        handleMoveBack.workItems = workItems;
        wcRoot.getSDb().runTransaction(handleMoveBack);
        return handleMoveBack.movedBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int opDepthOf(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            assert (haveRow);
            int n = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            return n;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File requiredLockForResolve(File localAbsPath) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        RequiredLockForResolve requiredLockForResolve = new RequiredLockForResolve();
        requiredLockForResolve.wcRoot = pdh.getWCRoot();
        requiredLockForResolve.localRelPath = parsed.localRelPath;
        pdh.getWCRoot().getSDb().runTransaction(requiredLockForResolve);
        return SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), requiredLockForResolve.requiredRelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<SVNURL, String> getNodeLockTokensRecursive(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        long lastReposId = -1L;
        ReposInfo reposInfo = null;
        HashMap<SVNURL, String> lockTokens = new HashMap<SVNURL, String>();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE_LOCK_TOKENS_RECURSIVE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), parsed.localRelPath);
            boolean haveRow = stmt.next();
            while (haveRow) {
                long childReposId = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
                File childRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path);
                String lockToken = stmt.getJoinedStatement(SVNWCDbSchema.LOCK).getColumnString(SVNWCDbSchema.LOCK__Fields.lock_token);
                if (childReposId != lastReposId) {
                    reposInfo = this.fetchReposInfo(pdh.getWCRoot().getSDb(), childReposId);
                    lastReposId = childReposId;
                }
                assert (reposInfo.reposRootUrl != null);
                lockTokens.put(SVNURL.parseURIEncoded(reposInfo.reposRootUrl).appendPath(SVNFileUtil.getFilePath(childRelPath), false), lockToken);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return lockTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SVNWCContext.CommittableExternalInfo> committableExternalsBelow(File localAbsPath, boolean immediatesOnly) throws SVNException {
        ArrayList<SVNWCContext.CommittableExternalInfo> result = null;
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = parsed.localRelPath;
        SVNWCDbSelectCommittableExternalsImmediatelyBelow stmt = (SVNWCDbSelectCommittableExternalsImmediatelyBelow)pdh.getWCRoot().getSDb().getStatement(immediatesOnly ? SVNWCDbStatements.SELECT_COMMITTABLE_EXTERNALS_IMMEDIATELY_BELOW : SVNWCDbStatements.SELECT_COMMITTABLE_EXTERNALS_BELOW);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                result = new ArrayList<SVNWCContext.CommittableExternalInfo>();
            }
            while (haveRow) {
                SVNWCContext.CommittableExternalInfo info = new SVNWCContext.CommittableExternalInfo();
                localRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.EXTERNALS__Fields.local_relpath);
                info.localAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelPath);
                ISVNWCDb.SVNWCDbKind dbKind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.EXTERNALS__Fields.kind);
                info.kind = dbKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
                info.reposRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.EXTERNALS__Fields.def_repos_relpath);
                info.reposRootUrl = SVNURL.parseURIEncoded(SvnWcDbStatementUtil.getColumnText(stmt.getInternalStatement1(), SVNWCDbSchema.REPOSITORY__Fields.root));
                result.add(info);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return result;
    }

    @Override
    public ISVNWCDb.Moved scanMoved(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = parsed.localRelPath;
        Structure<StructureFields.AdditionInfo> additionInfoStructure = SvnWcDbShared.scanAddition(pdh.getWCRoot(), localRelPath, StructureFields.AdditionInfo.status, StructureFields.AdditionInfo.opRootRelPath, StructureFields.AdditionInfo.movedFromRelPath, StructureFields.AdditionInfo.movedFromOpRootRelPath, StructureFields.AdditionInfo.movedFromOpDepth);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)additionInfoStructure.get(StructureFields.AdditionInfo.status));
        File opRootRelPath = (File)additionInfoStructure.get(StructureFields.AdditionInfo.opRootRelPath);
        File movedFromRelPath = (File)additionInfoStructure.get(StructureFields.AdditionInfo.movedFromRelPath);
        File movedFromOpRootRelPath = (File)additionInfoStructure.get(StructureFields.AdditionInfo.movedFromOpRootRelPath);
        long movedFromOpDepth = additionInfoStructure.lng(StructureFields.AdditionInfo.movedFromOpDepth);
        if (status != ISVNWCDb.SVNWCDbStatus.MovedHere) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Path ''{0}'' was not moved here", (Object)SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelPath));
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        ISVNWCDb.Moved moved = new ISVNWCDb.Moved();
        moved.opRootAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), opRootRelPath);
        moved.movedFromAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), movedFromRelPath);
        moved.opRootMovedFromAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), movedFromOpRootRelPath);
        File tmp = movedFromOpRootRelPath;
        assert (movedFromOpDepth >= 0L);
        while ((long)SVNWCUtils.relpathDepth(tmp) > movedFromOpDepth) {
            tmp = SVNFileUtil.getFileDir(tmp);
        }
        moved.movedFromDeleteAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), tmp);
        return moved;
    }

    @Override
    public void dropRoot(File localAbsPath) throws SVNException {
        SVNWCDbDir rootDir = this.dirData.get(localAbsPath);
        if (rootDir == null) {
            return;
        }
        if (!rootDir.getWCRoot().getAbsPath().equals(localAbsPath)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy root", (Object)localAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        Iterator<Map.Entry<String, SVNWCDbDir>> iterator2 = this.dirData.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, SVNWCDbDir> entry = iterator2.next();
            SVNWCDbDir wcDir = entry.getValue();
            if (rootDir != wcDir) continue;
            iterator2.remove();
        }
        rootDir.getWCRoot().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeInsertExternal(File localAbsPath, SVNNodeKind kind, File parentAbsPath, File defLocalAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long defPegRevision, long defRevision) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(defLocalAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File defLocalRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        long reposId = -1L;
        boolean haveRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_REPOSITORY);
        try {
            stmt.bindf("s", reposRootUrl);
            haveRow = stmt.next();
            if (haveRow) {
                reposId = stmt.getColumnLong(SVNWCDbSchema.REPOSITORY__Fields.id);
            }
        }
        finally {
            stmt.reset();
        }
        if (!haveRow) {
            this.createReposId(pdh.getWCRoot().getSDb(), reposRootUrl, reposUuid);
        }
        stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_EXTERNAL);
        try {
            stmt.bindf("isssssis", pdh.getWCRoot().getWcId(), SVNFileUtil.skipAncestor(pdh.getWCRoot().getAbsPath(), localAbsPath), SVNFileUtil.skipAncestor(pdh.getWCRoot().getAbsPath(), parentAbsPath), SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.Normal), SvnWcDbStatementUtil.getKindText(kind == SVNNodeKind.DIR ? ISVNWCDb.SVNWCDbKind.Dir : ISVNWCDb.SVNWCDbKind.File), defLocalRelPath, reposId, reposRelPath);
            if (SVNRevision.isValidRevisionNumber(defPegRevision)) {
                stmt.bindLong(9, defPegRevision);
            }
            if (SVNRevision.isValidRevisionNumber(defRevision)) {
                stmt.bindLong(10, defRevision);
            }
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    private static class RequiredLockForResolve
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public File requiredRelPath;

        private RequiredLockForResolve() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            this.requiredRelPath = this.localRelPath;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_MOVED_OUTSIDE);
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), this.localRelPath, 0);
                boolean haveRow = stmt.next();
                while (haveRow) {
                    File moveDstRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    this.requiredRelPath = SVNFileUtil.createFilePath(SVNPathUtil.getCommonPathAncestor(SVNFileUtil.getFilePath(this.requiredRelPath), SVNFileUtil.getFilePath(moveDstRelPath)));
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class HandleMoveBack
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public File movedFromRelPath;
        public SVNSkel workItems;
        public boolean movedBack;

        private HandleMoveBack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            this.movedBack = false;
            boolean different = false;
            SVNWCDb.addWorkItems(db, this.workItems);
            Structure<StructureFields.NodeInfo> nodeInfoStructure = SvnWcDbShared.readInfo(this.wcRoot, this.localRelPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.opRoot, StructureFields.NodeInfo.haveMoreWork);
            ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
            boolean opRoot = nodeInfoStructure.is(StructureFields.NodeInfo.opRoot);
            boolean haveMoreWork = nodeInfoStructure.is(StructureFields.NodeInfo.haveMoreWork);
            if (status != ISVNWCDb.SVNWCDbStatus.Added || !opRoot) {
                this.movedBack = false;
                return;
            }
            int fromOpDepth = haveMoreWork ? SVNWCDb.opDepthOf(this.wcRoot, this.localRelPath) : 0;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_MOVED_BACK);
            try {
                stmt.bindf("isii", this.wcRoot.getWcId(), this.localRelPath, fromOpDepth, SVNWCUtils.relpathDepth(this.localRelPath));
                boolean haveRow = stmt.next();
                assert (haveRow);
                boolean movedHere = stmt.getColumnBoolean(SVNWCDbSchema.NODES__Fields.moved_here);
                File movedTo = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                if (!movedHere || movedTo == null || !movedTo.equals(this.movedFromRelPath)) {
                    different = true;
                    haveRow = false;
                }
                while (haveRow) {
                    int lowerReposId;
                    long lowerRevision;
                    ISVNWCDb.SVNWCDbStatus upperStatus = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                    if (stmt.getJoinedStatement(SVNWCDbSchema.NODES).isColumnNull(SVNWCDbSchema.NODES__Fields.presence)) {
                        if (upperStatus == ISVNWCDb.SVNWCDbStatus.NotPresent) continue;
                        different = true;
                        break;
                    }
                    ISVNWCDb.SVNWCDbStatus lowerStatus = SvnWcDbStatementUtil.getColumnPresence(stmt.getJoinedStatement(SVNWCDbSchema.NODES), SVNWCDbSchema.NODES__Fields.presence);
                    if (upperStatus != lowerStatus) {
                        different = true;
                        break;
                    }
                    if (upperStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || upperStatus == ISVNWCDb.SVNWCDbStatus.Excluded) {
                        haveRow = stmt.next();
                        continue;
                    }
                    if (upperStatus != ISVNWCDb.SVNWCDbStatus.Normal) {
                        different = true;
                        break;
                    }
                    File upperReposRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
                    File lowerReposRelPath = SVNFileUtil.createFilePath(stmt.getJoinedStatement(SVNWCDbSchema.NODES).getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
                    if (upperReposRelPath == null || !upperReposRelPath.equals(lowerReposRelPath)) {
                        different = true;
                        break;
                    }
                    long upperRevision = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
                    if (upperRevision != (lowerRevision = stmt.getJoinedStatement(SVNWCDbSchema.NODES).getColumnLong(SVNWCDbSchema.NODES__Fields.revision))) {
                        different = true;
                        break;
                    }
                    int upperReposId = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
                    if (upperReposId != (lowerReposId = (int)stmt.getJoinedStatement(SVNWCDbSchema.NODES).getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id))) {
                        different = true;
                        break;
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            if (!different) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_MOVED_BACK);
                try {
                    stmt.bindf("isi", this.wcRoot.getWcId(), this.localRelPath, SVNWCUtils.relpathDepth(this.localRelPath));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                this.movedBack = true;
            }
        }
    }

    private static class GetConflictMarkerFiles17
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public List<File> markerFiles;

        private GetConflictMarkerFiles17() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            File prejAbsPath;
            File conflictWorkingAbsPath;
            File conflictNewAbsPath;
            File conflictOldAbsPath;
            String prejRelPath;
            String conflictWorkingRelPath;
            String conflictNewRelPath;
            String conflictOldRelPath;
            boolean haveRow;
            this.markerFiles = new ArrayList<File>();
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.localRelPath);
                haveRow = stmt.next();
                if (!((!haveRow || stmt.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) && stmt.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) && stmt.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working)) && stmt.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject))) {
                    conflictOldRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
                    conflictNewRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new);
                    conflictWorkingRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                    prejRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
                    conflictOldAbsPath = conflictOldRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictOldRelPath);
                    conflictNewAbsPath = conflictNewRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictNewRelPath);
                    conflictWorkingAbsPath = conflictWorkingRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictWorkingRelPath);
                    File file = prejAbsPath = prejRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), prejRelPath);
                    if (conflictOldAbsPath != null) {
                        this.markerFiles.add(conflictOldAbsPath);
                    }
                    if (conflictNewAbsPath != null) {
                        this.markerFiles.add(conflictNewAbsPath);
                    }
                    if (conflictWorkingAbsPath != null) {
                        this.markerFiles.add(conflictWorkingAbsPath);
                    }
                    if (prejAbsPath != null) {
                        this.markerFiles.add(prejAbsPath);
                    }
                }
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.SELECT_CONFLICT_VICTIMS_17);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.localRelPath);
                haveRow = stmt.next();
                while (haveRow) {
                    conflictOldRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
                    conflictNewRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new);
                    conflictWorkingRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                    prejRelPath = stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
                    conflictOldAbsPath = conflictOldRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictOldRelPath);
                    conflictNewAbsPath = conflictNewRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictNewRelPath);
                    conflictWorkingAbsPath = conflictWorkingRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), conflictWorkingRelPath);
                    File file = prejAbsPath = prejRelPath == null ? null : SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), prejRelPath);
                    if (conflictOldAbsPath != null) {
                        this.markerFiles.add(conflictOldAbsPath);
                    }
                    if (conflictNewAbsPath != null) {
                        this.markerFiles.add(conflictNewAbsPath);
                    }
                    if (conflictWorkingAbsPath != null) {
                        this.markerFiles.add(conflictWorkingAbsPath);
                    }
                    if (prejAbsPath != null) {
                        this.markerFiles.add(prejAbsPath);
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            if (this.markerFiles.size() == 0) {
                this.markerFiles = null;
            }
        }
    }

    private static class GetConflictMarkerFiles
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public List<File> markerFiles;

        private GetConflictMarkerFiles() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            List<File> markers;
            SVNErrorMessage errorMessage;
            SVNSkel conflicts;
            byte[] conflictData;
            boolean haveRow;
            this.markerFiles = new ArrayList<File>();
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.localRelPath);
                haveRow = stmt.next();
                if (haveRow && !stmt.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data)) {
                    conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data);
                    conflicts = SVNSkel.parse(conflictData);
                    if (conflicts == null) {
                        errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Malformed skeleton data ''{0}''", (Object)new String(conflictData));
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    }
                    if ((markers = SvnWcDbConflicts.readConflictMarkers(this.wcRoot.getDb(), this.wcRoot.getAbsPath(), conflicts)) != null) {
                        this.markerFiles.addAll(markers);
                    }
                }
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.SELECT_CONFLICT_VICTIMS);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.localRelPath);
                haveRow = stmt.next();
                while (haveRow) {
                    conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data);
                    if (conflictData != null) {
                        conflicts = SVNSkel.parse(conflictData);
                        if (conflicts == null) {
                            errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Malformed skeleton data ''{0}''", (Object)new String(conflictData));
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        }
                        if ((markers = SvnWcDbConflicts.readConflictMarkers(this.wcRoot.getDb(), this.wcRoot.getAbsPath(), conflicts)) != null) {
                            this.markerFiles.addAll(markers);
                        }
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            if (this.markerFiles.size() == 0) {
                this.markerFiles = null;
            }
        }
    }

    private class IsSwitched
    implements SVNSqlJetTransaction {
        private SVNWCDbRoot wcRoot;
        private File localRelPath;
        private boolean isSwitched;
        private ISVNWCDb.SVNWCDbKind kind;

        private IsSwitched() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            File expectedPath;
            Structure<StructureFields.NodeInfo> nodeInfoStructure = SvnWcDbShared.readInfo(this.wcRoot, this.localRelPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
            ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
            this.kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
            File reposRelPath = (File)nodeInfoStructure.get(StructureFields.NodeInfo.reposRelPath);
            long reposId = nodeInfoStructure.lng(StructureFields.NodeInfo.reposId);
            if (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node '{0}' was not found.", (Object)SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), this.localRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else if (reposRelPath == null) {
                this.isSwitched = false;
                return;
            }
            File parentLocalRelPath = SVNFileUtil.getFileDir(this.localRelPath);
            String name = SVNFileUtil.getFileName(this.localRelPath);
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(this.wcRoot, parentLocalRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
            File parentReposRelPath = baseInfo.reposRelPath;
            long parentReposId = baseInfo.reposId;
            this.isSwitched = reposId != parentReposId ? true : !(expectedPath = SVNFileUtil.createFilePath(parentReposRelPath, name)).equals(reposRelPath);
        }
    }

    private static class UpdateMovedAwayNodeInfo {
        public SVNProperties props;
        public SvnChecksum checksum;
        public List<String> children;
        public SVNNodeKind kind;

        private UpdateMovedAwayNodeInfo() {
        }
    }

    private class UpdateMovedAwayConflictVictim
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File victimRelPath;
        public SVNOperation operation;
        public SVNConflictReason localChange;
        public SVNConflictAction incomingChange;
        public File moveSrcOpRootRelPath;
        public SVNConflictVersion oldVersion;
        public SVNConflictVersion newVersion;

        private UpdateMovedAwayConflictVictim() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean haveRow;
            BaseMovedTo movedTo = SVNWCDb.this.opDepthMovedTo(SVNWCUtils.relpathDepth(this.moveSrcOpRootRelPath) - 1, this.wcRoot, this.victimRelPath);
            File moveRootDstRelPath = movedTo.moveDstOpRootRelPath;
            if (moveRootDstRelPath == null) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "The node '{0}' has not been moved away", (Object)SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), this.victimRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            File moveRootDstAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), moveRootDstRelPath);
            SVNWCContext.writeCheck(SVNWCDb.this, moveRootDstAbsPath);
            SVNSqlJetStatement stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HIGHEST_WORKING_NODE);
            int srcOpDepth = 0;
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), this.moveSrcOpRootRelPath, SVNWCUtils.relpathDepth(this.moveSrcOpRootRelPath));
                haveRow = stmt.next();
                if (haveRow) {
                    srcOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                }
            }
            finally {
                stmt.reset();
            }
            if (!haveRow) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' is not deleted", (Object)SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), this.victimRelPath));
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (srcOpDepth == 0) {
                SVNWCDb.this.suitableForMove(this.wcRoot, this.victimRelPath);
            }
            stmt = new SVNWCDbCreateSchema(db.getTemporaryDb(), SVNWCDbCreateSchema.CREATE_UPDATE_MOVE_LIST, -1, false);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            SVNTreeConflictEditor treeConflictEditor = new SVNTreeConflictEditor(this.wcRoot.getDb(), this.operation, this.oldVersion, this.newVersion, this.wcRoot, moveRootDstRelPath);
            this.wcRoot.getDb().driveTreeConflictEditor(treeConflictEditor, this.victimRelPath, moveRootDstRelPath, srcOpDepth, this.operation, this.localChange, this.incomingChange, this.oldVersion, this.newVersion, this.wcRoot);
        }
    }

    private static class TcInfo {
        public SVNTreeConflictDescription treeConflictDescription;
        public File moveSrcOpRootAbsPath;

        private TcInfo() {
        }
    }

    private class ResolveDeleteRaiseMovedAway
    implements SVNSqlJetTransaction {
        public SVNWCDbDir pdh;
        public File localRelPath;
        public SVNOperation operation;
        public SVNConflictAction action;
        public SVNConflictVersion oldVersion;
        public SVNConflictVersion newVersion;

        private ResolveDeleteRaiseMovedAway() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNWCDbRoot wcRoot = this.pdh.getWCRoot();
            long opDepth = SVNWCUtils.relpathDepth(this.localRelPath);
            SVNSqlJetStatement stmt = new SVNWCDbCreateSchema(db.getTemporaryDb(), SVNWCDbCreateSchema.CREATE_UPDATE_MOVE_LIST, -1, false);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_OP_DEPTH_MOVED_PAIR);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), this.localRelPath, opDepth);
                boolean haveRow = stmt.next();
                while (haveRow) {
                    File movedRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                    File moveRootDstRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    File movedDstReposRelPath = SVNFileUtil.createFilePath(((SVNWCDbSelectOpDepthMovedPair)stmt).getReposPath());
                    SVNWCDb.this.markTreeConflict(movedRelPath, this.pdh.getWCRoot(), this.oldVersion, this.newVersion, moveRootDstRelPath, this.operation, SVNNodeKind.DIR, SVNNodeKind.DIR, movedDstReposRelPath, SVNConflictReason.MOVED_AWAY, this.action, this.localRelPath);
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class BreakMove
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File srcRelPath;
        public long deleteOpDepth;
        public File dstRelPath;
        public SVNSkel workItems;

        private BreakMove() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.CLEAR_MOVE_TO_RELPATH);
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), this.srcRelPath, this.deleteOpDepth);
                long affected = stmt.done();
                if (affected != 1L) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Path ''{0}'' is not moved");
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            }
            finally {
                stmt.reset();
            }
            SVNWCDb.clearMovedHere(this.dstRelPath, this.wcRoot);
            SVNWCDb.addWorkItems(db, this.workItems);
        }
    }

    private static class BreakMove17
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File srcRelPath;
        public long srcOpDepth;
        public File dstRelPath;
        public long dstOpDepth;

        private BreakMove17() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.CLEAR_MOVE_TO_RELPATH);
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), this.srcRelPath, this.srcOpDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_RECURSIVE);
            try {
                stmt.bindf("isii", this.wcRoot.getWcId(), this.dstRelPath, this.dstOpDepth, this.dstOpDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    protected static class ResolveBreakMovedAway
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public File delRelPath;
        public boolean markTreeConflictResolved;
        private ISVNEventHandler eventHandler;

        protected ResolveBreakMovedAway() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            long srcOpDepth = SVNWCDb.findSrcOpDepth(this.wcRoot, this.localRelPath, this.delRelPath != null ? (long)SVNWCUtils.relpathDepth(this.delRelPath) : (long)SVNWCUtils.relpathDepth(this.localRelPath));
            this.breakMovedAway(this.wcRoot, this.localRelPath, srcOpDepth);
            if (this.markTreeConflictResolved) {
                this.wcRoot.getDb().opMarkResolvedInternal(this.wcRoot, this.localRelPath, false, false, true, null);
            }
            this.wcRoot.getDb().updateMoveListNotify(this.wcRoot, -1L, -1L, this.eventHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void breakMovedAway(SVNWCDbRoot wcRoot, File localRelPath, long parentSrcOpDepth) throws SVNException, SqlJetException {
            SVNSqlJetDb db = wcRoot.getSDb();
            SVNSqlJetStatement stmt = new SVNWCDbCreateSchema(db.getTemporaryDb(), SVNWCDbCreateSchema.CREATE_UPDATE_MOVE_LIST, -1, false);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.SELECT_MOVED_DESCENDANTS_SRC);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelPath, parentSrcOpDepth);
                while (stmt.next()) {
                    long srcOpDepth = ((SVNWCDbSelectMovedDescendantsSrc)stmt).getInternalSelect().getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    File srcRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                    ISVNWCDb.SVNWCDbKind srcKind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    File dstRelpath = SVNFileUtil.createFilePath(((SVNWCDbSelectMovedDescendantsSrc)stmt).getInternalSelect().getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    BreakMove breakMove = new BreakMove();
                    breakMove.wcRoot = wcRoot;
                    breakMove.srcRelPath = srcRelpath;
                    breakMove.deleteOpDepth = srcOpDepth;
                    breakMove.dstRelPath = dstRelpath;
                    breakMove.workItems = null;
                    breakMove.transaction(db);
                    SVNWCDb.updateMoveListAdd(wcRoot, srcRelpath, SVNEventAction.MOVE_BROKEN, srcKind.toNodeKind(), SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    public static class BaseMovedTo
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot wcRoot;
        public File localRelPath;
        public long opDepth;
        public File moveDstOpRootRelPath;
        public File moveDstRelPath;
        public File moveSrcRootRelPath;
        public File moveSrcOpRootRelPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean haveRow;
            File moveDstOpRootRelPath = null;
            File moveDstRelPath = null;
            File moveSrcRootRelPath = null;
            File moveSrcOpRootRelPath = null;
            long deleteOpDepth = 0L;
            File relPath = this.localRelPath;
            do {
                SVNSqlJetStatement stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
                try {
                    stmt.bindf("isi", this.wcRoot.getWcId(), this.localRelPath, this.opDepth);
                    haveRow = stmt.next();
                    if (haveRow) {
                        deleteOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                        moveDstOpRootRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                        if (moveDstOpRootRelPath != null) {
                            moveSrcRootRelPath = relPath;
                        }
                    }
                    if (moveDstOpRootRelPath != null) continue;
                    relPath = SVNFileUtil.getParentFile(relPath);
                }
                finally {
                    stmt.reset();
                }
            } while (moveDstOpRootRelPath == null && haveRow && deleteOpDepth <= (long)SVNWCUtils.relpathDepth(relPath));
            if (moveDstOpRootRelPath != null) {
                moveDstRelPath = SVNFileUtil.createFilePath(moveDstOpRootRelPath, SVNWCUtils.skipAncestor(relPath, this.localRelPath));
                while (deleteOpDepth < (long)SVNWCUtils.relpathDepth(relPath)) {
                    relPath = SVNFileUtil.getParentFile(relPath);
                }
                moveSrcOpRootRelPath = relPath;
            }
            this.moveSrcRootRelPath = moveSrcRootRelPath;
            this.moveSrcOpRootRelPath = moveSrcOpRootRelPath;
            this.moveDstRelPath = moveDstRelPath;
            this.moveDstOpRootRelPath = moveDstOpRootRelPath;
        }
    }

    public class CheckReplace
    implements SVNSqlJetTransaction {
        public long wcId;
        public File localRelpath;
        public boolean replaceRoot;
        public boolean baseReplace;
        public boolean replace;

        public CheckReplace(long wcId, File localRelpath) {
            this.wcId = wcId;
            this.localRelpath = localRelpath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            long replacedOpDepth;
            ISVNWCDb.SVNWCDbStatus replacedStatus;
            boolean haveRow;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            try {
                ISVNWCDb.SVNWCDbStatus status;
                stmt.bindf("is", this.wcId, this.localRelpath.getPath());
                haveRow = stmt.next();
                if (!haveRow) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)this.localRelpath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((status = SvnWcDbStatementUtil.getColumnPresence(stmt)) != ISVNWCDb.SVNWCDbStatus.Normal) {
                    return;
                }
                haveRow = stmt.next();
                if (!haveRow) {
                    return;
                }
                replacedStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                if (replacedStatus != ISVNWCDb.SVNWCDbStatus.NotPresent && replacedStatus != ISVNWCDb.SVNWCDbStatus.Excluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.ServerExcluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.Deleted) {
                    this.replace = true;
                }
                replacedOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                while (opDepth != 0L && haveRow) {
                    haveRow = stmt.next();
                    if (!haveRow) continue;
                    opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                }
                if (haveRow && opDepth == 0L) {
                    ISVNWCDb.SVNWCDbStatus baseStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    this.baseReplace = baseStatus != ISVNWCDb.SVNWCDbStatus.NotPresent;
                }
            }
            finally {
                stmt.reset();
            }
            if (replacedStatus != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                long parentOpDepth;
                try {
                    stmt.bindf("is", this.wcId, SVNFileUtil.getFileDir(this.localRelpath));
                    stmt.nextRow();
                    parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    if (parentOpDepth >= replacedOpDepth) {
                        this.replaceRoot = parentOpDepth == replacedOpDepth;
                        return;
                    }
                    haveRow = stmt.next();
                    if (haveRow) {
                        parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    }
                }
                finally {
                    stmt.reset();
                }
                if (!haveRow) {
                    this.replaceRoot = true;
                } else if (parentOpDepth < replacedOpDepth) {
                    this.replaceRoot = true;
                }
            }
        }
    }

    public class Commit
    implements SVNSqlJetTransaction {
        public SVNWCDbDir pdh;
        public File localRelpath;
        public long newRevision;
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;
        public SvnChecksum newChecksum;
        public List<File> newChildren;
        public SVNProperties newDavCache;
        public boolean keepChangelist;
        public boolean noUnlock;
        public SVNSkel workItems;
        public long reposId;
        public File reposRelPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            ISVNWCDb.SVNWCDbKind newKind;
            long opDepth;
            boolean haveAct;
            SVNSqlJetStatement stmtAct = null;
            SVNSqlJetStatement stmtInfo = null;
            byte[] propBlob = null;
            String changelist = null;
            String newDepthStr = null;
            boolean fileExternal = false;
            ISVNWCDb.SVNWCDbStatus oldPresence = null;
            ReposInfo2 reposInfo = SVNWCDb.this.determineReposInfo(this.pdh, this.localRelpath);
            this.reposId = reposInfo.reposId;
            this.reposRelPath = reposInfo.reposRelPath;
            SVNSqlJetDb sdb = this.pdh.getWCRoot().getSDb();
            long wcId = this.pdh.getWCRoot().getWcId();
            try {
                stmtInfo = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcId, this.localRelpath);
                stmtInfo.next();
                stmtAct = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                stmtAct.bindf("is", wcId, this.localRelpath);
                haveAct = stmtAct.next();
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                newKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                if (newKind == ISVNWCDb.SVNWCDbKind.Dir) {
                    newDepthStr = SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.depth);
                }
                if (haveAct) {
                    propBlob = SvnWcDbStatementUtil.getColumnBlob(stmtAct, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                }
                if (propBlob == null) {
                    propBlob = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                }
                if (this.keepChangelist && haveAct) {
                    changelist = SvnWcDbStatementUtil.getColumnText(stmtAct, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                }
                oldPresence = SvnWcDbStatementUtil.getColumnPresence(stmtInfo);
            }
            finally {
                if (stmtInfo != null) {
                    stmtInfo.reset();
                }
                if (stmtAct != null) {
                    stmtAct.reset();
                }
            }
            if (opDepth > 0L) {
                long affectedRows;
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ALL_LAYERS);
                try {
                    stmt.bindf("is", wcId, this.localRelpath);
                    affectedRows = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows > 1L) {
                    stmt = sdb.getStatement(SVNWCDbStatements.DELETE_SHADOWED_RECURSIVE);
                    try {
                        stmt.bindf("isi", wcId, this.localRelpath, opDepth);
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                }
                this.commitDescendant(this.localRelpath, this.reposRelPath, opDepth, this.newRevision);
            }
            File parentRelpath = this.localRelpath == null || "".equals(SVNFileUtil.getFilePath(this.localRelpath)) ? null : SVNFileUtil.getFileDir(this.localRelpath);
            ISVNWCDb.SVNWCDbStatus newPresence = oldPresence == ISVNWCDb.SVNWCDbStatus.Incomplete ? ISVNWCDb.SVNWCDbStatus.Incomplete : ISVNWCDb.SVNWCDbStatus.Normal;
            stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.APPLY_CHANGES_TO_BASE_NODE);
            try {
                stmt.bindf("issisrtstrisnbnn", this.pdh.getWCRoot().getWcId(), this.localRelpath, parentRelpath, this.reposId, this.reposRelPath, this.newRevision, SvnWcDbStatementUtil.getPresenceText(newPresence), newDepthStr, SvnWcDbStatementUtil.getKindText(newKind), this.changedRev, this.changedDate, this.changedAuthor, propBlob);
                stmt.bindChecksum(13, this.newChecksum);
                stmt.bindProperties(15, this.newDavCache);
                if (fileExternal) {
                    stmt.bindString(17, "1");
                } else {
                    stmt.bindNull(17);
                }
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (haveAct) {
                if (this.keepChangelist && changelist != null) {
                    stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.RESET_ACTUAL_WITH_CHANGELIST);
                    try {
                        stmt.bindf("isss", this.pdh.getWCRoot().getWcId(), this.localRelpath, SVNFileUtil.getFileDir(this.localRelpath), changelist);
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                }
                stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
                try {
                    stmt.bindf("is", this.pdh.getWCRoot().getWcId(), this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (!this.noUnlock) {
                SVNSqlJetStatement lockStmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_LOCK);
                try {
                    lockStmt.bindf("is", this.reposId, this.reposRelPath);
                    lockStmt.done();
                }
                finally {
                    lockStmt.reset();
                }
            }
            SVNWCDb.addWorkItems(this.pdh.getWCRoot().getSDb(), this.workItems);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitDescendant(File parentLocalRelPath, File parentReposRelPath, long opDepth, long revision) throws SVNException {
            List<String> children = SVNWCDb.this.gatherRepoChildren(this.pdh.getWCRoot(), parentLocalRelPath, opDepth);
            for (String name : children) {
                SVNSqlJetStatement stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.COMMIT_DESCENDANT_TO_BASE);
                try {
                    File childLocalRelPath = SVNFileUtil.createFilePath(parentLocalRelPath, name);
                    File childReposRelPath = SVNFileUtil.createFilePath(parentReposRelPath, name);
                    stmt.bindf("isiisr", this.pdh.getWCRoot().getWcId(), childLocalRelPath, opDepth, this.reposId, childReposRelPath, revision);
                    stmt.done();
                    this.commitDescendant(childLocalRelPath, childReposRelPath, opDepth, revision);
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    private static class ReposInfo2 {
        public long reposId;
        public File reposRelPath;

        private ReposInfo2() {
        }
    }

    private class WCLockObtain
    implements SVNSqlJetTransaction {
        SVNWCDbDir pdh;
        File localRelpath;
        int levelsToLock;
        boolean stealLock;

        private WCLockObtain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNErrorMessage err;
            SVNErrorMessage err1;
            File lockRelpath;
            boolean gotRow;
            boolean nodeExists;
            SVNWCDbRoot wcroot = this.pdh.getWCRoot();
            if (this.localRelpath != null && !"".equals(SVNFileUtil.getFilePath(this.localRelpath)) && !(nodeExists = SvnWcDbShared.doesNodeExists(wcroot, this.localRelpath))) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcroot.getAbsPath(this.localRelpath));
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            int lockDepth = SVNWCUtils.relpathDepth(this.localRelpath);
            int maxDepth = lockDepth + this.levelsToLock;
            SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.FIND_WC_LOCK);
            try {
                stmt.bindf("is", wcroot.getWcId(), this.localRelpath);
                gotRow = stmt.next();
                while (gotRow) {
                    lockRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.WC_LOCK__Fields.local_dir_relpath));
                    if (this.levelsToLock >= 0 && SVNWCUtils.relpathDepth(lockRelpath) > maxDepth) {
                        gotRow = stmt.next();
                        continue;
                    }
                    File lockAbspath = SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath);
                    boolean ownLock = SVNWCDb.this.isWCLockOwns(lockAbspath, true);
                    if (!ownLock && !this.stealLock) {
                        err1 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath));
                        err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                        err.setChildErrorMessage(err1);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    } else if (!ownLock) {
                        SVNWCDb.this.stealWCLock(wcroot, lockRelpath);
                    }
                    gotRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            if (this.stealLock) {
                SVNWCDb.this.stealWCLock(wcroot, this.localRelpath);
            }
            stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.SELECT_WC_LOCK);
            try {
                lockRelpath = this.localRelpath;
                while (true) {
                    stmt.bindf("is", wcroot.getWcId(), lockRelpath);
                    gotRow = stmt.next();
                    if (gotRow) {
                        long levels = stmt.getColumnLong(SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                        if (levels >= 0L) {
                            levels += (long)SVNWCUtils.relpathDepth(lockRelpath);
                        }
                        stmt.reset();
                        if (levels == -1L || levels >= (long)lockDepth) {
                            err1 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath));
                            err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                            err.setChildErrorMessage(err1);
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        break;
                    }
                    stmt.reset();
                    if (lockRelpath == null) {
                        break;
                    }
                    lockRelpath = SVNFileUtil.getFileDir(lockRelpath);
                }
            }
            finally {
                stmt.reset();
            }
            stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.INSERT_WC_LOCK);
            stmt.bindf("isi", wcroot.getWcId(), this.localRelpath, this.levelsToLock);
            try {
                stmt.done();
            }
            catch (SVNException e) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
            SVNWCDbRoot.WCLock lock = new SVNWCDbRoot.WCLock();
            lock.localRelpath = this.localRelpath;
            lock.levels = this.levelsToLock;
            wcroot.getOwnedLocks().add(lock);
        }
    }

    private class SetRevRelpath
    implements SVNSqlJetTransaction {
        public SVNWCDbDir pdh;
        public File localRelpath;
        public long rev;
        public boolean setReposRelpath;
        public File reposRelpath;
        public SVNURL reposRootUrl;
        public String reposUuid;

        private SetRevRelpath() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            if (SVNRevision.isValidRevisionNumber(this.rev)) {
                stmt = db.getStatement(SVNWCDbStatements.UPDATE_BASE_REVISION);
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.rev);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (this.setReposRelpath) {
                final long reposId = SVNWCDb.this.createReposId(this.pdh.getWCRoot().getSDb(), this.reposRootUrl, this.reposUuid);
                stmt = new SVNSqlJetUpdateStatement(this.pdh.getWCRoot().getSDb(), SVNWCDbSchema.NODES){

                    @Override
                    public Map<String, Object> getUpdateValues() throws SVNException {
                        HashMap<String, Object> values2 = new HashMap<String, Object>();
                        values2.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), reposId);
                        values2.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), SVNFileUtil.getFilePath(SetRevRelpath.this.reposRelpath));
                        return values2;
                    }
                };
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, 0);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    private class BumpRevisionPostUpdate
    implements SVNSqlJetTransaction {
        public Map<File, Map<String, SVNProperties>> iprops;
        private SVNDepth depth;
        private File newReposRelPath;
        private SVNURL newReposRootURL;
        private String newReposUUID;
        private long newRevision;
        private Collection<File> exludedRelPaths;
        private File localRelPath;
        private File wcRoot;
        private SVNWCDbRoot dbWcRoot;
        private ISVNEventHandler eventHandler;

        private BumpRevisionPostUpdate() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.SVNWCDbStatus status = null;
            ISVNWCDb.WCDbBaseInfo baseInfo = null;
            try {
                baseInfo = SVNWCDb.this.getBaseInfo(this.dbWcRoot, this.localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision);
                status = baseInfo.status;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    return;
                }
                throw e;
            }
            switch (status) {
                case NotPresent: 
                case Excluded: 
                case ServerExcluded: {
                    return;
                }
            }
            long reposId = -1L;
            if (this.newReposRootURL != null) {
                reposId = SVNWCDb.this.createReposId(db, this.newReposRootURL, this.newReposUUID);
            }
            this.bumpNodeRevision(this.dbWcRoot, this.wcRoot, this.localRelPath, reposId, this.newReposRelPath, this.newRevision, this.depth, this.exludedRelPaths, true, false);
            this.bumpMovedAway(this.dbWcRoot, this.localRelPath, this.depth, this.dbWcRoot.getDb());
            SVNWCDb.this.updateMoveListNotify(this.dbWcRoot, -1L, -1L, this.eventHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bumpMovedAway(SVNWCDbRoot wcRoot, File localRelPath, SVNDepth depth, SVNWCDb db) throws SVNException {
            SVNWCDbCreateSchema createUpdateMoveList = new SVNWCDbCreateSchema(wcRoot.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.CREATE_UPDATE_MOVE_LIST, -1, false);
            try {
                createUpdateMoveList.done();
            }
            finally {
                createUpdateMoveList.reset();
            }
            BaseMovedTo baseMovedTo = db.opDepthMovedTo(0L, wcRoot, localRelPath);
            File moveDstOpRootRelPath = baseMovedTo.moveDstOpRootRelPath;
            File moveSrcRootRelPath = baseMovedTo.moveSrcRootRelPath;
            File moveSrcOpRootRelPath = baseMovedTo.moveSrcOpRootRelPath;
            if (moveSrcRootRelPath != null && !moveSrcRootRelPath.equals(localRelPath)) {
                this.bumpMarkTreeConflict(wcRoot, moveSrcRootRelPath, moveSrcOpRootRelPath, moveDstOpRootRelPath);
                return;
            }
            HashSet<File> srcDone = new HashSet<File>();
            this.bumpMovedAway(wcRoot, localRelPath, 0, srcDone, depth, db);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bumpMovedAway(SVNWCDbRoot wcRoot, File localRelPath, int opDepth, Set<File> srcDone, SVNDepth depth, ISVNWCDb db) throws SVNException {
            SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_MOVED_PAIR3);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelPath, opDepth);
                boolean haveRow = stmt.next();
                while (haveRow) {
                    int srcOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    SVNDepth srcDepth = depth;
                    File srcRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                    File dstRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.moved_to);
                    if (depth != SVNDepth.INFINITY) {
                        boolean skipThisSrc = false;
                        if (!srcRelPath.equals(localRelPath)) {
                            if (depth == SVNDepth.EMPTY) {
                                skipThisSrc = true;
                            } else if (depth == SVNDepth.FILES && SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind) != ISVNWCDb.SVNWCDbKind.File) {
                                skipThisSrc = true;
                            } else if (depth == SVNDepth.IMMEDIATES) {
                                if (!SVNFileUtil.getFileDir(srcRelPath).equals(localRelPath)) {
                                    skipThisSrc = true;
                                }
                                srcDepth = SVNDepth.EMPTY;
                            } else {
                                SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
                            }
                        }
                        if (skipThisSrc) {
                            haveRow = stmt.next();
                            continue;
                        }
                    }
                    SVNSqlJetStatement stmt2 = wcRoot.getSDb().getStatement(SVNWCDbStatements.HAS_LAYER_BETWEEN);
                    try {
                        stmt2.bindf("isii", wcRoot.getWcId(), localRelPath, opDepth, srcOpDepth);
                        haveRow = stmt2.next();
                    }
                    finally {
                        stmt2.reset();
                    }
                    if (!haveRow) {
                        File srcRootRelPath = srcRelPath;
                        boolean canBump = opDepth == 0 ? this.depthSufficientToBump(srcRelPath, wcRoot, srcDepth) : true;
                        if (!canBump) {
                            this.bumpMarkTreeConflict(wcRoot, srcRelPath, srcRootRelPath, dstRelPath);
                            haveRow = stmt.next();
                        }
                        while (SVNWCUtils.relpathDepth(srcRootRelPath) > srcOpDepth) {
                            srcRootRelPath = SVNFileUtil.getFileDir(srcRootRelPath);
                        }
                        if (srcDone.contains(srcRelPath)) {
                            srcDone.add(srcRelPath);
                            SVNSkel conflict = SvnWcDbConflicts.readConflictInternal(wcRoot, localRelPath);
                            if (conflict == null) {
                                SVNWCDb.this.replaceMovedLayer(wcRoot, srcRelPath, dstRelPath, opDepth);
                                this.bumpMovedAway(wcRoot, dstRelPath, SVNWCUtils.relpathDepth(dstRelPath), srcDone, depth, db);
                            }
                        }
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean depthSufficientToBump(File localRelPath, SVNWCDbRoot wcRoot, SVNDepth depth) throws SVNException {
            if (depth == SVNDepth.INFINITY) {
                return true;
            }
            if (depth == SVNDepth.EMPTY) {
                SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_OP_DEPTH_CHILDREN);
                try {
                    stmt.bindf("isi", wcRoot.getWcId(), localRelPath, 0);
                    boolean bl = !stmt.next();
                    return bl;
                }
                finally {
                    stmt.reset();
                }
            }
            if (depth == SVNDepth.FILES) {
                SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HAS_NON_FILE_CHILDREN);
                try {
                    stmt.bindf("is", wcRoot.getWcId(), localRelPath);
                    boolean bl = !stmt.next();
                    return bl;
                }
                finally {
                    stmt.reset();
                }
            }
            if (depth == SVNDepth.IMMEDIATES) {
                SVNSqlJetStatement stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HAS_GRANDCHILDREN);
                try {
                    stmt.bindf("is", wcRoot.getWcId(), localRelPath);
                    boolean bl = !stmt.next();
                    return bl;
                }
                finally {
                    stmt.reset();
                }
            }
            SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
            return false;
        }

        private void bumpMarkTreeConflict(SVNWCDbRoot wcRoot, File moveSrcRootRelPath, File moveSrcOpRootRelPath, File moveDstOpRootRelPath) throws SVNException {
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(wcRoot, moveSrcOpRootRelPath, new ISVNWCDb.WCDbBaseInfo.BaseInfoField[0]);
            long reposId = baseInfo.reposId;
            File newReposRelPath = baseInfo.reposRelPath;
            long newRevision = baseInfo.revision;
            SVNNodeKind newKind = baseInfo.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
            ReposInfo reposInfo = SVNWCDb.this.fetchReposInfo(wcRoot.getSDb(), reposId);
            SVNURL reposRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
            String reposUuid = reposInfo.reposUuid;
            Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(wcRoot, moveDstOpRootRelPath, SVNWCUtils.relpathDepth(moveDstOpRootRelPath), new StructureFields.NodeInfo[0]);
            SVNNodeKind oldKind = depthInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
            long oldRevision = depthInfo.lng(StructureFields.NodeInfo.revision);
            File oldReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
            SVNConflictVersion oldVersion = new SVNConflictVersion(reposRootUrl, SVNFileUtil.getFilePath(oldReposRelPath), oldRevision, oldKind);
            SVNConflictVersion newVersion = new SVNConflictVersion(reposRootUrl, SVNFileUtil.getFilePath(newReposRelPath), newRevision, newKind);
            SVNWCDb.this.markTreeConflict(moveSrcRootRelPath, wcRoot, oldVersion, newVersion, moveDstOpRootRelPath, SVNOperation.UPDATE, oldKind, newKind, oldReposRelPath, SVNConflictReason.MOVED_AWAY, SVNConflictAction.EDIT, moveSrcOpRootRelPath);
        }

        private void bumpNodeRevision(SVNWCDbRoot root, File wcRoot, File localRelPath, long reposId, File newReposRelPath, long newRevision, SVNDepth depth, Collection<File> exludedRelPaths, boolean isRoot, boolean skipWhenDir) throws SVNException {
            Map<String, SVNProperties> nodeIprops;
            if (exludedRelPaths != null && exludedRelPaths.contains(localRelPath)) {
                return;
            }
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(root, localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
            if (baseInfo.updateRoot && baseInfo.kind == ISVNWCDb.SVNWCDbKind.File && !isRoot) {
                return;
            }
            if (skipWhenDir && baseInfo.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                return;
            }
            if (!isRoot && (baseInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent || baseInfo.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded && baseInfo.revision != newRevision)) {
                SVNWCDb.this.removeBase(SVNFileUtil.createFilePath(wcRoot, localRelPath));
                return;
            }
            boolean setReposRelPath = false;
            if (newReposRelPath != null && !baseInfo.reposRelPath.equals(newReposRelPath)) {
                setReposRelPath = true;
            }
            Map<String, SVNProperties> map = nodeIprops = this.iprops != null ? this.iprops.get(root.getAbsPath(localRelPath)) : null;
            if (nodeIprops != null || setReposRelPath || newRevision >= 0L && newRevision != baseInfo.revision) {
                try {
                    SVNWCDb.this.opSetRevAndReposRelpath(root, localRelPath, nodeIprops, newRevision, setReposRelPath, newReposRelPath, this.newReposRootURL, this.newReposUUID);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            if (depth.compareTo(SVNDepth.EMPTY) <= 0 || baseInfo.kind != ISVNWCDb.SVNWCDbKind.Dir || baseInfo.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || baseInfo.status == ISVNWCDb.SVNWCDbStatus.Excluded || baseInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                return;
            }
            SVNDepth depthBelowHere = depth;
            if (depth == SVNDepth.IMMEDIATES || depth == SVNDepth.FILES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            List<String> children = SVNWCDb.this.gatherRepoChildren(root, localRelPath, 0L);
            for (String child : children) {
                File childReposRelPath = null;
                File childLocalRelPath = SVNFileUtil.createFilePath(localRelPath, child);
                if (newReposRelPath != null) {
                    childReposRelPath = SVNFileUtil.createFilePath(newReposRelPath, child);
                }
                this.bumpNodeRevision(root, wcRoot, childLocalRelPath, reposId, childReposRelPath, newRevision, depthBelowHere, exludedRelPaths, false, depth.compareTo(SVNDepth.IMMEDIATES) < 0);
            }
        }
    }

    private class MakeCopy
    implements SVNSqlJetTransaction {
        File localAbspath;
        SVNWCDbDir pdh;
        File localRelpath;
        long opDepth;
        SVNSkel conflicts;
        SVNSkel workItems;

        private MakeCopy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean removeWorking = false;
            boolean addWorkingBaseDeleted = false;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
            stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, 0);
            try {
                boolean haveRow = stmt.next();
                if (haveRow) {
                    ISVNWCDb.SVNWCDbStatus workingStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    long workingOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    assert (workingStatus == ISVNWCDb.SVNWCDbStatus.Normal || workingStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted || workingStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || workingStatus == ISVNWCDb.SVNWCDbStatus.Incomplete);
                    if (workingOpDepth <= this.opDepth) {
                        addWorkingBaseDeleted = true;
                        if (workingStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                            removeWorking = true;
                        }
                    }
                }
            }
            finally {
                stmt.reset();
            }
            if (removeWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
                try {
                    stmt.bindf("is", this.pdh.getWCRoot().getWcId(), this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (addWorkingBaseDeleted) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_BASE);
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.opDepth);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            stmt = db.getStatement(SVNWCDbStatements.INSERT_WORKING_NODE_FROM_BASE_COPY);
            try {
                stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.opDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            List<String> children = SVNWCDb.this.gatherRepoChildren(this.pdh.getWCRoot(), this.localRelpath, 0L);
            for (String name : children) {
                MakeCopy cbt = new MakeCopy();
                cbt.localAbspath = SVNFileUtil.createFilePath(this.localAbspath, name);
                DirParsedInfo parseDir = SVNWCDb.this.parseDir(cbt.localAbspath, SVNSqlJetDb.Mode.ReadWrite);
                cbt.pdh = parseDir.wcDbDir;
                cbt.localRelpath = parseDir.localRelPath;
                SVNWCDb.verifyDirUsable(cbt.pdh);
                cbt.opDepth = this.opDepth;
                cbt.transaction(db);
            }
            this.pdh.flushEntries(this.localAbspath);
            if (this.conflicts != null) {
                SVNWCDb.this.markConflictInternal(this.pdh.getWCRoot(), this.localRelpath, this.conflicts);
            }
            SVNWCDb.addWorkItems(this.pdh.getWCRoot().getSDb(), this.workItems);
        }
    }

    private class StartDirectoryUpdate
    implements SVNSqlJetTransaction {
        public long wcId;
        public File localRelpath;
        public long newRevision;
        public File newReposRelpath;

        private StartDirectoryUpdate() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.UPDATE_BASE_NODE_PRESENCE_REVNUM_AND_REPOS_PATH);
            try {
                stmt.bindf("istis", this.wcId, this.localRelpath, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.Incomplete), this.newRevision, this.newReposRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    public static class ReposInfo {
        public String reposRootUrl;
        public String reposUuid;
    }

    private static class MovedToAbs {
        public File movedToAbsPath;
        public File movedToOpRootAbsPath;

        private MovedToAbs() {
        }
    }

    private static class MovedTo {
        public File movedToRelPath;
        public File movedToOpRootRelPath;
        public boolean scan;

        private MovedTo() {
        }
    }

    public class BaseRemove
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot root;
        public long wcId;
        public File localRelpath;
        public boolean keepAsWorking;
        private boolean queueDeletes;
        private boolean removeLocks;
        public SVNSkel conflict;
        public SVNSkel workItems;
        public long notPresentRevision;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            boolean keepWorking;
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(this.root, this.localRelpath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
            if (baseInfo.status == ISVNWCDb.SVNWCDbStatus.Normal && this.keepAsWorking) {
                SVNWCDb.this.opMakeCopy(SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelpath), null, null);
                keepWorking = true;
            } else {
                SVNSqlJetStatement selectWorkingNodeStatement = db.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
                try {
                    selectWorkingNodeStatement.bindf("is", this.wcId, this.localRelpath);
                    keepWorking = selectWorkingNodeStatement.next();
                }
                finally {
                    selectWorkingNodeStatement.reset();
                }
            }
            if (this.removeLocks) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_LOCK_RECURSIVELY);
                try {
                    stmt.bindf("is", baseInfo.reposId, baseInfo.reposRelPath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (!keepWorking && this.queueDeletes && (baseInfo.status == ISVNWCDb.SVNWCDbStatus.Normal || baseInfo.status == ISVNWCDb.SVNWCDbStatus.Incomplete)) {
                SVNSkel workItem;
                File localAbsPath = SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelpath);
                if (baseInfo.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                    SVNSqlJetStatement selectWorkingNodeStatement = db.getStatement(SVNWCDbStatements.SELECT_BASE_PRESENT);
                    try {
                        selectWorkingNodeStatement.bindf("is", this.wcId, this.localRelpath);
                        while (selectWorkingNodeStatement.next()) {
                            String nodeRelpath = selectWorkingNodeStatement.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
                            ISVNWCDb.SVNWCDbKind nodeKind = SvnWcDbStatementUtil.parseKind(selectWorkingNodeStatement.getColumnString(SVNWCDbSchema.NODES__Fields.kind));
                            File nodeAbsPath = SVNFileUtil.createFilePath(this.root.getAbsPath(), nodeRelpath);
                            workItem = nodeKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNWCContext.wqBuildDirRemove(SVNWCDb.this, this.root.getAbsPath(), nodeAbsPath, false) : SVNWCContext.wqBuildFileRemove(SVNWCDb.this, this.root.getAbsPath(), nodeAbsPath);
                            SVNWCDb.addWorkItems(this.root.getSDb(), workItem);
                        }
                    }
                    finally {
                        selectWorkingNodeStatement.reset();
                    }
                    workItem = SVNWCContext.wqBuildDirRemove(SVNWCDb.this, this.root.getAbsPath(), localAbsPath, false);
                } else {
                    workItem = SVNWCContext.wqBuildFileRemove(SVNWCDb.this, this.root.getAbsPath(), localAbsPath);
                }
                SVNWCDb.addWorkItems(this.root.getSDb(), workItem);
            }
            if (!keepWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (!this.keepAsWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_FOR_BASE_RECURSIVE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (this.conflict != null) {
                stmt = db.getStatement(SVNWCDbStatements.SELECT_MOVED_OUTSIDE);
                try {
                    stmt.bindf("isi", this.wcId, this.localRelpath, SVNWCUtils.relpathDepth(this.localRelpath));
                    boolean haveRow = stmt.next();
                    while (haveRow) {
                        File movedToRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                        SVNWCDb.clearMovedHere(movedToRelpath, this.root);
                        haveRow = stmt.next();
                    }
                }
                finally {
                    stmt.reset();
                }
            }
            if (keepWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_WORKING_BASE_DELETE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            stmt = db.getStatement(SVNWCDbStatements.DELETE_WORKING_RECURSIVE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.DELETE_BASE_RECURSIVE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.DELETE_BASE_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            this.retractParentDelete(db);
            if (!keepWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (SVNRevision.isValidRevisionNumber(this.notPresentRevision)) {
                InsertBase ibb = new InsertBase();
                ibb.reposId = baseInfo.reposId;
                ibb.status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                ibb.kind = baseInfo.kind;
                ibb.reposRelpath = baseInfo.reposRelPath;
                ibb.revision = this.notPresentRevision;
                ibb.children = null;
                ibb.depth = SVNDepth.UNKNOWN;
                ibb.checksum = null;
                ibb.target = null;
                ibb.localRelpath = this.localRelpath;
                ibb.wcRoot = this.root;
                ibb.wcId = this.wcId;
                ibb.transaction(db);
            }
            SVNWCDb.addWorkItems(this.root.getSDb(), this.workItems);
            if (this.conflict != null) {
                SVNWCDb.this.markConflictInternal(this.root, this.localRelpath, this.conflict);
            }
        }

        private void retractParentDelete(SVNSqlJetDb db) throws SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class GatheredChildItem
    extends ISVNWCDb.SVNWCDbInfo {
        public int layersCount;
        public long opDepth;

        private GatheredChildItem() {
        }
    }

    private class GatherChildren
    implements SVNSqlJetTransaction {
        Map<String, ISVNWCDb.SVNWCDbInfo> nodes;
        Set<String> conflicts;
        File dirRelPath;
        SVNWCDbRoot wcRoot;

        private GatherChildren() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_NODE_CHILDREN_INFO);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.dirRelPath);
                boolean haveRow = stmt.next();
                while (haveRow) {
                    File childRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                    String name = SVNFileUtil.getFileName(childRelPath);
                    GatheredChildItem childItem = (GatheredChildItem)this.nodes.get(name);
                    boolean newChild = false;
                    if (childItem == null) {
                        newChild = true;
                        childItem = new GatheredChildItem();
                    }
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    if (newChild || opDepth > childItem.opDepth) {
                        childItem.opDepth = opDepth;
                        childItem.kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                        childItem.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                        if (opDepth != 0L) {
                            childItem.incomplete = childItem.status == ISVNWCDb.SVNWCDbStatus.Incomplete;
                            childItem.status = SVNWCDb.getWorkingStatus(childItem.status);
                        }
                        if (opDepth != 0L) {
                            childItem.revnum = -1L;
                            childItem.reposRelpath = null;
                        } else {
                            childItem.revnum = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                            childItem.reposRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                        }
                        if (opDepth != 0L || SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            childItem.reposRootUrl = null;
                            childItem.reposUuid = null;
                        } else {
                            long reposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                            if (reposInfo.rootUrl == null) {
                                SVNWCDb.fetchReposInfo(reposInfo, db, reposId);
                            }
                            childItem.reposRootUrl = reposInfo.rootUrl;
                            childItem.reposUuid = reposInfo.uuid;
                        }
                        childItem.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision);
                        childItem.changedDate = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                        childItem.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author);
                        if (childItem.kind != ISVNWCDb.SVNWCDbKind.Dir) {
                            childItem.depth = SVNDepth.UNKNOWN;
                        } else {
                            childItem.depth = SvnWcDbStatementUtil.getColumnDepth(stmt, SVNWCDbSchema.NODES__Fields.depth);
                            if (newChild) {
                                childItem.locked = SVNWCDb.this.isWCLocked(this.wcRoot, childRelPath);
                            }
                        }
                        childItem.recordedModTime = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.last_mod_time);
                        childItem.recordedSize = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.translated_size);
                        childItem.hasChecksum = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                        childItem.copied = opDepth > 0L && !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_path);
                        boolean bl = childItem.hadProps = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.properties) && SvnWcDbStatementUtil.getColumnBlob(stmt, SVNWCDbSchema.NODES__Fields.properties).length > 2;
                        if (childItem.hadProps) {
                            SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                            boolean bl2 = childItem.special = properties.getSVNPropertyValue("svn:special") != null;
                        }
                        childItem.opRoot = opDepth == 0L ? false : opDepth == (long)SVNWCUtils.relpathDepth(childRelPath);
                        childItem.format = db.getDb().getOptions().getUserVersion();
                        this.nodes.put(name, childItem);
                    }
                    if (opDepth == 0L) {
                        childItem.haveBase = true;
                        SVNSqlJetStatement lockStmt = stmt.getJoinedStatement(SVNWCDbSchema.LOCK);
                        if (lockStmt != null && !lockStmt.eof()) {
                            childItem.lock = new ISVNWCDb.SVNWCDbLock();
                            childItem.lock.token = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token);
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                                childItem.lock.owner = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                                childItem.lock.comment = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                                childItem.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date));
                            }
                        }
                        childItem.fileExternal = stmt.getColumnBoolean(SVNWCDbSchema.NODES__Fields.file_external);
                    } else {
                        File movedToRelpath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.moved_to);
                        if (movedToRelpath != null) {
                            childItem.movedToAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), movedToRelpath);
                        }
                        childItem.movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here);
                        ++childItem.layersCount;
                        childItem.haveMoreWork = childItem.layersCount > 1;
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            stmt = this.wcRoot.getFormat() == 29 ? db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO_17) : db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.dirRelPath);
                while (stmt.next()) {
                    File childRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
                    String name = SVNFileUtil.getFileName(childRelPath);
                    GatheredChildItem childItem = (GatheredChildItem)this.nodes.get(name);
                    if (childItem == null) {
                        childItem = new GatheredChildItem();
                        childItem.status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                    }
                    childItem.changelist = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    boolean bl = childItem.propsMod = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                    if (childItem.propsMod) {
                        SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                        childItem.special = properties.getSVNPropertyValue("svn:special") != null;
                    }
                    boolean bl3 = childItem.conflicted = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                    if (!childItem.conflicted) continue;
                    this.conflicts.add(name);
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private class SetTreeConflict
    implements SVNSqlJetTransaction {
        public File localRelpath;
        public long wcId;
        public File parentRelpath;
        public SVNTreeConflictDescription treeConflict;

        private SetTreeConflict() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean haveRow;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            String treeConflictData = this.treeConflict != null ? SVNTreeConflictUtil.getSingleTreeConflictData(this.treeConflict) : null;
            try {
                stmt = haveRow ? db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_TREE_CONFLICTS) : db.getStatement(SVNWCDbStatements.INSERT_ACTUAL_TREE_CONFLICTS);
                stmt.bindf("iss", this.wcId, this.localRelpath, treeConflictData);
                if (!haveRow) {
                    stmt.bindString(4, SVNFileUtil.getFilePath(this.parentRelpath));
                } else {
                    stmt.bindNull(4);
                }
                stmt.done();
            }
            finally {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            if (treeConflictData == null) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_EMPTY);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    private class SetProperties
    implements SVNSqlJetTransaction {
        SVNProperties props;
        SVNWCDbDir pdh;
        File localRelpath;
        SVNSkel conflict;
        SVNSkel workItems;
        boolean clearRecordedInfo;

        private SetProperties() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNProperties propDiffs;
            SVNProperties pristineProps = SvnWcDbProperties.readPristineProperties(this.pdh.getWCRoot(), this.localRelpath);
            if (this.props != null && pristineProps != null && (propDiffs = SVNWCUtils.propDiffs(this.props, pristineProps)).isEmpty()) {
                this.props = null;
            }
            SVNWCDb.this.setActualProperties(db, this.pdh.getWCRoot().getWcId(), this.localRelpath, this.props);
            if (this.clearRecordedInfo) {
                RecordFileinfo rfi = new RecordFileinfo();
                rfi.lastModTime = 0L;
                rfi.translatedSize = -1L;
                rfi.localRelpath = this.localRelpath;
                rfi.wcRoot = this.pdh.getWCRoot();
                rfi.transaction(db);
            }
            SVNWCDb.addWorkItems(db, this.workItems);
            if (this.conflict != null) {
                SVNWCDb.this.markConflictInternal(this.pdh.getWCRoot(), this.localRelpath, this.conflict);
            }
        }
    }

    public static class DirParsedInfo {
        public SVNWCDbDir wcDbDir;
        public File localRelPath;
    }

    private class RecordFileinfo
    implements SVNSqlJetTransaction {
        public long lastModTime;
        public long translatedSize;
        public File localRelpath;
        public SVNWCDbRoot wcRoot;

        private RecordFileinfo() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            try {
                db.beginTransaction(SqlJetTransactionMode.WRITE);
                ISqlJetTable table = db.getDb().getTable(SVNWCDbSchema.NODES.name());
                ISqlJetCursor c = table.lookup(null, this.wcRoot.getWcId(), SVNFileUtil.getFilePath(this.localRelpath));
                c = c.reverse();
                if (!c.eof()) {
                    HashMap<String, Object> updateValues = new HashMap<String, Object>();
                    updateValues.put(SVNWCDbSchema.NODES__Fields.translated_size.toString(), this.translatedSize);
                    updateValues.put(SVNWCDbSchema.NODES__Fields.last_mod_time.toString(), this.lastModTime);
                    c.updateByFieldNames(updateValues);
                }
                c.close();
                db.commit();
            }
            catch (SqlJetException e) {
                db.rollback();
                throw e;
            }
            catch (SVNException e) {
                db.rollback();
                throw e;
            }
        }
    }

    public class InsertWorking
    implements SVNSqlJetTransaction {
        public ISVNWCDb.SVNWCDbStatus status;
        public ISVNWCDb.SVNWCDbKind kind;
        public File reposRelpath;
        public SVNProperties props;
        public long changedRev = -1L;
        public SVNDate changedDate;
        public String changedAuthor;
        public List<File> children;
        public SVNDepth depth = SVNDepth.INFINITY;
        public SvnChecksum checksum;
        public File target;
        public SVNSkel workItems;
        public SVNWCDbRoot wcRoot;
        public File localRelpath;
        public File originalReposRelPath;
        public long originalReposId;
        public long originalRevision;
        public long opDepth;
        public long notPresentOpDepth;
        public SVNSkel conflict;
        public boolean movedHere;
        public boolean updateActualProps;
        public SVNProperties newActualProps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            long wcId = this.wcRoot.getWcId();
            File parentRelpath = SVNFileUtil.getFileDir(this.localRelpath);
            File movedToRelPath = null;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_MOVED_TO);
            try {
                stmt.bindf("isi", wcId, this.localRelpath, this.opDepth);
                boolean haveRow = stmt.next();
                if (haveRow) {
                    movedToRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                }
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
            try {
                stmt.bindf("isisnnntstrisnnnnnsns", wcId, this.localRelpath, this.opDepth, parentRelpath, SvnWcDbStatementUtil.getPresenceText(this.status), this.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.asString(this.depth) : null, SvnWcDbStatementUtil.getKindText(this.kind), this.changedRev, this.changedDate, this.changedAuthor, this.kind == ISVNWCDb.SVNWCDbKind.Symlink ? this.target : null, movedToRelPath);
                if (this.movedHere) {
                    stmt.bindLong(8, 1L);
                }
                if (this.kind == ISVNWCDb.SVNWCDbKind.File) {
                    stmt.bindChecksum(14, this.checksum);
                }
                if (this.originalReposRelPath != null) {
                    stmt.bindLong(5, this.originalReposId);
                    stmt.bindString(6, SVNFileUtil.getFilePath(this.originalReposRelPath));
                    stmt.bindLong(7, this.originalRevision);
                }
                assert (this.status == ISVNWCDb.SVNWCDbStatus.Normal || this.status == ISVNWCDb.SVNWCDbStatus.Incomplete || this.props == null);
                stmt.bindProperties(15, this.props);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir && this.children != null) {
                SVNWCDb.this.insertIncompleteChildren(db, wcId, this.localRelpath, -1L, null, this.originalRevision, this.children, this.opDepth);
            }
            if (this.updateActualProps) {
                SVNProperties diffs;
                SVNProperties baseProps = this.props;
                SVNProperties newActualProps = this.newActualProps;
                if (baseProps != null && newActualProps != null && baseProps.size() == newActualProps.size() && (diffs = newActualProps.compareTo(baseProps)).size() == 0) {
                    newActualProps = null;
                }
                SVNWCDb.this.setActualProperties(db, wcId, this.localRelpath, newActualProps);
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                stmt = db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CLEAR_CHANGELIST);
                try {
                    stmt.bindf("is", wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_EMPTY);
                try {
                    stmt.bindf("is", wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (this.notPresentOpDepth > 0L && this.notPresentOpDepth < this.opDepth) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
                try {
                    stmt.bindf("isisisrtnt", wcId, this.localRelpath, this.notPresentOpDepth, parentRelpath, this.originalReposId, this.originalReposRelPath, this.originalRevision, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.NotPresent), SvnWcDbStatementUtil.getKindText(this.kind));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            SVNWCDb.addWorkItems(db, this.workItems);
            if (this.conflict != null) {
                SVNWCDb.this.markConflictInternal(this.wcRoot, this.localRelpath, this.conflict);
            }
        }
    }

    public class InsertBase
    implements SVNSqlJetTransaction {
        public Map<String, SVNProperties> iprops;
        public ISVNWCDb.SVNWCDbStatus status;
        public ISVNWCDb.SVNWCDbKind kind;
        public long reposId = -1L;
        public File reposRelpath;
        public long revision = -1L;
        public SVNURL reposRootURL;
        public String reposUUID;
        public SVNProperties props;
        public long changedRev = -1L;
        public SVNDate changedDate;
        public String changedAuthor;
        public SVNProperties davCache;
        public List<File> children;
        public SVNDepth depth = SVNDepth.INFINITY;
        public SvnChecksum checksum;
        public File target;
        public boolean fileExternal;
        public SVNSkel conflict;
        public boolean updateActualProps;
        public SVNProperties actualProps;
        public boolean insertBaseDeleted;
        public boolean keepRecordedInfo;
        public boolean deleteWorking;
        public SVNSkel workItems;
        public long wcId;
        public File localRelpath;
        public SVNWCDbRoot wcRoot;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            long recordedSize = -1L;
            long recordedModTime = 0L;
            File parentRelpath = SVNFileUtil.getFileDir(this.localRelpath);
            if (this.reposId == -1L) {
                this.reposId = SVNWCDb.this.createReposId(db, this.reposRootURL, this.reposUUID);
            }
            if (this.keepRecordedInfo) {
                stmt = db.getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    boolean haveRow = stmt.next();
                    if (haveRow) {
                        recordedSize = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.translated_size);
                        recordedModTime = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.last_mod_time);
                    }
                }
                finally {
                    stmt.reset();
                }
            }
            stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
            try {
                stmt.bindf("isisisrtstrisnnnnns", this.wcId, this.localRelpath, 0, parentRelpath, this.reposId, this.reposRelpath, this.revision, SvnWcDbStatementUtil.getPresenceText(this.status), this.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.asString(this.depth) : null, SvnWcDbStatementUtil.getKindText(this.kind), this.changedRev, this.changedDate, this.changedAuthor, this.kind == ISVNWCDb.SVNWCDbKind.Symlink ? this.target : null);
                if (this.kind == ISVNWCDb.SVNWCDbKind.File) {
                    stmt.bindChecksum(14, this.checksum);
                    if (recordedSize != -1L) {
                        stmt.bindLong(16, recordedSize);
                        stmt.bindLong(17, recordedModTime);
                    } else {
                        stmt.bindNull(16);
                        stmt.bindNull(17);
                    }
                } else {
                    stmt.bindNull(14);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                stmt.bindProperties(15, this.props);
                if (this.davCache != null) {
                    stmt.bindProperties(18, this.davCache);
                } else {
                    stmt.bindNull(18);
                }
                if (this.fileExternal) {
                    stmt.bindString(20, "1");
                } else {
                    stmt.bindNull(20);
                }
                stmt.bindIProperties(23, this.iprops);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (this.updateActualProps) {
                SVNProperties diff;
                SVNProperties baseProps = this.props;
                SVNProperties newActualProps = this.actualProps;
                if (baseProps != null && newActualProps != null && baseProps.size() == newActualProps.size() && (diff = newActualProps.compareTo(baseProps)).size() == 0) {
                    newActualProps = null;
                }
                SVNWCDb.this.setActualProperties(db, this.wcId, this.localRelpath, newActualProps);
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir && this.children != null) {
                SVNWCDb.this.insertIncompleteChildren(db, this.wcId, this.localRelpath, this.reposId, this.reposRelpath, this.revision, this.children, 0L);
            }
            if (parentRelpath != null) {
                if (!(this.localRelpath == null || this.status != ISVNWCDb.SVNWCDbStatus.Normal && this.status != ISVNWCDb.SVNWCDbStatus.Incomplete || this.fileExternal)) {
                    SVNWCDb.this.extendParentDelete(db, this.wcId, this.localRelpath, this.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, 0);
                } else if (this.status == ISVNWCDb.SVNWCDbStatus.NotPresent || this.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || this.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    SVNWCDb.this.retractParentDelete(db, this.wcId, this.localRelpath, 0);
                }
            }
            if (this.deleteWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (this.insertBaseDeleted) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_BASE);
                try {
                    stmt.bindf("isi", this.wcId, this.localRelpath, SVNWCUtils.relpathDepth(this.localRelpath));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            SVNWCDb.addWorkItems(db, this.workItems);
            if (this.conflict != null) {
                SVNWCDb.this.markConflictInternal(this.wcRoot, this.localRelpath, this.conflict);
            }
        }
    }

    private class InsertLock
    implements SVNSqlJetTransaction {
        public File localAbsPath;
        public ISVNWCDb.SVNWCDbLock lock;

        private InsertLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(this.localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.INSERT_LOCK);
            try {
                stmt.bindf("issssi", baseInfo.reposId, baseInfo.reposRelPath, this.lock.token, this.lock.owner != null ? this.lock.owner : null, this.lock.comment != null ? this.lock.comment : null, this.lock.date != null ? this.lock.date : null);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class MovedNode {
        public File localRelPath;
        public File movedToRelPath;
        public int opDepth;
        public int movedFromDepth;

        private MovedNode() {
        }
    }

    private static class ResolveMovedFrom {
        File movedFromRelPath;
        int movedFromOpDepth = -1;

        private ResolveMovedFrom() {
        }
    }

    private class Delete
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot root;
        public File localRelPath;
        public long deleteDepth;
        public ISVNEventHandler eventHandler;
        public File movedToRelPath;
        public boolean deleteDirExternals;
        public SVNSkel workItems;
        public SVNSkel conflict;

        private Delete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            int deleteOpDepth = SVNWCUtils.relpathDepth(this.localRelPath);
            SVNSqlJetStatement stmt = this.root.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            try {
                boolean opRoot;
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                boolean haveRow = stmt.next();
                if (!haveRow) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelPath));
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                int workingOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                ISVNWCDb.SVNWCDbStatus status = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                ISVNWCDb.SVNWCDbKind kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                boolean addWork = false;
                int keepOpDepth = 0;
                if (workingOpDepth < deleteOpDepth) {
                    opRoot = false;
                    addWork = true;
                    keepOpDepth = workingOpDepth;
                } else {
                    opRoot = true;
                    haveRow = stmt.next();
                    if (haveRow) {
                        int belowOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                        ISVNWCDb.SVNWCDbStatus belowStatus = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                        if (belowStatus != ISVNWCDb.SVNWCDbStatus.NotPresent && belowStatus != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                            addWork = true;
                            keepOpDepth = belowOpDepth;
                        } else {
                            keepOpDepth = 0;
                        }
                    } else {
                        keepOpDepth = -1;
                    }
                }
                stmt.reset();
                if (workingOpDepth != 0) {
                    status = SVNWCDb.this.convertToWorkingStatus(status);
                }
                if (status == ISVNWCDb.SVNWCDbStatus.Deleted || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                    return;
                }
                if (status == ISVNWCDb.SVNWCDbStatus.Normal && kind == ISVNWCDb.SVNWCDbKind.Dir) {
                    stmt.reset();
                    stmt = this.root.getSDb().getStatement(SVNWCDbStatements.HAS_SERVER_EXCLUDED_DESCENDANTS);
                    stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                    haveRow = stmt.next();
                    if (haveRow) {
                        String absentPath = stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot delete ''{0}'' as ''{1}'' is excluded by server", SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelPath), SVNFileUtil.createFilePath(this.root.getAbsPath(), absentPath));
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    }
                } else if (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot delete ''{0}'' as it is excluded by server", (Object)SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelPath));
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                } else if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot delete ''{0}'' as it is excluded", (Object)SVNFileUtil.createFilePath(this.root.getAbsPath(), this.localRelPath));
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                ArrayList<MovedNode> movedNodes = null;
                if (this.movedToRelPath != null) {
                    movedNodes = new ArrayList<MovedNode>();
                    int movedOpDepth = 0;
                    File movedFromRelPath = null;
                    if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                        Structure<StructureFields.AdditionInfo> additionInfoStructure = SvnWcDbShared.scanAddition(this.root, this.localRelPath, StructureFields.AdditionInfo.status, StructureFields.AdditionInfo.movedFromRelPath, StructureFields.AdditionInfo.movedFromOpDepth);
                        status = (ISVNWCDb.SVNWCDbStatus)((Object)additionInfoStructure.get(StructureFields.AdditionInfo.status));
                        movedFromRelPath = (File)additionInfoStructure.get(StructureFields.AdditionInfo.movedFromRelPath);
                        movedOpDepth = (int)additionInfoStructure.lng(StructureFields.AdditionInfo.movedFromOpDepth);
                    }
                    if (opRoot && movedFromRelPath != null) {
                        File part = SVNFileUtil.skipAncestor(this.localRelPath, movedFromRelPath);
                        MovedNode movedNode = new MovedNode();
                        movedNode.localRelPath = part == null ? movedFromRelPath : SVNFileUtil.createFilePath(this.movedToRelPath, part);
                        movedNode.opDepth = movedOpDepth;
                        movedNode.movedToRelPath = this.movedToRelPath;
                        movedNode.movedFromDepth = -1;
                        movedNodes.add(movedNode);
                    } else if (!(opRoot || status != ISVNWCDb.SVNWCDbStatus.Normal && status != ISVNWCDb.SVNWCDbStatus.Copied && status != ISVNWCDb.SVNWCDbStatus.MovedHere)) {
                        MovedNode movedNode = new MovedNode();
                        movedNode.localRelPath = this.localRelPath;
                        movedNode.opDepth = deleteOpDepth;
                        movedNode.movedToRelPath = this.movedToRelPath;
                        movedNode.movedFromDepth = -1;
                        movedNodes.add(movedNode);
                    }
                    stmt.reset();
                    stmt = this.root.getSDb().getStatement(SVNWCDbStatements.UPDATE_MOVED_TO_DESCENDANTS);
                    stmt.bindf("iss", this.root.getWcId(), this.localRelPath, this.movedToRelPath);
                    stmt.done();
                }
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.SELECT_MOVED_FOR_DELETE);
                stmt.bindf("isi", this.root.getWcId(), this.localRelPath, deleteOpDepth);
                haveRow = stmt.next();
                while (haveRow) {
                    File childRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                    File mvToRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.moved_to));
                    int childOpDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    int movedFromDepth = -1;
                    boolean fixUp = false;
                    if (this.movedToRelPath == null && SVNFileUtil.skipAncestor(this.localRelPath, mvToRelPath) == null) {
                        int movedHereDepth = ((SVNWCDbSelectMovedForDelete)stmt).getMovedHereDepth();
                        if (movedHereDepth >= deleteOpDepth) {
                            fixUp = true;
                            movedFromDepth = movedHereDepth;
                        } else {
                            fixUp = true;
                            childOpDepth = deleteOpDepth;
                        }
                    } else if (this.movedToRelPath != null) {
                        if (deleteOpDepth == childOpDepth) {
                            fixUp = true;
                        } else if (childOpDepth >= deleteOpDepth && SVNFileUtil.skipAncestor(this.localRelPath, mvToRelPath) == null && (childRelPath = SVNFileUtil.skipAncestor(this.localRelPath, childRelPath)) != null) {
                            childRelPath = SVNFileUtil.createFilePath(this.movedToRelPath, childRelPath);
                            childOpDepth = childOpDepth > deleteOpDepth && SVNFileUtil.skipAncestor(this.localRelPath, childRelPath) != null ? deleteOpDepth : SVNWCUtils.relpathDepth(childRelPath);
                            fixUp = true;
                        }
                    }
                    if (fixUp) {
                        MovedNode mn = new MovedNode();
                        mn.localRelPath = childRelPath;
                        mn.movedToRelPath = mvToRelPath;
                        mn.opDepth = childOpDepth;
                        mn.movedFromDepth = movedFromDepth;
                        if (movedNodes == null) {
                            movedNodes = new ArrayList();
                        }
                        movedNodes.add(mn);
                    }
                    haveRow = stmt.next();
                }
                stmt.reset();
                if (movedNodes != null) {
                    Iterator iterator2 = movedNodes.iterator();
                    while (iterator2.hasNext()) {
                        MovedNode movedNode = (MovedNode)iterator2.next();
                        if (movedNode.movedFromDepth <= 0) continue;
                        ResolveMovedFrom resolveMovedFrom = SVNWCDb.this.resolveMovedFrom(this.root, this.localRelPath, movedNode.localRelPath, movedNode.movedFromDepth);
                        movedNode.localRelPath = resolveMovedFrom.movedFromRelPath;
                        movedNode.opDepth = resolveMovedFrom.movedFromOpDepth;
                        if (movedNode.localRelPath != null) continue;
                        iterator2.remove();
                    }
                }
                if (this.movedToRelPath == null) {
                    stmt.reset();
                    stmt = this.root.getSDb().getStatement(SVNWCDbStatements.CLEAR_MOVED_TO_DESCENDANTS);
                    stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                    stmt.done();
                    if (opRoot) {
                        stmt.reset();
                        stmt = this.root.getSDb().getStatement(SVNWCDbStatements.CLEAR_MOVED_TO_FROM_DEST);
                        stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                        stmt.done();
                    }
                }
                stmt = new SVNWCDbCreateSchema(this.root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DELETE_LIST, -1, false);
                try {
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (this.eventHandler != null) {
                    stmt.reset();
                    stmt = this.root.getSDb().getStatement(SVNWCDbStatements.INSERT_DELETE_LIST);
                    stmt.bindf("isi", this.root.getWcId(), this.localRelPath, workingOpDepth);
                    stmt.done();
                }
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_NODES_ABOVE_DEPTH_RECURSIVE);
                stmt.bindf("isi", this.root.getWcId(), this.localRelPath, deleteOpDepth);
                stmt.done();
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                stmt.done();
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                stmt.done();
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN_RECURSIVE);
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                stmt.done();
                if (addWork) {
                    stmt.reset();
                    stmt = this.root.getSDb().getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_NODE_RECURSIVE);
                    stmt.bindf("isii", this.root.getWcId(), this.localRelPath, keepOpDepth, deleteOpDepth);
                    stmt.done();
                }
                if (movedNodes != null) {
                    for (MovedNode movedNode : movedNodes) {
                        SVNWCDb.this.deleteUpdateMovedTo(this.root, movedNode.localRelPath, movedNode.opDepth, movedNode.movedToRelPath);
                    }
                }
                stmt.reset();
                stmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_FILE_EXTERNALS);
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                stmt.done();
                stmt.reset();
                stmt = this.root.getSDb().getStatement(this.deleteDirExternals ? SVNWCDbStatements.DELETE_EXTERNAL_REGISTRATIONS : SVNWCDbStatements.DELETE_FILE_EXTERNAL_REGISTRATIONS);
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                stmt.done();
                SVNWCDb.addWorkItems(this.root.getSDb(), this.workItems);
                if (this.conflict != null) {
                    SVNWCDb.this.markConflictInternal(this.root, this.localRelPath, this.conflict);
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class CreateDbInfo {
        public SVNSqlJetDb sDb;
        public long reposId;
        public long wcId;

        private CreateDbInfo() {
        }
    }
}

