/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbPristines
extends SvnWcDbShared {
    private static final String PRISTINE_STORAGE_EXT = ".svn-base";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupPristine(SVNWCDbRoot root, File localAbsPath) throws SVNException {
        SVNSqlJetStatement selectList = root.getSDb().getStatement(SVNWCDbStatements.SELECT_UNREFERENCED_PRISTINES);
        try {
            while (selectList.next()) {
                SvnChecksum sha1_checksum = SvnChecksum.fromString(selectList.getColumnString(SVNWCDbSchema.PRISTINE__Fields.checksum));
                SvnWcDbPristines.removePristineIfUnreferenced(root, localAbsPath, sha1_checksum);
            }
        }
        finally {
            selectList.reset();
        }
    }

    private static void removePristineIfUnreferenced(SVNWCDbRoot root, File localAbsPath, SvnChecksum sha1_checksum) throws SVNException {
        RemoveUnreferencedPristine rup = new RemoveUnreferencedPristine();
        rup.sha1_checksum = sha1_checksum;
        rup.pristineAbsPath = SvnWcDbPristines.getPristineFileName(root, sha1_checksum, false);
        rup.root = root;
        root.getSDb().runTransaction(rup);
    }

    public static File getPristineTempDir(SVNWCDbRoot root, File wcRootAbsPath) throws SVNException {
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(root.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "");
    }

    public static File getPristineFuturePath(SVNWCDbRoot root, SvnChecksum sha1Checksum) {
        return SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
    }

    public static File getPristineFileName(SVNWCDbRoot root, SvnChecksum sha1Checksum, boolean createSubdir) {
        assert (root != null);
        assert (sha1Checksum != null);
        assert (sha1Checksum.getKind() == SvnChecksum.Kind.sha1);
        File base_dir_abspath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(root.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "pristine");
        String hexdigest = sha1Checksum.getDigest();
        assert (hexdigest != null);
        String subdir = hexdigest.substring(0, 2);
        if (createSubdir) {
            File subdirAbspath = SVNFileUtil.createFilePath(base_dir_abspath, subdir);
            subdirAbspath.mkdirs();
        }
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(base_dir_abspath, subdir), hexdigest + PRISTINE_STORAGE_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPristine(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        File pristineAbspath;
        SVNNodeKind kindOnDisk;
        boolean haveRow = false;
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_MD5_CHECKSUM);
        stmt.bindf("s", sha1Checksum);
        try {
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow && (kindOnDisk = SVNFileType.getNodeKind(SVNFileType.getType(pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false)))) != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with checksum ''{0}'' was found in the DB but not on disk", (Object)sha1Checksum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return haveRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SvnChecksum getPristineSHA1(SVNWCDbRoot root, SvnChecksum md5Checksum) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_SHA1_CHECKSUM);
        try {
            stmt.bindChecksum(1, md5Checksum);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with MD5 checksum ''{0}'' not found", (Object)md5Checksum.toString());
                SVNErrorManager.error(err, SVNLogType.WC);
                SvnChecksum svnChecksum = null;
                return svnChecksum;
            }
            SvnChecksum sha1_checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.PRISTINE__Fields.checksum);
            assert (sha1_checksum.getKind() == SvnChecksum.Kind.sha1);
            SvnChecksum svnChecksum = sha1_checksum;
            return svnChecksum;
        }
        finally {
            stmt.reset();
        }
    }

    public static File getPristinePath(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        boolean present = SvnWcDbPristines.checkPristine(root, sha1Checksum);
        if (!present) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "Pristine text not found");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePristine(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        boolean haveRow;
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.LOOK_FOR_WORK);
        try {
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            return;
        }
        SvnWcDbPristines.pristineRemove(root, sha1Checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pristineRemove(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.DELETE_PRISTINE);
        try {
            stmt.bindChecksum(1, sha1Checksum);
            if (stmt.done() != 0L) {
                File pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, true);
                SVNFileUtil.deleteFile(pristineAbspath);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installPristine(SVNWCDbRoot root, File tempfileAbspath, SvnChecksum sha1Checksum, SvnChecksum md5Checksum) throws SVNException {
        File pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, true);
        if (pristineAbspath.isFile()) {
            SVNFileUtil.deleteFile(tempfileAbspath);
            return;
        }
        SVNFileUtil.rename(tempfileAbspath, pristineAbspath);
        long size = pristineAbspath.length();
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.INSERT_PRISTINE);
        try {
            stmt.bindChecksum(1, sha1Checksum);
            stmt.bindChecksum(2, md5Checksum);
            stmt.bindLong(3, size);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    public static InputStream readPristine(SVNWCDbRoot root, File wcRootAbsPath, SvnChecksum sha1Checksum) throws SVNException {
        File pristine_abspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
        return SVNFileUtil.openFileForReading(pristine_abspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixPristinesRefCount(SVNWCDbRoot root) throws SVNException {
        HashMap<String, Long> refcountTable = new HashMap<String, Long>();
        SvnWcDbPristines.begingWriteTransaction(root);
        try {
            String checksum;
            ISqlJetTable nodesTable = root.getSDb().getDb().getTable(SVNWCDbSchema.NODES.toString());
            try (ISqlJetCursor cursor = nodesTable.open();){
                while (!cursor.eof()) {
                    long opDepth = cursor.getInteger(SVNWCDbSchema.NODES__Fields.op_depth.toString());
                    if (opDepth == 0L) {
                        checksum = cursor.getString(SVNWCDbSchema.NODES__Fields.checksum.toString());
                        if (refcountTable.containsKey(checksum)) {
                            refcountTable.put(checksum, (Long)refcountTable.get(checksum) + 1L);
                        } else {
                            refcountTable.put(checksum, 1L);
                        }
                    }
                    cursor.next();
                }
            }
            ISqlJetTable pTable = root.getSDb().getDb().getTable(SVNWCDbSchema.PRISTINE.toString());
            Iterator checksums = refcountTable.keySet().iterator();
            while (checksums.hasNext()) {
                checksum = (String)checksums.next();
                cursor = pTable.lookup(null, checksum);
                try {
                    if (cursor.eof()) continue;
                    long refCount = cursor.getInteger(SVNWCDbSchema.PRISTINE__Fields.refcount.toString());
                    if (refCount != (Long)refcountTable.get(checksum)) {
                        HashMap<String, Object> value = new HashMap<String, Object>();
                        cursor.updateByFieldNames(value);
                    }
                    checksums.remove();
                }
                finally {
                    cursor.close();
                }
            }
        }
        catch (SqlJetException e) {
            SvnWcDbPristines.rollbackTransaction(root);
            SVNSqlJetDb.createSqlJetError(e);
        }
        finally {
            SvnWcDbPristines.commitTransaction(root);
        }
    }

    public static void checkPristineChecksumRefcounts(SVNWCDbRoot root) throws SVNException {
        SvnChecksum sha1Checksum;
        Map<SvnChecksum, Integer> correctChecksumRefcounts = SvnWcDbPristines.calculateCorrectChecksumRefcounts(root);
        Map<SvnChecksum, Integer> checksumRefcountsFromTable = SvnWcDbPristines.loadChecksumsRefcountsFromTable(root);
        for (Map.Entry<SvnChecksum, Integer> entry : checksumRefcountsFromTable.entrySet()) {
            int refCount;
            sha1Checksum = entry.getKey();
            Integer refCountInteger = entry.getValue();
            Integer correctRefCountInteger = correctChecksumRefcounts.get(sha1Checksum);
            int correctRefCount = correctRefCountInteger == null ? 0 : correctRefCountInteger;
            if (correctRefCount == (refCount = refCountInteger == null ? 0 : refCountInteger)) continue;
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Working copy ''{0}'' is corrupted: {1} table contains incorrect ''refcount'' value {2} for checksum {3} (instead of {4})", root.getAbsPath().getAbsolutePath().replace('/', File.separatorChar), SVNWCDbSchema.PRISTINE.name(), refCount, sha1Checksum, correctRefCount);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        for (Map.Entry<SvnChecksum, Integer> entry : correctChecksumRefcounts.entrySet()) {
            sha1Checksum = entry.getKey();
            if (checksumRefcountsFromTable.containsKey(sha1Checksum)) continue;
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Working copy ''{0}'' is corrupted: checksum {1} that is present in {2} table is not listed in {3} table", root.getAbsPath().getAbsolutePath().replace('/', File.separatorChar), sha1Checksum, SVNWCDbSchema.NODES.name(), SVNWCDbSchema.PRISTINE.name());
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<SvnChecksum, Integer> calculateCorrectChecksumRefcounts(SVNWCDbRoot root) throws SVNException {
        HashMap<SvnChecksum, Integer> checksumToRefCount = new HashMap<SvnChecksum, Integer>();
        SqlJetDb db = root.getSDb().getDb();
        try {
            ISqlJetTable nodesTable = db.getTable(SVNWCDbSchema.NODES.name());
            db.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetCursor cursor = nodesTable.open();
            while (!cursor.eof()) {
                String sha1ChecksumString = cursor.getString(SVNWCDbSchema.NODES__Fields.checksum.name());
                if (sha1ChecksumString != null) {
                    SvnChecksum sha1Checksum = SvnChecksum.fromString(sha1ChecksumString);
                    Integer refCount = (Integer)checksumToRefCount.get(sha1Checksum);
                    int incrementedRefCount = refCount == null ? 1 : refCount + 1;
                    checksumToRefCount.put(sha1Checksum, incrementedRefCount);
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (SqlJetException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, e);
            SVNErrorManager.error(errorMessage, e, SVNLogType.WC);
        }
        finally {
            try {
                db.commit();
            }
            catch (SqlJetException sqlJetException) {}
        }
        return checksumToRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<SvnChecksum, Integer> loadChecksumsRefcountsFromTable(SVNWCDbRoot root) throws SVNException {
        HashMap<SvnChecksum, Integer> checksumToRefCount = new HashMap<SvnChecksum, Integer>();
        SqlJetDb db = root.getSDb().getDb();
        try {
            ISqlJetTable pristineTable = db.getTable(SVNWCDbSchema.PRISTINE.name());
            db.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetCursor cursor = pristineTable.open();
            while (!cursor.eof()) {
                String sha1ChecksumString = cursor.getString(SVNWCDbSchema.PRISTINE__Fields.checksum.name());
                if (sha1ChecksumString != null) {
                    SvnChecksum sha1Checksum = SvnChecksum.fromString(sha1ChecksumString);
                    long refcount = cursor.getInteger(SVNWCDbSchema.PRISTINE__Fields.refcount.name());
                    checksumToRefCount.put(sha1Checksum, (int)refcount);
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (SqlJetException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, e);
            SVNErrorManager.error(errorMessage, e, SVNLogType.WC);
        }
        finally {
            try {
                db.commit();
            }
            catch (SqlJetException sqlJetException) {}
        }
        return checksumToRefCount;
    }

    public static void transferPristine(SVNWCDb db, File srcLocalAbsPath, File dstWriAbsPath) throws SVNException {
        SVNWCDb.DirParsedInfo srcParsed = db.parseDir(srcLocalAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(srcParsed.wcDbDir);
        SVNWCDb.DirParsedInfo dstParsed = db.parseDir(dstWriAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(dstParsed.wcDbDir);
        if (srcParsed.wcDbDir.getWCRoot() == dstParsed.wcDbDir.getWCRoot() && srcParsed.wcDbDir.getWCRoot().getSDb() == dstParsed.wcDbDir.getWCRoot().getSDb()) {
            return;
        }
        PristineTransfer pristineTransfer = new PristineTransfer();
        pristineTransfer.srcWcRoot = srcParsed.wcDbDir.getWCRoot();
        pristineTransfer.dstWcRoot = dstParsed.wcDbDir.getWCRoot();
        pristineTransfer.srcRelPath = srcParsed.localRelPath;
        srcParsed.wcDbDir.getWCRoot().getSDb().runTransaction(pristineTransfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeTransferOnePristine(SVNWCDbRoot srcWcRoot, SVNWCDbRoot dstWcRoot, SvnChecksum checksum, SvnChecksum md5Checksum, long size) throws SVNException {
        SVNSqlJetStatement stmt = dstWcRoot.getSDb().getStatement(SVNWCDbStatements.INSERT_OR_IGNORE_PRISTINE);
        try {
            stmt.bindChecksum(1, checksum);
            stmt.bindChecksum(2, md5Checksum);
            stmt.bindLong(3, size);
            long affectedRows = stmt.done();
            if (affectedRows == 0L) {
                return;
            }
        }
        finally {
            stmt.reset();
        }
        File srcAbsPath = SvnWcDbPristines.getPristineFileName(srcWcRoot, checksum, false);
        File dstAbsPath = SvnWcDbPristines.getPristineFileName(dstWcRoot, checksum, true);
        SVNFileUtil.copy(srcAbsPath, dstAbsPath, true, false);
    }

    private static class PristineTransfer
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot srcWcRoot;
        public SVNWCDbRoot dstWcRoot;
        public File srcRelPath;

        private PristineTransfer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_COPY_PRISTINES);
            try {
                stmt.bindf("is", this.srcWcRoot.getWcId(), this.srcRelPath);
                boolean gotRow = stmt.next();
                while (gotRow) {
                    SvnChecksum checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                    SvnChecksum md5Checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt.getJoinedStatement(SVNWCDbSchema.PRISTINE), SVNWCDbSchema.PRISTINE__Fields.md5_checksum);
                    long size = stmt.getJoinedStatement(SVNWCDbSchema.PRISTINE).getColumnLong(SVNWCDbSchema.PRISTINE__Fields.size);
                    SvnWcDbPristines.maybeTransferOnePristine(this.srcWcRoot, this.dstWcRoot, checksum, md5Checksum, size);
                    gotRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class RemoveUnreferencedPristine
    implements SVNSqlJetTransaction {
        public SvnChecksum sha1_checksum;
        public File pristineAbsPath;
        SVNWCDbRoot root;

        private RemoveUnreferencedPristine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_PRISTINE_IF_UNREFERENCED);
            try {
                stmt.bindf("s", this.sha1_checksum);
                Long affectedRows = stmt.done();
                if (affectedRows > 0L) {
                    this.pristineRemoveFile(true);
                }
            }
            finally {
                stmt.reset();
            }
        }

        private void pristineRemoveFile(boolean ignoreEnoent) throws SVNException {
            block3: {
                if (SVNFileUtil.isWindows) {
                    File temDirAbsPath = SvnWcDbPristines.getPristineTempDir(this.root, this.root.getAbsPath());
                    File tempAbsPath = SVNFileUtil.createUniqueFile(temDirAbsPath, "pristine", ".tmp", false);
                    try {
                        SVNFileUtil.rename(this.pristineAbsPath, tempAbsPath);
                        this.pristineAbsPath = tempAbsPath;
                    }
                    catch (SVNException e) {
                        if (ignoreEnoent && SVNFileType.getType(tempAbsPath) == SVNFileType.NONE) break block3;
                        throw e;
                    }
                }
            }
            SVNFileUtil.deleteFile(this.pristineAbsPath);
        }
    }
}

