/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class XUnitTestResultsFileParser
implements UnitTestResultsParser {
    private static final Logger LOG = Loggers.get(XUnitTestResultsFileParser.class);

    @Override
    public void accept(File file, UnitTestResults unitTestResults) {
        LOG.debug("The current user dir is '{}'.", (Object)System.getProperty("user.dir"));
        LOG.info("Parsing the XUnit Test Results file '{}'.", (Object)file.getAbsolutePath());
        new Parser(file, unitTestResults).parse();
    }

    private static class Parser {
        private final File file;
        private final UnitTestResults unitTestResults;

        Parser(File file, UnitTestResults unitTestResults) {
            this.file = file;
            this.unitTestResults = unitTestResults;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                String tag = xmlParserHelper.nextStartTag();
                if (!"assemblies".equals(tag) && !"assembly".equals(tag)) {
                    throw xmlParserHelper.parseError("Expected either an <assemblies> or an <assembly> root tag, but got <" + tag + "> instead.");
                }
                do {
                    if (!"assembly".equals(tag)) continue;
                    this.handleAssemblyTag(xmlParserHelper);
                } while ((tag = xmlParserHelper.nextStartTag()) != null);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void handleAssemblyTag(XmlParserHelper xmlParserHelper) {
            String totalString = xmlParserHelper.getAttribute("total");
            if (totalString == null) {
                LOG.warn("One of the assemblies contains no test result, please make sure this is expected.");
                return;
            }
            int total = xmlParserHelper.tagToIntValue("total", totalString);
            int failed = xmlParserHelper.getRequiredIntAttribute("failed");
            int skipped = xmlParserHelper.getRequiredIntAttribute("skipped");
            int errors = xmlParserHelper.getIntAttributeOrZero("errors");
            Double time = xmlParserHelper.getDoubleAttribute("time");
            Long executionTime = time != null ? Long.valueOf((long)(time * 1000.0)) : null;
            this.unitTestResults.add(total, skipped, failed, errors, executionTime);
            LOG.debug("Parsed XUnit test results - total: {}, failed: {}, skipped: {}, errors: {}, executionTime: {}.", new Object[]{total, failed, skipped, errors, executionTime});
        }
    }
}

