/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.FileProvider;

public abstract class PythonReportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PythonReportSensor.class);
    protected final Configuration conf;
    private final AnalysisWarningsWrapper analysisWarnings;
    private final String reportType;

    public PythonReportSensor(Configuration conf, AnalysisWarningsWrapper analysisWarnings, String reportType) {
        this.conf = conf;
        this.analysisWarnings = analysisWarnings;
        this.reportType = reportType;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.getClass().getSimpleName()).onlyOnLanguage("py").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        String reportPathPropertyKey = this.reportPathKey();
        String reportPath = this.conf.get(reportPathPropertyKey).orElse(this.defaultReportPath());
        try {
            List<File> reports = PythonReportSensor.getReports(this.conf, context.fileSystem().baseDir().getPath(), reportPathPropertyKey, reportPath, this.analysisWarnings);
            this.processReports(context, reports);
        }
        catch (Exception e) {
            LOG.warn("Cannot read report '{}', the following exception occurred: {}", (Object)reportPath, (Object)e.getMessage());
            this.analysisWarnings.addUnique(String.format("An error occurred while trying to import %s report(s): '%s'", this.reportType, reportPath));
        }
    }

    public static List<File> getReports(Configuration conf, String baseDirPath, String reportPathPropertyKey, String reportPath, AnalysisWarningsWrapper analysisWarnings) {
        LOG.debug("Using pattern '{}' to find reports", (Object)reportPath);
        FileProvider provider = new FileProvider(new File(baseDirPath), reportPath);
        List<File> matchingFiles = provider.getMatchingFiles();
        if (matchingFiles.isEmpty()) {
            if (conf.hasKey(reportPathPropertyKey)) {
                File file = new File(reportPath);
                if (!file.exists()) {
                    String formattedMessage = String.format("No report was found for %s using pattern %s", reportPathPropertyKey, reportPath);
                    LOG.warn(formattedMessage);
                    analysisWarnings.addUnique(formattedMessage);
                } else {
                    matchingFiles.add(file);
                }
            } else {
                LOG.debug("No report was found for {} using default pattern {}", (Object)reportPathPropertyKey, (Object)reportPath);
            }
        }
        return matchingFiles;
    }

    protected void processReports(SensorContext context, List<File> reports) throws XMLStreamException {
    }

    protected abstract String reportPathKey();

    protected abstract String defaultReportPath();
}

