/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.caching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class StringTable {
    private final Map<String, Integer> table = new HashMap<String, Integer>();
    private final List<String> byIndex;

    public StringTable() {
        this.byIndex = new ArrayList<String>();
    }

    public StringTable(List<String> byIndex) {
        this.byIndex = byIndex;
        for (int i = 0; i < byIndex.size(); ++i) {
            this.table.put(byIndex.get(i), i);
        }
    }

    public int getIndex(@Nullable String string) {
        return this.table.computeIfAbsent(string, s -> {
            this.byIndex.add((String)s);
            return this.byIndex.size() - 1;
        });
    }

    public String getString(int index) {
        return this.byIndex.get(index);
    }

    public List<String> getStringList() {
        return Collections.unmodifiableList(this.byIndex);
    }
}

