/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.python.cfg.fixpoint.CfgBlockState;

public class DefinedVariablesAnalysis {
    private final Map<CfgBlock, DefinedVariables> definedVariablesPerBlock = new HashMap<CfgBlock, DefinedVariables>();

    public static DefinedVariablesAnalysis analyze(ControlFlowGraph cfg, Set<Symbol> localVariables) {
        DefinedVariablesAnalysis instance = new DefinedVariablesAnalysis();
        instance.compute(cfg, localVariables);
        return instance;
    }

    private void compute(ControlFlowGraph cfg, Set<Symbol> localVariables) {
        HashMap<Symbol, VariableDefinition> initialState = new HashMap<Symbol, VariableDefinition>();
        Iterator<Symbol> iterator = localVariables.iterator();
        while (iterator.hasNext()) {
            Symbol variable;
            boolean isParameter = (variable = iterator.next()).usages().stream().anyMatch(u -> u.kind() == Usage.Kind.PARAMETER);
            initialState.put(variable, isParameter ? VariableDefinition.DEFINED : VariableDefinition.UNDEFINED);
        }
        Set<CfgBlock> blocks = cfg.blocks();
        blocks.forEach(block -> this.definedVariablesPerBlock.put((CfgBlock)block, DefinedVariables.build(block, initialState)));
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(blocks);
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            DefinedVariables definedVariables = this.definedVariablesPerBlock.get(currentBlock);
            boolean outHasChanged = definedVariables.propagate(this.definedVariablesPerBlock);
            if (!outHasChanged) continue;
            currentBlock.successors().forEach(workList::push);
        }
    }

    public DefinedVariables getDefinedVariables(CfgBlock block) {
        return this.definedVariablesPerBlock.get(block);
    }

    public static class DefinedVariables
    extends CfgBlockState {
        private Map<Symbol, VariableDefinition> in = new HashMap<Symbol, VariableDefinition>();
        private Map<Symbol, VariableDefinition> out = new HashMap<Symbol, VariableDefinition>();

        private DefinedVariables(CfgBlock block) {
            super(block);
        }

        public static DefinedVariables build(CfgBlock block, Map<Symbol, VariableDefinition> initialState) {
            DefinedVariables instance = new DefinedVariables(block);
            instance.in = initialState;
            instance.init(block);
            return instance;
        }

        private boolean propagate(Map<CfgBlock, DefinedVariables> definedVariablesPerBlock) {
            this.block.predecessors().stream().map(definedVariablesPerBlock::get).map(DefinedVariables::getOut).forEach(predecessorOuts -> {
                this.in = DefinedVariables.join(this.in, predecessorOuts);
            });
            HashMap<Symbol, VariableDefinition> newOut = new HashMap<Symbol, VariableDefinition>(this.in);
            this.kill.forEach(symbol -> newOut.put((Symbol)symbol, VariableDefinition.DEFINED));
            boolean outHasChanged = !newOut.equals(this.out);
            this.out = newOut;
            return outHasChanged;
        }

        private static Map<Symbol, VariableDefinition> join(Map<Symbol, VariableDefinition> programState1, Map<Symbol, VariableDefinition> programState2) {
            HashMap<Symbol, VariableDefinition> result = new HashMap<Symbol, VariableDefinition>();
            HashSet<Symbol> allKeys = new HashSet<Symbol>(programState1.keySet());
            allKeys.addAll(programState2.keySet());
            for (Symbol key : allKeys) {
                VariableDefinition varDef1 = programState1.getOrDefault(key, VariableDefinition.UNDEFINED);
                VariableDefinition varDef2 = programState2.getOrDefault(key, VariableDefinition.UNDEFINED);
                result.put(key, VariableDefinition.join(varDef1, varDef2));
            }
            return result;
        }

        public Map<Symbol, VariableDefinition> getIn() {
            return this.in;
        }

        public Map<Symbol, VariableDefinition> getOut() {
            return this.out;
        }
    }

    public static enum VariableDefinition {
        UNDEFINED,
        DEFINED;


        static VariableDefinition join(VariableDefinition v1, VariableDefinition v2) {
            if (v1 == UNDEFINED && v2 == UNDEFINED) {
                return UNDEFINED;
            }
            return DEFINED;
        }
    }
}

