/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1186")
public class EmptyFunctionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a nested comment explaining why this %s is empty, or complete the implementation.";
    private static final List<String> ABC_DECORATORS = List.of("abstractmethod", "abstractstaticmethod", "abstractproperty", "abstractclassmethod");
    private static final List<String> BINARY_MAGIC_METHODS = List.of("__add__", "__and__", "__cmp__", "__divmod__", "__div__", "__eq__", "__floordiv__", "__ge__", "__gt__", "__iadd__", "__iand__", "__idiv__", "__ifloordiv__", "__ilshift__", "__imod__", "__imul__", "__ior__", "__ipow__", "__irshift__", "__isub__", "__ixor__", "__le__", "__lshift__", "__lt__", "__mod__", "__mul__", "__ne__", "__or__", "__pow__", "__radd__", "__rand__", "__rdiv__", "__rfloordiv__", "__rlshift__", "__rmod__", "__rmul__", "__ror__", "__rpow__", "__rrshift__", "__rshift__", "__rsub__", "__rxor__", "__sub__", "__xor__");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (functionDef.decorators().stream().map(d -> TreeUtils.decoratorNameFromExpression(d.expression())).filter(Objects::nonNull).flatMap(s -> Arrays.stream(s.split("\\."))).anyMatch(ABC_DECORATORS::contains)) {
                return;
            }
            if (functionDef.body().statements().size() == 1 && functionDef.body().statements().get(0).is(Tree.Kind.PASS_STMT)) {
                if (TreeUtils.tokens(functionDef).stream().anyMatch(t -> !t.trivia().isEmpty())) {
                    return;
                }
                if (EmptyFunctionCheck.hasCommentAbove(functionDef)) {
                    return;
                }
                String type = functionDef.isMethodDefinition() ? "method" : "function";
                IssueWithQuickFix issue = (IssueWithQuickFix)ctx.addIssue(functionDef.name(), String.format(MESSAGE, type));
                EmptyFunctionCheck.addQuickFixes(issue, functionDef, type);
            }
        });
    }

    private static void addQuickFixes(IssueWithQuickFix issue, FunctionDef functionDef, String functionType) {
        Statement passStatement = functionDef.body().statements().get(0);
        issue.addQuickFix(PythonQuickFix.newQuickFix("Insert placeholder comment", PythonTextEdit.insertLineBefore(passStatement, "# TODO document why this method is empty")));
        if (functionType.equals("method") && BINARY_MAGIC_METHODS.contains(functionDef.name().name())) {
            issue.addQuickFix(PythonQuickFix.newQuickFix("Return NotImplemented constant", PythonTextEdit.insertLineBefore(passStatement, "return NotImplemented")));
        } else {
            issue.addQuickFix(PythonQuickFix.newQuickFix("Raise NotImplementedError()", PythonTextEdit.insertLineBefore(passStatement, "raise NotImplementedError()")));
        }
    }

    private static boolean hasCommentAbove(FunctionDef functionDef) {
        Token defKeyword;
        Tree parent = functionDef.parent();
        List<Token> tokens = TreeUtils.tokens(parent);
        int index = tokens.indexOf(defKeyword = functionDef.defKeyword());
        if (index == 0) {
            parent = parent.parent();
            tokens = TreeUtils.tokens(parent);
            index = tokens.indexOf(defKeyword);
        }
        return index > 0 && !tokens.get(index - 1).trivia().isEmpty();
    }
}

