/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1764")
public class IdenticalExpressionOnBinaryOperatorCheck
extends PythonSubscriptionCheck {
    private static final List<Tree.Kind> kinds = Arrays.asList(Tree.Kind.MINUS, Tree.Kind.DIVISION, Tree.Kind.FLOOR_DIVISION, Tree.Kind.MODULO, Tree.Kind.SHIFT_EXPR, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR, Tree.Kind.BITWISE_XOR, Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.COMPARISON, Tree.Kind.IS, Tree.Kind.IN);

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        kinds.forEach(k -> context.registerSyntaxNodeConsumer((Tree.Kind)((Object)k), IdenticalExpressionOnBinaryOperatorCheck::checkBinaryExpression));
    }

    private static void checkBinaryExpression(SubscriptionContext ctx) {
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        Expression leftOperand = binaryExpression.leftOperand();
        Expression rightOperand = binaryExpression.rightOperand();
        Token operator = binaryExpression.operator();
        if (CheckUtils.areEquivalent(leftOperand, rightOperand) && !"<<".equals(operator.value()) && !IdenticalExpressionOnBinaryOperatorCheck.isException(leftOperand)) {
            ctx.addIssue(rightOperand, "Correct one of the identical sub-expressions on both sides of operator \"" + operator.value() + "\".").secondary(leftOperand, "");
        }
    }

    private static boolean isException(Expression leftOperand) {
        return leftOperand.is(Tree.Kind.CALL_EXPR) || TreeUtils.hasDescendant(leftOperand, t -> t.is(Tree.Kind.CALL_EXPR)) || TreeUtils.firstAncestorOfKind(leftOperand, Tree.Kind.TRY_STMT) != null;
    }
}

