/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S1707")
public class NoPersonReferenceInTodoCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Add a citation of the person who can best explain this comment.";
    private static final String DEFAULT_PERSON_REFERENCE_PATTERN = "[ ]*\\([ _a-zA-Z0-9@.]+\\)";
    private static final String COMMENT_PATTERN = "^#[ ]*(todo|fixme)";
    private Pattern patternTodoFixme;
    private Pattern patternPersonReference;
    @RuleProperty(key="pattern", description="A regular expression defining the pattern that should be present after \"TODO\" or \"FIXME\"", defaultValue="[ ]*\\([ _a-zA-Z0-9@.]+\\)")
    public String personReferencePatternString = "[ ]*\\([ _a-zA-Z0-9@.]+\\)";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        this.patternTodoFixme = Pattern.compile(COMMENT_PATTERN, 2);
        this.patternPersonReference = Pattern.compile(this.personReferencePatternString);
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                this.checkComment(trivia, (SubscriptionContext)ctx);
            }
        });
    }

    private void checkComment(Trivia trivia, SubscriptionContext ctx) {
        String tail;
        String comment = trivia.value();
        Matcher matcher = this.patternTodoFixme.matcher(comment);
        if (matcher.find() && !this.patternPersonReference.matcher(tail = comment.substring(matcher.end())).find()) {
            ctx.addIssue(trivia.token(), MESSAGE);
        }
    }
}

