/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.TreeUtils;

public class CdkPredicate {
    private CdkPredicate() {
    }

    public static Predicate<Expression> isFalse() {
        return expression -> Optional.ofNullable(expression.firstToken()).map(Token::value).filter("False"::equals).isPresent();
    }

    public static Predicate<Expression> isTrue() {
        return expression -> Optional.ofNullable(expression.firstToken()).map(Token::value).filter("True"::equals).isPresent();
    }

    public static Predicate<Expression> isNone() {
        return expression -> expression.is(Tree.Kind.NONE);
    }

    public static Predicate<Expression> isFqn(String fqnValue) {
        return expression -> Optional.ofNullable(TreeUtils.fullyQualifiedNameFromExpression(expression)).filter(fqnValue::equals).isPresent();
    }

    public static Predicate<Expression> isFqnOf(Collection<String> fqnValues) {
        return expression -> Optional.ofNullable(TreeUtils.fullyQualifiedNameFromExpression(expression)).filter(fqnValues::contains).isPresent();
    }

    public static Predicate<Expression> isString(String expectedValue) {
        return expression -> CdkUtils.getString(expression).filter(expectedValue::equals).isPresent();
    }

    public static Predicate<Expression> isWildcard() {
        return CdkPredicate.isString("*");
    }

    public static Predicate<Expression> isString(Set<String> expectedValues) {
        return expression -> CdkUtils.getString(expression).filter(expectedValues::contains).isPresent();
    }

    public static Predicate<Expression> matches(Pattern pattern) {
        return expression -> CdkUtils.getString(expression).filter(string -> pattern.matcher((CharSequence)string).find()).isPresent();
    }

    public static Predicate<Expression> isStringLiteral() {
        return expression -> expression.is(Tree.Kind.STRING_LITERAL);
    }

    public static Predicate<Expression> isNumericLiteral() {
        return expression -> expression.is(Tree.Kind.NUMERIC_LITERAL);
    }

    public static Predicate<Expression> isListLiteral() {
        return expression -> expression.is(Tree.Kind.LIST_LITERAL);
    }

    public static Predicate<Expression> isSubscriptionExpression() {
        return expression -> expression.is(Tree.Kind.SUBSCRIPTION);
    }

    public static Predicate<Expression> startsWith(String expected) {
        return expression -> CdkUtils.getString(expression).filter(str -> str.toLowerCase(Locale.ROOT).startsWith(expected)).isPresent();
    }

    public static Predicate<Expression> isCallExpression() {
        return expression -> expression.is(Tree.Kind.CALL_EXPR);
    }

    @SafeVarargs
    public static Predicate<Expression> hasArgument(String name, int pos, Predicate<Expression> ... predicates) {
        return expression -> {
            if (!expression.is(Tree.Kind.CALL_EXPR)) {
                return false;
            }
            return CdkUtils.getArgument(null, (CallExpression)expression, name, pos).filter(flow -> flow.hasExpression(Arrays.stream(predicates).reduce(x -> true, Predicate::and))).isPresent();
        };
    }

    @SafeVarargs
    public static Predicate<Expression> hasArgument(String name, Predicate<Expression> ... predicates) {
        return CdkPredicate.hasArgument(name, -1, predicates);
    }

    public static Predicate<Expression> hasIntervalArguments(String argNameMin, int argPosMin, String argNameMax, int argPosMax, Collection<Long> values) {
        return expression -> {
            if (!expression.is(Tree.Kind.CALL_EXPR)) {
                return false;
            }
            Optional<Long> minVal = CdkPredicate.getArgumentAsLong((CallExpression)expression, argNameMin, argPosMin);
            Optional<Long> maxVal = CdkPredicate.getArgumentAsLong((CallExpression)expression, argNameMax, argPosMax);
            if (minVal.isEmpty() || maxVal.isEmpty()) {
                return false;
            }
            return CdkPredicate.anyValueInInterval(values, minVal.get(), maxVal.get());
        };
    }

    public static Predicate<Expression> hasIntervalArguments(String argNameMin, String argNameMax, Collection<Long> values) {
        return CdkPredicate.hasIntervalArguments(argNameMin, -1, argNameMax, -1, values);
    }

    private static Optional<Long> getArgumentAsLong(CallExpression callExpression, String argName, int argPos) {
        return CdkUtils.getArgument(null, callExpression, argName, argPos).flatMap(flow -> flow.getExpression(CdkPredicate.isNumericLiteral())).map(NumericLiteral.class::cast).map(NumericLiteral::valueAsLong);
    }

    private static boolean anyValueInInterval(Collection<Long> values, long min, long max) {
        for (long val : values) {
            if (min > val || val > max) continue;
            return true;
        }
        return false;
    }

    public static Predicate<Expression> isNumeric(Set<Long> vals) {
        return expression -> expression.is(Tree.Kind.NUMERIC_LITERAL) && vals.contains(((NumericLiteral)expression).valueAsLong());
    }
}

