/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2245")
public class PseudoRandomCheck
extends PythonSubscriptionCheck {
    private static final Set<String> FUNCTIONS_TO_CHECK = new HashSet<String>(Arrays.asList("random.random", "random.getrandbits", "random.randint", "random.sample", "random.choice", "random.choices"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol != null && FUNCTIONS_TO_CHECK.contains(symbol.fullyQualifiedName())) {
                ctx.addIssue(callExpression, "Make sure that using this pseudorandom number generator is safe here.");
            }
        });
    }
}

