/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.CaseBlock;
import org.sonar.plugins.python.api.tree.Guard;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class CaseBlockImpl
extends PyTree
implements CaseBlock {
    private final Token caseKeyword;
    private final Pattern pattern;
    @Nullable
    private final Guard guard;
    private final Token colon;
    @Nullable
    private final Token newLine;
    @Nullable
    private final Token indent;
    private final StatementList body;
    @Nullable
    private final Token dedent;

    public CaseBlockImpl(Token caseKeyword, Pattern pattern, @Nullable Guard guard, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent) {
        this.caseKeyword = caseKeyword;
        this.pattern = pattern;
        this.guard = guard;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
    }

    @Override
    public Token caseKeyword() {
        return this.caseKeyword;
    }

    @Override
    public Pattern pattern() {
        return this.pattern;
    }

    @Override
    @CheckForNull
    public Guard guard() {
        return this.guard;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCaseBlock(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CASE_BLOCK;
    }

    @Override
    List<Tree> computeChildren() {
        return Stream.of(this.caseKeyword, this.pattern, this.guard, this.colon, this.newLine, this.indent, this.body, this.dedent).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

