/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ExpressionListImpl
extends PyTree
implements ExpressionList {
    private final List<Expression> expressions;
    private final List<Token> commas;

    public ExpressionListImpl(List<Expression> expressions, List<Token> commas) {
        this.expressions = expressions;
        this.commas = commas;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXPRESSION_LIST;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExpressionList(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        int i = 0;
        for (Expression expression : this.expressions) {
            children.add(expression);
            if (i < this.commas.size()) {
                children.add(this.commas.get(i));
            }
            ++i;
        }
        return children;
    }
}

