/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.PassStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class PassStatementImpl
extends SimpleStatement
implements PassStatement {
    private final Token passKeyword;
    private final Separators separators;

    public PassStatementImpl(Token passKeyword, Separators separators) {
        this.passKeyword = passKeyword;
        this.separators = separators;
    }

    @Override
    public Token passKeyword() {
        return this.passKeyword;
    }

    @Override
    @Nullable
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PASS_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPassStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.passKeyword), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

