/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class RaiseStatementImpl
extends SimpleStatement
implements RaiseStatement {
    private final Token raiseKeyword;
    private final List<Expression> expressions;
    private final Token fromKeyword;
    private final Expression fromExpression;
    private final Separators separators;

    public RaiseStatementImpl(Token raiseKeyword, List<Expression> expressions, @Nullable Token fromKeyword, @Nullable Expression fromExpression, Separators separators) {
        this.raiseKeyword = raiseKeyword;
        this.expressions = expressions;
        this.fromKeyword = fromKeyword;
        this.fromExpression = fromExpression;
        this.separators = separators;
    }

    @Override
    public Token raiseKeyword() {
        return this.raiseKeyword;
    }

    @Override
    @CheckForNull
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public Expression fromExpression() {
        return this.fromExpression;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RAISE_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitRaiseStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.raiseKeyword), this.expressions, Arrays.asList(this.fromKeyword, this.fromExpression), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

