/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.helpers.RegexTreeHelper;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public class RedundantRegexAlternativesFinder
extends RegexBaseVisitor {
    public static final String MESSAGE = "Remove or rework this redundant alternative.";
    public static final String MESSAGE_KEEP = "Alternative to keep";
    public static final String MESSAGE_REDUNDANT = "Other redundant alternative";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public RedundantRegexAlternativesFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        RedundantAlternativeCollector collector = new RedundantAlternativeCollector();
        List alternatives = tree.getAlternatives().stream().filter(t -> !RedundantRegexAlternativesFinder.hasPosixCharacterClass(t)).collect(Collectors.toList());
        int i = 0;
        while (i + 1 < alternatives.size()) {
            for (int j = i + 1; j < alternatives.size(); ++j) {
                collector.evaluate((RegexTree)alternatives.get(i), (RegexTree)alternatives.get(j));
            }
            ++i;
        }
        collector.supersetSubsetListMap.forEach(this::reportRedundantIssue);
        super.visitDisjunction(tree);
    }

    private void reportRedundantIssue(RegexTree supersetAlternative, Set<RegexTree> redundantSubsetAlternatives) {
        ArrayList<RegexTree> redundantAlternatives = new ArrayList<RegexTree>(redundantSubsetAlternatives);
        redundantAlternatives.sort(Comparator.comparing(element -> element.getRange().getBeginningOffset()));
        RegexTree firstRedundantAlternatives = (RegexTree)redundantAlternatives.get(0);
        ArrayList<RegexIssueLocation> secondaries = new ArrayList<RegexIssueLocation>();
        secondaries.add(new RegexIssueLocation(supersetAlternative, MESSAGE_KEEP));
        redundantAlternatives.stream().skip(1L).map(otherRedundantAlternatives -> new RegexIssueLocation((RegexSyntaxElement)otherRedundantAlternatives, MESSAGE_REDUNDANT)).forEach(secondaries::add);
        this.regexElementIssueReporter.report(firstRedundantAlternatives, MESSAGE, null, secondaries);
    }

    private static boolean hasPosixCharacterClass(RegexTree tree) {
        PosixCharacterClassVisitor posixCharacterClassVisitor = new PosixCharacterClassVisitor();
        posixCharacterClassVisitor.visit(tree);
        return posixCharacterClassVisitor.hasPosixCharacterClass;
    }

    private static class PosixCharacterClassVisitor
    extends RegexBaseVisitor {
        boolean hasPosixCharacterClass = false;

        private PosixCharacterClassVisitor() {
        }

        @Override
        public void visitInCharClass(CharacterClassElementTree tree) {
            if (tree.is(CharacterClassElementTree.Kind.POSIX_CLASS)) {
                this.hasPosixCharacterClass = true;
            }
            super.visitInCharClass(tree);
        }
    }

    private static class CapturingGroupVisitor
    extends RegexBaseVisitor {
        boolean hasCapturingGroup;

        private CapturingGroupVisitor() {
        }

        @Override
        public void visitCapturingGroup(CapturingGroupTree tree) {
            this.hasCapturingGroup = true;
        }
    }

    private static class RedundantAlternativeCollector {
        private final Map<RegexTree, Set<RegexTree>> supersetSubsetListMap = new LinkedHashMap<RegexTree, Set<RegexTree>>();
        private final Set<RegexTree> allSubsets = new HashSet<RegexTree>();

        private RedundantAlternativeCollector() {
        }

        private void evaluate(RegexTree prevAlternative, RegexTree nextAlternative) {
            if (RedundantAlternativeCollector.supersetOf(prevAlternative, nextAlternative)) {
                this.add(prevAlternative, nextAlternative);
            } else if (RedundantAlternativeCollector.supersetOf(nextAlternative, prevAlternative) && RedundantAlternativeCollector.hasNoCapturingGroup(prevAlternative) && RedundantAlternativeCollector.hasNoCapturingGroup(nextAlternative)) {
                this.add(nextAlternative, prevAlternative);
            }
        }

        private static boolean supersetOf(RegexTree alternative1, RegexTree alternative2) {
            SubAutomaton subAutomaton1 = new SubAutomaton(alternative1, alternative1.continuation(), false);
            SubAutomaton subAutomaton2 = new SubAutomaton(alternative2, alternative2.continuation(), false);
            return RegexTreeHelper.supersetOf(subAutomaton1, subAutomaton2, false);
        }

        private void add(RegexTree superset, RegexTree subset) {
            if (this.allSubsets.contains(subset)) {
                return;
            }
            if (this.allSubsets.contains(superset)) {
                return;
            }
            Set subsetList = this.supersetSubsetListMap.computeIfAbsent(superset, k -> new HashSet());
            Set<RegexTree> subsetOfTheSubset = this.supersetSubsetListMap.remove(subset);
            if (subsetOfTheSubset != null) {
                subsetList.addAll(subsetOfTheSubset);
            }
            this.allSubsets.add(subset);
            subsetList.add(subset);
        }

        private static boolean hasNoCapturingGroup(RegexTree tree) {
            CapturingGroupVisitor visitor = new CapturingGroupVisitor();
            tree.accept(visitor);
            return !visitor.hasCapturingGroup;
        }
    }
}

