/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.HashMap;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public abstract class AbstractAutomataChecker {
    private final OrderedAutomataPairCache<Boolean> cache = new OrderedAutomataPairCache();
    protected final boolean defaultAnswer;

    protected AbstractAutomataChecker(boolean defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    public boolean check(SubAutomaton auto1, SubAutomaton auto2) {
        return this.check(auto1, auto2, false);
    }

    protected boolean check(SubAutomaton auto1, SubAutomaton auto2, boolean hasConsumedInput) {
        boolean answer;
        if (AbstractAutomataChecker.hasUnsupportedTransitionType(auto1) || AbstractAutomataChecker.hasUnsupportedTransitionType(auto2)) {
            return this.defaultAnswer;
        }
        OrderedAutomataPair entry = new OrderedAutomataPair(auto1, auto2, hasConsumedInput);
        Boolean cachedValue = this.cache.startCalculation(entry, this.neutralAnswer());
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean bl = answer = hasConsumedInput || this.defaultAnswer;
        if (auto1.isAtEnd() && auto2.isAtEnd()) {
            return this.cache.save(entry, answer);
        }
        if (auto1.isAtEnd() && auto2.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
            return this.cache.save(entry, auto2.allowPrefix && answer);
        }
        if (auto2.isAtEnd() && auto1.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
            return this.cache.save(entry, auto1.allowPrefix && answer);
        }
        if (auto2.incomingTransitionType() == AutomatonState.TransitionType.EPSILON && !auto2.isAtEnd()) {
            return this.cache.save(entry, this.checkAuto2Successors(auto1, auto2, this.defaultAnswer, hasConsumedInput));
        }
        if (auto1.incomingTransitionType() == AutomatonState.TransitionType.EPSILON) {
            return this.cache.save(entry, this.checkAuto1Successors(auto1, auto2, this.defaultAnswer, hasConsumedInput));
        }
        return this.cache.save(entry, this.checkAuto1AndAuto2Successors(auto1, auto2, this.defaultAnswer, hasConsumedInput));
    }

    public void clearCache() {
        this.cache.clear();
    }

    protected abstract boolean neutralAnswer();

    protected abstract boolean checkAuto1AndAuto2Successors(SubAutomaton var1, SubAutomaton var2, boolean var3, boolean var4);

    protected abstract boolean checkAuto1Successors(SubAutomaton var1, SubAutomaton var2, boolean var3, boolean var4);

    protected abstract boolean checkAuto2Successors(SubAutomaton var1, SubAutomaton var2, boolean var3, boolean var4);

    private static boolean hasUnsupportedTransitionType(SubAutomaton auto) {
        if (auto.isAtEnd()) {
            return false;
        }
        AutomatonState.TransitionType transition = auto.start.incomingTransitionType();
        return transition == AutomatonState.TransitionType.LOOKAROUND_BACKTRACKING || transition == AutomatonState.TransitionType.NEGATION || auto.start instanceof LookAroundTree || auto.start instanceof BoundaryTree || transition == AutomatonState.TransitionType.BACK_REFERENCE || AbstractAutomataChecker.isMoreThanOneFiniteRepetition(auto.start);
    }

    private static boolean isMoreThanOneFiniteRepetition(AutomatonState state) {
        if (state instanceof RepetitionTree) {
            Integer maximumRepetitions = ((RepetitionTree)state).getQuantifier().getMaximumRepetitions();
            return maximumRepetitions != null && maximumRepetitions > 1;
        }
        return false;
    }

    static class OrderedAutomataPair {
        public final SubAutomaton auto1;
        public final SubAutomaton auto2;
        public final boolean hasConsumedInput;

        public OrderedAutomataPair(SubAutomaton auto1, SubAutomaton auto2, boolean hasConsumedInput) {
            this.auto1 = auto1;
            this.auto2 = auto2;
            this.hasConsumedInput = hasConsumedInput;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedAutomataPair that = (OrderedAutomataPair)o;
            return this.hasConsumedInput == that.hasConsumedInput && this.auto1.equals(that.auto1) && this.auto2.equals(that.auto2);
        }

        public int hashCode() {
            return Objects.hash(this.auto1, this.auto2, this.hasConsumedInput);
        }
    }

    static class OrderedAutomataPairCache<T>
    extends HashMap<OrderedAutomataPair, T> {
        public static final int MAX_CACHE_SIZE = 5000;

        OrderedAutomataPairCache() {
        }

        @CheckForNull
        T startCalculation(OrderedAutomataPair statePair, T defaultAnswer) {
            Object cachedResult = this.get(statePair);
            if (cachedResult != null) {
                return (T)cachedResult;
            }
            if (this.size() >= 5000) {
                return defaultAnswer;
            }
            this.put(statePair, defaultAnswer);
            return null;
        }

        T save(OrderedAutomataPair statePair, T value) {
            this.put(statePair, value);
            return value;
        }
    }
}

