/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.sonar.sslr.grammar.GrammarRuleKey;

public enum FlexKeyword implements GrammarRuleKey
{
    AS(true),
    BREAK,
    CASE,
    CATCH,
    CLASS,
    CONST,
    CONTINUE,
    DEFAULT,
    DELETE,
    DO,
    ELSE,
    EXTENDS,
    FALSE,
    FINALLY,
    FOR,
    FUNCTION,
    IF,
    IMPLEMENTS,
    IMPORT,
    IN,
    INSTANCEOF,
    INTERFACE,
    INTERNAL,
    IS,
    NEW,
    NULL,
    PACKAGE,
    PRIVATE,
    PROTECTED,
    PUBLIC,
    RETURN,
    SUPER,
    SWITCH,
    THIS,
    THROW,
    TRUE,
    TRY,
    TYPEOF,
    USE,
    VAR,
    VOID,
    WHILE,
    WITH,
    EACH(true),
    GET(true),
    SET(true),
    NAMESPACE(true),
    INCLUDE(true),
    DYNAMIC(true),
    FINAL(true),
    NATIVE(true),
    OVERRIDE(true),
    STATIC(true),
    XML(true);

    private final boolean syntactic;

    private FlexKeyword() {
        this(false);
    }

    private FlexKeyword(boolean syntactic) {
        this.syntactic = syntactic;
    }

    public static String[] keywordValues() {
        String[] keywordsValue = new String[FlexKeyword.values().length];
        int i = 0;
        for (FlexKeyword keyword : FlexKeyword.values()) {
            keywordsValue[i] = keyword.getValue();
            ++i;
        }
        return keywordsValue;
    }

    public static List<FlexKeyword> keywords() {
        return Collections.unmodifiableList(Arrays.stream(FlexKeyword.values()).filter(flexKeyword -> !flexKeyword.syntactic).collect(Collectors.toList()));
    }

    public String getValue() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }
}

