/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;

@Rule(key="S101")
public class ClassNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the class names against", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    String format = "^[A-Z][a-zA-Z0-9]*$";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        String classIdentifier = Clazz.getName(astNode);
        if (!this.pattern.matcher(classIdentifier).matches()) {
            this.addIssue(MessageFormat.format("Rename this class name to match the regular expression {0}", this.format), astNode);
        }
    }
}

