/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1301")
public class NotEnoughCaseForSwitchCheck
extends FlexCheck {
    private static final int MINIMUM_CASE = 3;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.SWITCH_STATEMENT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        int nbCase = 0;
        for (AstNode caseElement : astNode.getChildren(FlexGrammar.CASE_ELEMENT)) {
            nbCase += caseElement.getChildren(FlexGrammar.CASE_LABEL).size();
        }
        if (nbCase < 3) {
            this.addIssue("Replace this \"switch\" statement with \"if\" statements to increase readability.", astNode);
        }
    }
}

