/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;

@Rule(key="XPath")
public class XPathCheck
extends FlexCheck {
    private static final String DEFAULT_XPATH_QUERY = "";
    private static final String DEFAULT_MESSAGE = "The XPath expression matches this piece of code";
    @RuleProperty(key="xpathQuery", description="The XPath query", defaultValue="", type="TEXT")
    public String xpathQuery = "";
    @RuleProperty(key="message", description="The issue message", defaultValue="The XPath expression matches this piece of code")
    public String message = "The XPath expression matches this piece of code";
    private AstNodeXPathQuery<Object> query = null;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @CheckForNull
    public AstNodeXPathQuery<Object> query() {
        if (this.query == null && this.xpathQuery != null && !this.xpathQuery.isEmpty()) {
            try {
                this.query = AstNodeXPathQuery.create(this.xpathQuery);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to initialize the XPath engine, perhaps because of an invalid query: " + this.xpathQuery, e);
            }
        }
        return this.query;
    }

    @Override
    public void visitFile(@Nullable AstNode fileNode) {
        AstNodeXPathQuery<Object> xpath = this.query();
        if (xpath != null && fileNode != null) {
            for (Object object : xpath.selectNodes(fileNode)) {
                if (object instanceof AstNode) {
                    AstNode astNode = (AstNode)object;
                    this.addIssueAtLine(this.message, astNode.getTokenLine());
                    continue;
                }
                if (!Boolean.TRUE.equals(object)) continue;
                this.addFileIssue(this.message);
            }
        }
    }
}

