/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;

public final class Modifiers {
    private Modifiers() {
    }

    public static Set<AstNodeType> getModifiers(@Nullable AstNode attributes) {
        HashSet<AstNodeType> modifiersSet = new HashSet<AstNodeType>();
        if (attributes != null && attributes.is(FlexGrammar.ATTRIBUTES)) {
            for (AstNode attribute : attributes.getChildren(FlexGrammar.ATTRIBUTE)) {
                if (attribute.getFirstChild().is(FlexGrammar.RESERVED_NAMESPACE)) {
                    modifiersSet.add(attribute.getFirstChild(FlexGrammar.RESERVED_NAMESPACE).getFirstChild().getType());
                    continue;
                }
                if (!attribute.getFirstChild().is(FlexGrammar.ATTRIBUTE_EXPR) || attribute.getFirstChild().getNumberOfChildren() != 1) continue;
                modifiersSet.add(attribute.getFirstChild().getFirstChild(FlexGrammar.IDENTIFIER).getFirstChild().getType());
            }
        }
        return modifiersSet;
    }

    public static boolean isNonPublic(Set<AstNodeType> modifiers) {
        for (AstNodeType modifier : modifiers) {
            if (!modifier.equals(FlexKeyword.INTERNAL) && !modifier.equals(FlexKeyword.PROTECTED) && !modifier.equals(FlexKeyword.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(AstNode attriutes) {
        Set<AstNodeType> modifiers = Modifiers.getModifiers(attriutes);
        return modifiers.contains(FlexKeyword.PUBLIC) || !Modifiers.isNonPublic(modifiers);
    }
}

