/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.metrics;

import com.sonar.sslr.api.AstNode;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexVisitorContext;
import org.sonar.flex.metrics.FileLinesVisitor;

public class FileMetrics {
    private final int numberOfStatements;
    private final int numberOfClasses;
    private final int numberOfFunctions;
    private final FileLinesVisitor fileLinesVisitor = new FileLinesVisitor();
    private final String executableLines;

    public FileMetrics(FlexVisitorContext context) {
        AstNode rootTree = context.rootTree();
        Objects.requireNonNull(rootTree, "Cannot compute metrics without a root tree");
        List<AstNode> statements = rootTree.getDescendants(FlexGrammar.DEFAULT_XML_NAMESPACE_DIRECTIVE, FlexGrammar.VARIABLE_DECLARATION_STATEMENT, FlexGrammar.EXPRESSION_STATEMENT, FlexGrammar.IF_STATEMENT, FlexGrammar.FOR_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.WITH_STATEMENT, FlexGrammar.SWITCH_STATEMENT, FlexGrammar.BREAK_STATEMENT, FlexGrammar.CONTINUE_STATEMENT, FlexGrammar.RETURN_STATEMENT, FlexGrammar.THROW_STATEMENT, FlexGrammar.TRY_STATEMENT, FlexGrammar.EMPTY_STATEMENT);
        HashSet<Integer> alreadyMarked = new HashSet<Integer>();
        StringBuilder sb = new StringBuilder();
        for (AstNode descendant : statements) {
            int line = descendant.getTokenLine();
            if (!alreadyMarked.add(line)) continue;
            sb.append(line).append("=1;");
        }
        this.executableLines = sb.toString();
        this.numberOfStatements = statements.size();
        this.numberOfClasses = rootTree.getDescendants(FlexGrammar.CLASS_DEF, FlexGrammar.INTERFACE_DEF).size();
        this.numberOfFunctions = rootTree.getDescendants(FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR).size();
        this.fileLinesVisitor.scanFile(context);
    }

    public Set<Integer> linesOfCode() {
        return this.fileLinesVisitor.linesOfCode();
    }

    public Set<Integer> commentLines() {
        return this.fileLinesVisitor.linesOfComments();
    }

    public Set<Integer> nosonarLines() {
        return this.fileLinesVisitor.noSonarLines();
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int numberOfFunctions() {
        return this.numberOfFunctions;
    }

    public int numberOfStatements() {
        return this.numberOfStatements;
    }

    public String executableLines() {
        return this.executableLines;
    }
}

