/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.flex.cobertura;

import java.io.File;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.flex.cobertura.CoberturaReportParser;

public class CoberturaSensor
implements Sensor {
    private static final Logger LOGGER = Loggers.get(CoberturaSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Flex Cobertura").onlyOnFileType(InputFile.Type.MAIN).onlyOnLanguage("flex");
    }

    public void execute(SensorContext context) {
        String[] reportPaths = context.config().getStringArray("sonar.flex.cobertura.reportPaths");
        if (reportPaths.length > 0) {
            for (String reportPath : reportPaths) {
                File xmlFile = CoberturaSensor.getIOFile(context.fileSystem(), reportPath);
                if (xmlFile.exists()) {
                    LOGGER.info("Analyzing Cobertura report: {}", (Object)reportPath);
                    CoberturaReportParser.parseReport(xmlFile, context);
                    continue;
                }
                LOGGER.info("Cobertura xml report not found: {}", (Object)reportPath);
            }
        } else {
            LOGGER.info("No Cobertura report provided (see '{}' property)", (Object)"sonar.flex.cobertura.reportPaths");
        }
    }

    private static File getIOFile(FileSystem fileSystem, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(fileSystem.baseDir(), path);
        }
        return file;
    }
}

