/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import java.util.List;
import java.util.Objects;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.vm.Machine;
import org.sonar.sslr.internal.vm.MachineStack;

public abstract class Instruction {
    private static final Instruction RET = new RetInstruction();
    private static final Instruction BACKTRACK = new BacktrackInstruction();
    private static final Instruction END = new EndInstruction();
    private static final Instruction FAIL_TWICE = new FailTwiceInstruction();
    private static final Instruction IGNORE_ERRORS = new IgnoreErrorsInstruction();

    public static void addAll(List<Instruction> list, Instruction[] array) {
        for (Instruction i : array) {
            list.add(i);
        }
    }

    public static Instruction jump(int offset) {
        return new JumpInstruction(offset);
    }

    public static Instruction call(int offset, Matcher matcher) {
        return new CallInstruction(offset, matcher);
    }

    public static Instruction ret() {
        return RET;
    }

    public static Instruction backtrack() {
        return BACKTRACK;
    }

    public static Instruction end() {
        return END;
    }

    public static Instruction choice(int offset) {
        return new ChoiceInstruction(offset);
    }

    public static Instruction predicateChoice(int offset) {
        return new PredicateChoiceInstruction(offset);
    }

    public static Instruction commit(int offset) {
        return new CommitInstruction(offset);
    }

    public static Instruction commitVerify(int offset) {
        return new CommitVerifyInstruction(offset);
    }

    public static Instruction failTwice() {
        return FAIL_TWICE;
    }

    public static Instruction backCommit(int offset) {
        return new BackCommitInstruction(offset);
    }

    public static Instruction ignoreErrors() {
        return IGNORE_ERRORS;
    }

    public abstract void execute(Machine var1);

    public static final class BackCommitInstruction
    extends Instruction {
        private final int offset;

        public BackCommitInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            MachineStack stack = machine.peek();
            machine.setIndex(stack.index());
            machine.setIgnoreErrors(stack.isIgnoreErrors());
            machine.pop();
            machine.jump(this.offset);
        }

        public String toString() {
            return "BackCommit " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof BackCommitInstruction && this.offset == ((BackCommitInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class FailTwiceInstruction
    extends Instruction {
        @Override
        public void execute(Machine machine) {
            machine.setIndex(machine.peek().index());
            machine.pop();
            machine.backtrack();
        }

        public String toString() {
            return "FailTwice";
        }
    }

    public static final class EndInstruction
    extends Instruction {
        @Override
        public void execute(Machine machine) {
            machine.setAddress(-1);
        }

        public String toString() {
            return "End";
        }
    }

    public static final class BacktrackInstruction
    extends Instruction {
        @Override
        public void execute(Machine machine) {
            machine.backtrack();
        }

        public String toString() {
            return "Backtrack";
        }
    }

    public static final class RetInstruction
    extends Instruction {
        @Override
        public void execute(Machine machine) {
            machine.createNode();
            MachineStack stack = machine.peek();
            machine.setIgnoreErrors(stack.isIgnoreErrors());
            machine.setAddress(stack.address());
            machine.popReturn();
        }

        public String toString() {
            return "Ret";
        }
    }

    public static final class CommitVerifyInstruction
    extends Instruction {
        private final int offset;

        public CommitVerifyInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            if (machine.getIndex() == machine.peek().index()) {
                throw new GrammarException("The inner part of ZeroOrMore and OneOrMore must not allow empty matches");
            }
            machine.peek().parent().subNodes().addAll(machine.peek().subNodes());
            machine.pop();
            machine.jump(this.offset);
        }

        public String toString() {
            return "CommitVerify " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof CommitVerifyInstruction && this.offset == ((CommitVerifyInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class CommitInstruction
    extends Instruction {
        private final int offset;

        public CommitInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            machine.peek().parent().subNodes().addAll(machine.peek().subNodes());
            machine.pop();
            machine.jump(this.offset);
        }

        public String toString() {
            return "Commit " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof CommitInstruction && this.offset == ((CommitInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class PredicateChoiceInstruction
    extends Instruction {
        private final int offset;

        public PredicateChoiceInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            machine.pushBacktrack(this.offset);
            machine.setIgnoreErrors(true);
            machine.jump(1);
        }

        public String toString() {
            return "PredicateChoice " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof PredicateChoiceInstruction && this.offset == ((PredicateChoiceInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class IgnoreErrorsInstruction
    extends Instruction {
        @Override
        public void execute(Machine machine) {
            machine.setIgnoreErrors(true);
            machine.jump(1);
        }

        public String toString() {
            return "IgnoreErrors";
        }
    }

    public static final class ChoiceInstruction
    extends Instruction {
        private final int offset;

        public ChoiceInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            machine.pushBacktrack(this.offset);
            machine.jump(1);
        }

        public String toString() {
            return "Choice " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof ChoiceInstruction && this.offset == ((ChoiceInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class CallInstruction
    extends Instruction {
        private final int offset;
        private final Matcher matcher;

        public CallInstruction(int offset, Matcher matcher) {
            this.offset = offset;
            this.matcher = matcher;
        }

        @Override
        public void execute(Machine machine) {
            machine.pushReturn(1, this.matcher, this.offset);
        }

        public String toString() {
            return "Call " + this.offset;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallInstruction) {
                CallInstruction other = (CallInstruction)obj;
                return this.offset == other.offset && Objects.equals(this.matcher, other.matcher);
            }
            return false;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class JumpInstruction
    extends Instruction {
        private final int offset;

        public JumpInstruction(int offset) {
            this.offset = offset;
        }

        @Override
        public void execute(Machine machine) {
            machine.jump(this.offset);
        }

        public String toString() {
            return "Jump " + this.offset;
        }

        public boolean equals(Object obj) {
            return obj instanceof JumpInstruction && this.offset == ((JumpInstruction)obj).offset;
        }

        public int hashCode() {
            return this.offset;
        }
    }
}

