/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentType;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;
    private final NodeClient client;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, AutoCreateIndex autoCreateIndex, NodeClient client) {
        super("indices:data/write/update", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateRequest::new);
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
        this.clusterService = clusterService;
    }

    @Override
    protected String executor(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().getIndexMetadata().isSystem() ? "system_write" : "write";
    }

    @Override
    protected UpdateResponse newResponse(StreamInput in) throws IOException {
        return new UpdateResponse(in);
    }

    @Override
    protected boolean retryOnFailure(Exception e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected void resolveRequest(ClusterState state, UpdateRequest request) {
        TransportUpdateAction.resolveAndValidateRouting(state.metadata(), request.concreteIndex(), request);
    }

    public static void resolveAndValidateRouting(Metadata metadata, String concreteIndex, UpdateRequest request) {
        request.routing(metadata.resolveWriteIndexRouting(request.routing(), request.index()));
        if (request.routing() == null && metadata.routingRequired(concreteIndex)) {
            throw new RoutingMissingException(concreteIndex, request.type(), request.id());
        }
    }

    @Override
    protected void doExecute(final Task task, final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (request.isRequireAlias() && !this.clusterService.state().getMetadata().hasAlias(request.index())) {
            throw new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
        }
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            this.client.admin().indices().create((CreateIndexRequest)new CreateIndexRequest().index(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(task, request, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(task, request, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    private void innerExecute(Task task, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) {
        ShardRouting shard;
        if (request.getShardId() != null) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(request.getShardId().getId()).primaryShardIt();
        }
        IndexMetadata indexMetadata = clusterState.metadata().index(request.concreteIndex());
        if (indexMetadata == null) {
            throw new IndexNotFoundException(request.concreteIndex());
        }
        IndexRouting indexRouting = IndexRouting.fromIndexMetadata(indexMetadata);
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(clusterState, request.concreteIndex(), indexRouting, request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), Collections.singletonList(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), Collections.emptyList());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener, int retryCount) {
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        UpdateHelper.Result result = this.updateHelper.prepare(request, indexShard, this.threadPool::absoluteTimeInMillis);
        switch (result.getResponseResult()) {
            case CREATED: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                BytesReference upsertSourceBytes = upsertRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(upsertRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true, upsertRequest.getContentType());
                        update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), upsertSourceBytes));
                    } else {
                        update.setGetResult(null);
                    }
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                BytesReference indexSourceBytes = indexRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(indexRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(deleteRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case NOOP: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(shardId.getIndex());
                if (indexServiceOrNull != null && (shard = indexService.getShardOrNull(shardId.getId())) != null) {
                    shard.noopUpdate(request.type());
                }
                listener.onResponse(update);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal result " + result.getResponseResult());
            }
        }
    }

    private void handleUpdateFailureWithRetry(ActionListener<UpdateResponse> listener, UpdateRequest request, Exception failure, int retryCount) {
        Throwable cause = ExceptionsHelper.unwrapCause(failure);
        if (cause instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
            ExecutorService executor;
            VersionConflictEngineException versionConflictEngineException = (VersionConflictEngineException)cause;
            this.logger.trace("Retry attempt [{}] of [{}] on version conflict on [{}][{}][{}]", (Object)(retryCount + 1), (Object)request.retryOnConflict(), (Object)request.index(), (Object)request.getShardId(), (Object)request.id());
            try {
                executor = this.threadPool.executor(this.executor(request.getShardId()));
            }
            catch (Exception e) {
                e.addSuppressed(versionConflictEngineException);
                listener.onFailure(e);
                return;
            }
            executor.execute(ActionRunnable.wrap(listener, l -> this.shardOperation(request, (ActionListener<UpdateResponse>)l, retryCount + 1)));
            return;
        }
        listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
    }
}

