/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.elasticsearch.geometry.Rectangle;

public class SphericalMercatorUtils {
    public static final double MERCATOR_BOUNDS = 2.003750834E7;
    private static final double MERCATOR_FACTOR = 111319.49077777777;
    private static final double LAT_LOWER_LIMIT = Math.nextUp(-90.0);

    public static double lonToSphericalMercator(double lon) {
        return lon * 111319.49077777777;
    }

    public static double latToSphericalMercator(double lat) {
        double y = Math.log(Math.tan((90.0 + Math.max(lat, LAT_LOWER_LIMIT)) * Math.PI / 360.0)) / (Math.PI / 180);
        return y * 111319.49077777777;
    }

    public static Rectangle recToSphericalMercator(Rectangle r) {
        return new Rectangle(SphericalMercatorUtils.lonToSphericalMercator(r.getMinLon()), SphericalMercatorUtils.lonToSphericalMercator(r.getMaxLon()), SphericalMercatorUtils.latToSphericalMercator(r.getMaxLat()), SphericalMercatorUtils.latToSphericalMercator(r.getMinLat()));
    }

    private SphericalMercatorUtils() {
    }
}

