/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.JavaDateMathParser;

class JavaDateFormatter
implements DateFormatter {
    private static final BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> DEFAULT_ROUND_UP = (builder, parser) -> {
        String parserAsString = parser.toString();
        if (parserAsString.contains(ChronoField.DAY_OF_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.DAY_OF_YEAR, 1L);
        } else if (!parserAsString.contains(IsoFields.WEEK_BASED_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
            builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        }
        if (parserAsString.contains(ChronoField.CLOCK_HOUR_OF_AMPM.toString())) {
            builder.parseDefaulting(ChronoField.CLOCK_HOUR_OF_AMPM, 11L);
            builder.parseDefaulting(ChronoField.AMPM_OF_DAY, 1L);
        } else if (parserAsString.contains(ChronoField.HOUR_OF_AMPM.toString())) {
            builder.parseDefaulting(ChronoField.HOUR_OF_AMPM, 11L);
            builder.parseDefaulting(ChronoField.AMPM_OF_DAY, 1L);
        } else {
            builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 23L);
        }
        builder.parseDefaulting(ChronoField.MINUTE_OF_HOUR, 59L);
        builder.parseDefaulting(ChronoField.SECOND_OF_MINUTE, 59L);
        builder.parseDefaulting(ChronoField.NANO_OF_SECOND, 999999999L);
    };
    private final String format;
    private final DateTimeFormatter printer;
    private final DateTimeFormatter[] parsers;
    private final RoundUpFormatter roundupParser;

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        this(format, printer, DEFAULT_ROUND_UP, parsers);
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer, DateTimeFormatter ... parsers) {
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        this.printer = printer;
        this.format = format;
        this.parsers = JavaDateFormatter.parsersArray(printer, parsers);
        this.roundupParser = JavaDateFormatter.createRoundUpParser(format, roundupParserConsumer, this.locale(), this.parsers);
    }

    private static DateTimeFormatter[] parsersArray(DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        if (parsers.length == 0) {
            return new DateTimeFormatter[]{printer};
        }
        ZoneId zoneId = parsers[0].getZone();
        Locale locale = parsers[0].getLocale();
        for (int i = 1; i < parsers.length; ++i) {
            DateTimeFormatter parser = parsers[i];
            if (!Objects.equals(parser.getZone(), zoneId)) {
                throw new IllegalArgumentException("formatters must have the same time zone");
            }
            if (Objects.equals(parser.getLocale(), locale)) continue;
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        return parsers;
    }

    private static RoundUpFormatter createRoundUpParser(String format, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer, Locale locale, DateTimeFormatter[] parsers) {
        if (!format.contains("||")) {
            return new RoundUpFormatter(format, JavaDateFormatter.mapParsers(parser -> {
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                builder.append((DateTimeFormatter)parser);
                roundupParserConsumer.accept(builder, (DateTimeFormatter)parser);
                return builder.toFormatter(locale);
            }, parsers));
        }
        return null;
    }

    public static DateFormatter combined(String input, List<DateFormatter> formatters) {
        assert (formatters.size() > 0);
        ArrayList parsers = new ArrayList(formatters.size());
        ArrayList roundUpParsers = new ArrayList(formatters.size());
        DateTimeFormatter printer = null;
        for (DateFormatter formatter : formatters) {
            assert (formatter instanceof JavaDateFormatter);
            JavaDateFormatter javaDateFormatter = (JavaDateFormatter)formatter;
            if (printer == null) {
                printer = javaDateFormatter.getPrinter();
            }
            Collections.addAll(parsers, javaDateFormatter.parsers);
            Collections.addAll(roundUpParsers, javaDateFormatter.getRoundupParser().parsers);
        }
        return new JavaDateFormatter(input, printer, roundUpParsers.toArray(new DateTimeFormatter[0]), parsers.toArray(new DateTimeFormatter[0]));
    }

    private JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter[] roundUpParsers, DateTimeFormatter[] parsers) {
        this(format, printer, new RoundUpFormatter(format, roundUpParsers), parsers);
    }

    private JavaDateFormatter(String format, DateTimeFormatter printer, RoundUpFormatter roundupParser, DateTimeFormatter[] parsers) {
        this.format = format;
        this.printer = printer;
        this.roundupParser = roundupParser;
        this.parsers = parsers;
    }

    JavaDateFormatter getRoundupParser() {
        return this.roundupParser;
    }

    DateTimeFormatter getPrinter() {
        return this.printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        try {
            return this.doParse(input);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    private TemporalAccessor doParse(String input) {
        if (this.parsers.length > 1) {
            for (DateTimeFormatter formatter : this.parsers) {
                ParsePosition pos = new ParsePosition(0);
                Object object = formatter.toFormat().parseObject(input, pos);
                if (!JavaDateFormatter.parsingSucceeded(object, input, pos)) continue;
                return (TemporalAccessor)object;
            }
            throw new DateTimeParseException("Failed to parse with all enclosed parsers", input, 0);
        }
        return this.parsers[0].parse(input);
    }

    private static boolean parsingSucceeded(Object object, String input, ParsePosition pos) {
        return object != null && pos.getIndex() == input.length();
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.zone())) {
            return this;
        }
        return this.mapParsers(p -> p.withZone(zoneId));
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.locale())) {
            return this;
        }
        return this.mapParsers(p -> p.withLocale(locale));
    }

    private JavaDateFormatter mapParsers(UnaryOperator<DateTimeFormatter> mapping) {
        return new JavaDateFormatter(this.format, (DateTimeFormatter)mapping.apply(this.printer), JavaDateFormatter.mapParsers(mapping, this.roundupParser.parsers), JavaDateFormatter.mapParsers(mapping, this.parsers));
    }

    private static DateTimeFormatter[] mapParsers(UnaryOperator<DateTimeFormatter> mapping, DateTimeFormatter[] parsers) {
        DateTimeFormatter[] res = new DateTimeFormatter[parsers.length];
        for (int i = 0; i < parsers.length; ++i) {
            res[i] = (DateTimeFormatter)mapping.apply(parsers[i]);
        }
        return res;
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(DateFormatters.from(accessor));
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this, this.getRoundupParser());
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }

    private static final class RoundUpFormatter
    extends JavaDateFormatter {
        RoundUpFormatter(String format, DateTimeFormatter[] roundUpParsers) {
            super(format, roundUpParsers[0], (RoundUpFormatter)null, roundUpParsers);
        }

        @Override
        JavaDateFormatter getRoundupParser() {
            throw new UnsupportedOperationException("RoundUpFormatter does not have another roundUpFormatter");
        }
    }
}

