/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;

public final class Pipeline {
    public static final String DESCRIPTION_KEY = "description";
    public static final String PROCESSORS_KEY = "processors";
    public static final String VERSION_KEY = "version";
    public static final String ON_FAILURE_KEY = "on_failure";
    public static final String META_KEY = "_meta";
    private static final Logger logger = LogManager.getLogger(Pipeline.class);
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final Integer version;
    @Nullable
    private final Map<String, Object> metadata;
    private final CompoundProcessor compoundProcessor;
    private final IngestMetric metrics;
    private final LongSupplier relativeTimeProvider;

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, @Nullable Map<String, Object> metadata, CompoundProcessor compoundProcessor) {
        this(id, description, version, metadata, compoundProcessor, System::nanoTime);
    }

    Pipeline(String id, @Nullable String description, @Nullable Integer version, @Nullable Map<String, Object> metadata, CompoundProcessor compoundProcessor, LongSupplier relativeTimeProvider) {
        this.id = id;
        this.description = description;
        this.metadata = metadata;
        this.compoundProcessor = compoundProcessor;
        this.version = version;
        this.metrics = new IngestMetric();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    public static Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories, ScriptService scriptService) throws Exception {
        String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, DESCRIPTION_KEY);
        Integer version = ConfigurationUtils.readIntProperty(null, null, config, VERSION_KEY, null);
        Map<String, Object> metadata = ConfigurationUtils.readOptionalMap(null, null, config, META_KEY);
        List<Map<String, Object>> processorConfigs = ConfigurationUtils.readList(null, null, config, PROCESSORS_KEY);
        List<Processor> processors = ConfigurationUtils.readProcessorConfigs(processorConfigs, scriptService, processorFactories);
        List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, ON_FAILURE_KEY);
        List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories);
        if (!config.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
        }
        if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] cannot have an empty on_failure option defined", new Object[0]);
        }
        CompoundProcessor compoundProcessor = new CompoundProcessor(false, Collections.unmodifiableList(processors), Collections.unmodifiableList(onFailureProcessors));
        return new Pipeline(id, description, version, metadata, compoundProcessor);
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        AtomicBoolean listenerHasBeenCalled = new AtomicBoolean(false);
        this.metrics.preIngest();
        this.compoundProcessor.execute(ingestDocument, (result, e) -> {
            if (listenerHasBeenCalled.getAndSet(true)) {
                logger.warn("A listener was unexpectedly called more than once", (Throwable)new RuntimeException());
                assert (false) : "A listener was unexpectedly called more than once";
            } else {
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                this.metrics.postIngest(ingestTimeInNanos);
                if (e != null) {
                    this.metrics.ingestFailed();
                }
                handler.accept((IngestDocument)result, (Exception)e);
            }
        });
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public CompoundProcessor getCompoundProcessor() {
        return this.compoundProcessor;
    }

    public List<Processor> getProcessors() {
        return this.compoundProcessor.getProcessors();
    }

    public List<Processor> getOnFailureProcessors() {
        return this.compoundProcessor.getOnFailureProcessors();
    }

    public List<Processor> flattenAllProcessors() {
        return this.compoundProcessor.flattenProcessors();
    }

    public IngestMetric getMetrics() {
        return this.metrics;
    }
}

