/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;

class MatchAllQueryToFilterAdapter
extends QueryToFilterAdapter<MatchAllDocsQuery> {
    private int resultsFromMetadata;

    MatchAllQueryToFilterAdapter(IndexSearcher searcher, String key, MatchAllDocsQuery query) {
        super(searcher, key, query);
    }

    @Override
    QueryToFilterAdapter<?> union(Query extraQuery) throws IOException {
        return QueryToFilterAdapter.build(this.searcher(), this.key(), extraQuery);
    }

    @Override
    IntPredicate matchingDocIds(LeafReaderContext ctx) throws IOException {
        return l -> true;
    }

    @Override
    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
        if (this.countCanUseMetadata(counter, live)) {
            ++this.resultsFromMetadata;
            return ctx.reader().maxDoc();
        }
        return super.count(ctx, counter, live);
    }

    @Override
    void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("specialized_for", "match_all");
        add.accept("results_from_metadata", this.resultsFromMetadata);
    }
}

