/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class KotlinFileLocator {
    private static final Logger LOGGER = Loggers.get(KotlinFileLocator.class);
    private static final String SHEBANG_LINE = "#![^\n]*+";
    private static final String DELIMITED_COMMENT = "/\\*(?:(?!\\*/).)*+\\*/";
    private static final String LINE_COMMENT = "//[^\n]*+";
    private static final String STRING_LITERAL = "\"([^\"]|(?<=\\\\)\")*+\"";
    private static final String MULTILINE_STRING_LITERAL = "\"\"\"(?:(?!\"\"\").)*+\"\"\"";
    private static final String PRE_PACKAGE = "(?s)^(#![^\n]*+)?(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|\"([^\"]|(?<=\\\\)\")*+\"|\"\"\"(?:(?!\"\"\").)*+\"\"\"|(?!package).)*+";
    private static final String HIDDEN = "(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+";
    private static final String IDENTIFIER = "([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`)";
    private static final String PACKAGE_DECLARATION_REGEX = "package(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+(?<packageName>([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`)((/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+\\.(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`))*+)";
    private static final Pattern PACKAGE_REGEX = Pattern.compile("(?s)^(#![^\n]*+)?(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|\"([^\"]|(?<=\\\\)\")*+\"|\"\"\"(?:(?!\"\"\").)*+\"\"\"|(?!package).)*+package(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+(?<packageName>([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`)((/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+\\.(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`))*+)");
    private static final Pattern FIRST_IDENTIFIER_REGEX = Pattern.compile("(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+(?<firstIdentifier>([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`))");
    private static final Pattern NEXT_IDENTIFIER_REGEX = Pattern.compile("(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+\\.(/\\*(?:(?!\\*/).)*+\\*/|//[^\n]*+|[\\u0020\\u0009\\u000c]|\r?\n)*+(?<nextIdentifier>([\\p{Lu}\\p{Lo}\\p{Ll}\\p{Lt}\\p{Lm}_\\p{Nd}]++|`[^\r\n`]++`))");
    private final Map<String, InputFile> fqnToInputFile = new HashMap<String, InputFile>();
    private boolean populated = false;
    private final Stream<InputFile> inputFileStream;

    public KotlinFileLocator(Stream<InputFile> kotlinInputFileStream) {
        this.inputFileStream = kotlinInputFileStream;
    }

    public InputFile getInputFile(String packagePath, String fileName) {
        String fqn = packagePath.replace("/", ".") + "." + fileName;
        if (!this.populated) {
            this.populate();
        }
        return this.fqnToInputFile.get(fqn);
    }

    private void populate() {
        this.inputFileStream.forEach(f -> {
            try {
                String packageName = KotlinFileLocator.getPackage(f.contents());
                if (packageName != null) {
                    String key = packageName + "." + f.filename();
                    this.fqnToInputFile.put(key, (InputFile)f);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        });
        this.populated = true;
    }

    private static String getPackage(String content) {
        Matcher matcher = PACKAGE_REGEX.matcher(content);
        if (matcher.find()) {
            StringBuilder resolvedPackage = new StringBuilder();
            String packageName = matcher.group("packageName");
            Matcher firstIdentifierMatcher = FIRST_IDENTIFIER_REGEX.matcher(packageName);
            firstIdentifierMatcher.find();
            resolvedPackage.append(KotlinFileLocator.removeBackticks(firstIdentifierMatcher.group("firstIdentifier")));
            Matcher nextIdentifierMatcher = NEXT_IDENTIFIER_REGEX.matcher(packageName);
            while (nextIdentifierMatcher.find()) {
                resolvedPackage.append(".");
                resolvedPackage.append(KotlinFileLocator.removeBackticks(nextIdentifierMatcher.group("nextIdentifier")));
            }
            return resolvedPackage.toString();
        }
        return null;
    }

    private static String removeBackticks(String s) {
        if (s.startsWith("`") && s.endsWith("`")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

