/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $this$toTypeProjection) {
        boolean bl = $this$toTypeProjection.isConsistent();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            DescriptorRenderer descriptorRenderer2 = DescriptorRenderer.Companion.withOptions(toTypeProjection.1.descriptorRenderer.1.INSTANCE);
            String string2 = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer2.render($this$toTypeProjection.getTypeParameter()) + ": <" + descriptorRenderer2.renderType($this$toTypeProjection.getInProjection()) + ", " + descriptorRenderer2.renderType($this$toTypeProjection.getOutProjection()) + ">] was found";
            throw new AssertionError((Object)string2);
        }
        return Intrinsics.areEqual($this$toTypeProjection.getInProjection(), $this$toTypeProjection.getOutProjection()) || $this$toTypeProjection.getTypeParameter().getVariance() == Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl($this$toTypeProjection.getInProjection()) : (KotlinBuiltIns.isNothing($this$toTypeProjection.getInProjection()) && $this$toTypeProjection.getTypeParameter().getVariance() != Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection()) : (KotlinBuiltIns.isNullableAny($this$toTypeProjection.getOutProjection()) ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.IN_VARIANCE), $this$toTypeProjection.getInProjection()) : (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $this$toTypeArgument, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        switch (WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameter.getVariance(), $this$toTypeArgument).ordinal()]) {
            case 1: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
                KotlinType kotlinType2 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "typeParameter.builtIns.nullableAnyType");
                typeArgument = new TypeArgument(typeParameter, kotlinType, simpleType2);
                break;
            }
            case 3: {
                SimpleType simpleType3 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkNotNullExpressionValue(simpleType3, "typeParameter.builtIns.nothingType");
                KotlinType kotlinType = simpleType3;
                KotlinType kotlinType3 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType3, "type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection, boolean approximateContravariant) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "typeProjection.type");
        KotlinType type2 = kotlinType;
        if (!TypeUtils.contains(type2, approximateCapturedTypesIfNecessary.1.INSTANCE)) {
            return typeProjection;
        }
        Variance variance = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)variance, "typeProjection.projectionKind");
        Variance howThisTypeIsUsed = variance;
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            ApproximationBounds<KotlinType> approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        if (approximateContravariant) {
            KotlinType approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2).getLower();
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                Intrinsics.checkNotNullParameter(key, "key");
                CapturedTypeConstructor capturedTypeConstructor = key instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)key : null;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor;
                if (capturedTypeConstructor2.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, capturedTypeConstructor2.getProjection().getType());
                }
                return capturedTypeConstructor2.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(object : TypeCons\u2026ojection\n        }\n    })");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor3.substituteWithoutApproximation(typeProjection);
    }

    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        KotlinType kotlinType;
        boolean lowerBoundIsTrivial;
        ArrayList<TypeArgument> upperBoundArguments;
        ArrayList<TypeArgument> lowerBoundArguments;
        block14: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            if (FlexibleTypesKt.isFlexible(type2)) {
                ApproximationBounds<KotlinType> boundsForFlexibleLower = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(type2));
                ApproximationBounds<KotlinType> boundsForFlexibleUpper = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(type2));
                return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getLower()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getLower())), type2), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getUpper()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getUpper())), type2));
            }
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor2).getProjection();
                KotlinType kotlinType2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "typeProjection.type");
                KotlinType bound = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(kotlinType2, type2);
                switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getProjectionKind().ordinal()]) {
                    case 2: {
                        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(type2).getNullableAnyType();
                        Intrinsics.checkNotNullExpressionValue(simpleType2, "type.builtIns.nullableAnyType");
                        approximationBounds = new ApproximationBounds<KotlinType>(bound, simpleType2);
                        break;
                    }
                    case 3: {
                        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
                        Intrinsics.checkNotNullExpressionValue(simpleType3, "type.builtIns.nothingType");
                        approximationBounds = new ApproximationBounds<KotlinType>(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType3, type2), bound);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty() || type2.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<TypeArgument>();
            upperBoundArguments = new ArrayList<TypeArgument>();
            Iterable iterable = type2.getArguments();
            List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "typeConstructor.parameters");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list2)) {
                TypeProjection typeProjection = (TypeProjection)pair.component1();
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)pair.component2();
                Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                TypeArgument typeArgument = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameter);
                if (typeProjection.isStarProjection()) {
                    lowerBoundArguments.add(typeArgument);
                    upperBoundArguments.add(typeArgument);
                    continue;
                }
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(typeArgument);
                TypeArgument lower = approximationBounds.component1();
                TypeArgument upper = approximationBounds.component2();
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable $this$any$iv = lowerBoundArguments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeArgument it = (TypeArgument)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isConsistent())) continue;
                    bl = true;
                    break block14;
                }
                bl = lowerBoundIsTrivial = false;
            }
        }
        if (lowerBoundIsTrivial) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
            Intrinsics.checkNotNullExpressionValue(simpleType4, "type.builtIns.nothingType");
            kotlinType = simpleType4;
        } else {
            kotlinType = CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)lowerBoundArguments);
        }
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $this$replaceTypeArguments, List<TypeArgument> newTypeArguments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        boolean bl2 = bl = $this$replaceTypeArguments.getArguments().size() == newTypeArguments.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = false;
            String $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = "Incorrect type arguments " + newTypeArguments;
            throw new AssertionError((Object)$i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22);
        }
        Iterable iterable = newTypeArguments;
        KotlinType kotlinType = $this$replaceTypeArguments;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeArgument typeArgument = (TypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it));
        }
        return TypeSubstitutionKt.replace$default(kotlinType, (List)destination$iv$iv, null, null, 6, null);
    }

    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType inLower = approximationBounds.component1();
        KotlinType inUpper = approximationBounds.component2();
        ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        KotlinType outLower = approximationBounds2.component1();
        KotlinType outUpper = approximationBounds2.component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), inUpper, outLower), new TypeArgument(typeArgument.getTypeParameter(), inLower, outUpper));
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument $this_toTypeProjection, Variance variance) {
        return variance == $this_toTypeProjection.getTypeParameter().getVariance() ? Variance.INVARIANT : variance;
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType $this$approximateCapturedTypes_u24makeNullableIfNeeded, KotlinType $type) {
        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded($this$approximateCapturedTypes_u24makeNullableIfNeeded, $type.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNullableIfNeeded(this, type.isMarkedNullable)");
        return kotlinType;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

