/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.CachedValueBase;
import org.jetbrains.kotlin.com.intellij.util.CachedValueLeakChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValueStabilityChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
    private Set<Key<?>> myKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        return parameterizedCachedValue;
    }

    @Override
    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value2;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        if ((value2 = dataHolder.getUserData(key)) instanceof CachedValueBase && ((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject)) {
            Getter<T> data2 = value2.getUpToDateOrNull();
            if (data2 != null) {
                return data2.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value2.getValueProvider(), key);
        }
        if (value2 == null) {
            value2 = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value2) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return ((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value2);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue<T> existing = dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value2);
            return value2;
        }
    }

    @Override
    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(11);
        }
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProvider(provider, key, dh);
        CachedValue<T> value2 = this.createCachedValue(provider, trackValue);
        assert (((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject));
        return value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isClearedOnPluginUnload";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

