/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.helpers.SimplifiedRegexCharacterClass;

public class DuplicatesInCharacterClassFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Remove duplicates in this character class.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public DuplicatesInCharacterClassFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
        LinkedHashSet<RegexSyntaxElement> duplicates = new LinkedHashSet<RegexSyntaxElement>();
        SimplifiedRegexCharacterClass characterClass = new SimplifiedRegexCharacterClass();
        for (CharacterClassElementTree element : tree.getCharacterClasses()) {
            List<RegexSyntaxElement> intersections = new SimplifiedRegexCharacterClass(element).findIntersections(characterClass);
            if (!intersections.isEmpty()) {
                duplicates.addAll(intersections);
                duplicates.add(element);
            }
            characterClass.add(element);
        }
        if (!duplicates.isEmpty()) {
            List<RegexIssueLocation> secondaries = duplicates.stream().skip(1L).map(duplicate -> new RegexIssueLocation((RegexSyntaxElement)duplicate, "Additional duplicate")).collect(Collectors.toList());
            this.regexElementIssueReporter.report((RegexSyntaxElement)duplicates.iterator().next(), MESSAGE, null, secondaries);
        }
        super.visitCharacterClassUnion(tree);
    }
}

